/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheck.class}, property={"service.vendor=The Apache Software Foundation", "hc.name=Scheduler Health Check", "hc.mbean.name=slingCommonsSchedulerHealthCheck"}, immediate=true)
@Designate(ocd=Config.class)
public class SchedulerHealthCheck
implements HealthCheck {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private MetricRegistry metricRegistry;
    private static final long DEFAULT_MAX_QUARTZJOB_DURATION_ACCCEPTABLE = 60000L;
    private long maxQuartzJobDurationAcceptable;

    @Activate
    protected void activate(Config config) {
        this.configure(config);
    }

    @Modified
    protected void modified(Config config) {
        this.configure(config);
    }

    protected void configure(Config config) {
        this.maxQuartzJobDurationAcceptable = config.max_quartzJob_duration_acceptable();
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        try {
            SortedMap oldestGaugeSet;
            Iterator it;
            long runningCount = 0L;
            SortedMap runningCntSet = this.metricRegistry.getCounters(new MetricFilter(){

                public boolean matches(String name, Metric metric) {
                    return name.equals("commons.scheduler.running.jobs");
                }
            });
            if (runningCntSet != null && (it = runningCntSet.values().iterator()).hasNext()) {
                runningCount = ((Counter)it.next()).getCount();
            }
            if ((oldestGaugeSet = this.metricRegistry.getGauges(new MetricFilter(){

                public boolean matches(String name, Metric metric) {
                    return name.equals("commons.scheduler.oldest.running.job.millis");
                }
            })).isEmpty()) {
                resultLog.warn("Sling Scheduler cannot find any metrics gauge starting with {}", new Object[]{"commons.scheduler.oldest.running.job.millis"});
            } else {
                long oldestRunningJobInMillis = (Long)((Gauge)oldestGaugeSet.values().iterator().next()).getValue();
                if (oldestRunningJobInMillis <= -1L) {
                    resultLog.info("Sling Scheduler has no Quartz-Job running at this moment (number of currently runnning Quartz-Jobs: {}).", new Object[]{Math.max(0L, runningCount)});
                } else if (oldestRunningJobInMillis > this.maxQuartzJobDurationAcceptable) {
                    String slowPrefix = "commons.scheduler.oldest.running.job.millis.slow.";
                    MetricFilter filter = new MetricFilter(){

                        public boolean matches(String name, Metric metric) {
                            return name.startsWith("commons.scheduler.oldest.running.job.millis.slow.");
                        }
                    };
                    SortedMap allGaugeSet = this.metricRegistry.getGauges(filter);
                    if (allGaugeSet.isEmpty()) {
                        resultLog.critical("Sling Scheduler has Quartz-Job(s) that is/are running for more than the acceptable {}ms: {}ms (number of currently runnning Quartz-Jobs: {}). Thread-dumps can help determine exact long-running Quartz-Job.", new Object[]{this.maxQuartzJobDurationAcceptable, oldestRunningJobInMillis, Math.max(0L, runningCount)});
                    } else {
                        StringBuffer slowNames = new StringBuffer();
                        Iterator it2 = allGaugeSet.entrySet().iterator();
                        int numSlow = 0;
                        while (it2.hasNext()) {
                            Map.Entry e = it2.next();
                            Gauge slowGauge = (Gauge)e.getValue();
                            long millis = (Long)slowGauge.getValue();
                            if (millis < 0L) continue;
                            if (numSlow++ > 0) {
                                slowNames.append(", ");
                            }
                            slowNames.append(((String)e.getKey()).substring("commons.scheduler.oldest.running.job.millis.slow.".length()));
                            slowNames.append("=").append(millis).append("ms");
                        }
                        resultLog.critical("Sling Scheduler has Quartz-Job(s) that is/are running for more than the acceptable {}ms: {}ms (number of currently runnning Quartz-Jobs: {}). Currently {} running slow Job(s): {}. Thread-dumps can help determine further details about long-running Quartz-Job.", new Object[]{this.maxQuartzJobDurationAcceptable, oldestRunningJobInMillis, Math.max(0L, runningCount), numSlow, slowNames.toString()});
                    }
                } else {
                    resultLog.info("Sling Scheduler has no long-running (more than acceptable {}ms) Quartz-Job, longest running Quartz-Job is {}ms at this moment (number of currently runnning Quartz-Jobs: {}).", new Object[]{this.maxQuartzJobDurationAcceptable, oldestRunningJobInMillis, Math.max(0L, runningCount)});
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("execute: metrics invocation failed with exception: {}", (Throwable)e);
            resultLog.healthCheckError("execute: metrics invocation failed with exception: {}", new Object[]{e});
        }
        return new Result((ResultLog)resultLog);
    }

    @ObjectClassDefinition(name="Apache Sling Scheduler Health Check Config", description="Apache Sling Scheduler Health Check Config")
    public static @interface Config {
        @AttributeDefinition(name="Acceptable Duration Millis", description="Maximum a job should take (in millis) for it to be acceptable. Best to set this equal or higher to org.apache.sling.commons.scheduler.impl.QuartzScheduler.slowThresholdMillis")
        public long max_quartzJob_duration_acceptable() default 60000L;
    }
}

