/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.util.Date;
import java.util.Iterator;
import org.apache.sling.commons.scheduler.impl.QuartzThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerProxy {
    private static final String PREFIX = "Apache Sling Quartz Scheduler ";
    private static final String QUARTZ_SCHEDULER_NAME = "ApacheSling";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Scheduler scheduler;
    private final ThreadPoolManager threadPoolManager;
    private final org.apache.sling.commons.threads.ThreadPool threadPool;
    private final String poolName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerProxy(ThreadPoolManager manager, String pName) throws SchedulerException {
        if (manager == null) {
            throw new SchedulerException("Thread pool manager missing");
        }
        if (pName == null) {
            throw new SchedulerException("Thread pool name missing");
        }
        this.threadPoolManager = manager;
        this.poolName = pName;
        this.threadPool = this.threadPoolManager.get(this.poolName);
        QuartzThreadPool quartzPool = new QuartzThreadPool(this.threadPool);
        boolean succeeded = false;
        try {
            String name = QUARTZ_SCHEDULER_NAME + this.poolName.replace(' ', '_');
            DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
            String runID = new Date().toString().replace(' ', '_') + this.hashCode();
            factory.createScheduler(name, runID, (ThreadPool)quartzPool, (JobStore)new RAMJobStore());
            Iterator allSchedulersIter = factory.getAllSchedulers().iterator();
            Scheduler s = null;
            while (s == null && allSchedulersIter.hasNext()) {
                Scheduler current = (Scheduler)allSchedulersIter.next();
                if (!name.equals(current.getSchedulerName()) || !runID.equals(current.getSchedulerInstanceId())) continue;
                s = current;
            }
            if (s == null) {
                throw new SchedulerException("Unable to find new scheduler with name " + name + " and run ID " + runID);
            }
            s.start();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}for pool {} started.", (Object)PREFIX, (Object)this.poolName);
            }
            this.scheduler = s;
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.threadPoolManager.release(this.threadPool);
            }
        }
    }

    public void dispose() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            this.logger.debug("Exception during shutdown of scheduler.", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}for pool {} stopped.", (Object)PREFIX, (Object)this.poolName);
        }
        this.threadPoolManager.release(this.threadPool);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

