/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.integration;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.sling.commons.testing.integration.HttpAnyMethod;
import org.apache.sling.commons.testing.integration.HttpStatusCodeException;
import org.apache.sling.commons.testing.integration.SlingIntegrationTestClient;
import org.apache.sling.commons.testing.util.JavascriptEngine;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTestBase
extends TestCase {
    public static final String HTTP_BASE_URL = HttpTestBase.removeEndingSlash(System.getProperty("launchpad.http.server.url", "http://localhost:8888"));
    public static final String WEBDAV_BASE_URL = HttpTestBase.removeEndingSlash(System.getProperty("launchpad.webdav.server.url", "http://localhost:8888"));
    public static final String SERVLET_CONTEXT = HttpTestBase.removeEndingSlash(System.getProperty("launchpad.servlet.context", ""));
    public static final String TEST_PATH = "/launchpad-integration-tests";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String CONTENT_TYPE_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_JS = "application/javascript";
    public static final String CONTENT_TYPE_CSS = "text/css";
    public static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    public static final String SLING_POST_SERVLET_CREATE_SUFFIX = "/";
    public static final String DEFAULT_EXT = ".txt";
    public static final String EXECUTE_RESOURCE_TYPE = "SlingTesting" + HttpTestBase.class.getSimpleName();
    private static int executeCounter;
    public static final int READY_TIMEOUT_SECONDS;
    protected SlingIntegrationTestClient testClient;
    protected HttpClient httpClient;
    private static Boolean slingStartupOk;
    public static final String CONTENT_TYPE_DONTCARE = "*";
    protected final List<String> urlsToDelete = new LinkedList<String>();
    private final JavascriptEngine javascriptEngine = new JavascriptEngine();

    protected static String removeEndingSlash(String str) {
        if (str != null && str.endsWith(SLING_POST_SERVLET_CREATE_SUFFIX)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    protected void setUp() throws Exception {
        super.setUp();
        MDC.put((String)"testclass", (String)((Object)((Object)this)).getClass().getName());
        MDC.put((String)"testcase", (String)this.getName());
        URL url = null;
        try {
            url = new URL(HTTP_BASE_URL);
        }
        catch (MalformedURLException mfe) {
            throw new IOException("MalformedURLException: " + HTTP_BASE_URL);
        }
        this.httpClient = new HttpClient();
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials("admin", "admin");
        this.httpClient.getState().setCredentials(new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
        this.testClient = new SlingIntegrationTestClient(this.httpClient);
        this.waitForSlingStartup();
    }

    protected void tearDown() throws Exception {
        MDC.remove((String)"testcase");
        MDC.remove((String)"testclass");
        super.tearDown();
        for (String url : this.urlsToDelete) {
            this.testClient.delete(url);
        }
    }

    protected void waitForSlingStartup() throws Exception {
        if (slingStartupOk != null) {
            if (slingStartupOk.booleanValue()) {
                return;
            }
            HttpTestBase.fail((String)"Sling services not available. Already checked in earlier tests.");
        }
        slingStartupOk = false;
        System.err.println("Checking if the required Sling services are started (timeout " + READY_TIMEOUT_SECONDS + " seconds)...");
        System.err.println("(base URLs=" + HTTP_BASE_URL + " and " + WEBDAV_BASE_URL + "; servlet context=" + SERVLET_CONTEXT + ")");
        LinkedList<String> exceptionMessages = new LinkedList<String>();
        long maxMsecToWait = (long)READY_TIMEOUT_SECONDS * 1000L;
        long startupTime = System.currentTimeMillis();
        while (!slingStartupOk.booleanValue() && System.currentTimeMillis() < startupTime + maxMsecToWait) {
            try {
                slingStartupOk = this.slingServerReady();
            }
            catch (Exception e) {
                exceptionMessages.add(e.toString());
                Thread.sleep(500L);
            }
        }
        if (!slingStartupOk.booleanValue()) {
            StringBuffer msg = new StringBuffer("Server does not seem to be ready, after ");
            msg.append(maxMsecToWait).append(" msec, got the following ").append(exceptionMessages.size()).append(" Exceptions:");
            for (String e : exceptionMessages) {
                msg.append(e).append("\n");
            }
            System.err.println(msg);
            HttpTestBase.fail((String)msg.toString());
        }
        System.err.println("Sling services seem to be started, continuing with integration tests.");
    }

    protected boolean slingServerReady() throws Exception {
        String contentType;
        String time = String.valueOf(System.currentTimeMillis());
        String url = HTTP_BASE_URL + "/WaitForSlingStartup/" + time;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("time", time);
        String urlOfNewNode = this.testClient.createNode(url, props, null, true);
        GetMethod get = new GetMethod(urlOfNewNode + DEFAULT_EXT);
        int status = this.httpClient.executeMethod((HttpMethod)get);
        if (status != 200) {
            throw new HttpStatusCodeException(200, status, "GET", urlOfNewNode);
        }
        Header h = get.getResponseHeader("Content-Type");
        String string = contentType = h == null ? "" : h.getValue();
        if (!contentType.startsWith(CONTENT_TYPE_PLAIN)) {
            throw new IOException("Expected Content-Type=text/plain but got '" + contentType + "' for URL=" + urlOfNewNode);
        }
        String content = get.getResponseBodyAsString();
        if (!content.contains(time)) {
            throw new IOException("Content does not contain '" + time + "' (" + content + ") at URL=" + urlOfNewNode);
        }
        String webDavUrl = WEBDAV_BASE_URL + SLING_POST_SERVLET_CREATE_SUFFIX;
        HttpAnyMethod options = new HttpAnyMethod("OPTIONS", webDavUrl);
        status = this.httpClient.executeMethod((HttpMethod)options);
        if (status != 200) {
            throw new HttpStatusCodeException(200, status, "OPTIONS", webDavUrl);
        }
        h = options.getResponseHeader("Allow");
        if (h == null) {
            throw new IOException("Response does not contain Allow header, at URL=" + webDavUrl);
        }
        if (h.getValue() == null) {
            throw new IOException("Allow header has null value at URL=" + webDavUrl);
        }
        if (!h.getValue().contains("PROPFIND")) {
            throw new IOException("Allow header (" + h.getValue() + " does not contain PROPFIND, at URL=" + webDavUrl);
        }
        return true;
    }

    protected HttpMethod assertHttpStatus(String urlString, int expectedStatusCode, String assertMessage) throws IOException {
        GetMethod get = new GetMethod(urlString);
        int status = this.httpClient.executeMethod((HttpMethod)get);
        if (assertMessage == null) {
            HttpTestBase.assertEquals((String)urlString, (int)expectedStatusCode, (int)status);
        } else {
            HttpTestBase.assertEquals((String)assertMessage, (int)expectedStatusCode, (int)status);
        }
        return get;
    }

    protected HttpMethod assertHttpStatus(String urlString, int expectedStatusCode) throws IOException {
        return this.assertHttpStatus(urlString, expectedStatusCode, null);
    }

    protected HttpMethod assertPostStatus(String url, int expectedStatusCode, List<NameValuePair> postParams, String assertMessage) throws IOException {
        PostMethod post = new PostMethod(url);
        post.setFollowRedirects(false);
        if (postParams != null) {
            NameValuePair[] nvp = new NameValuePair[]{};
            post.setRequestBody(postParams.toArray(nvp));
        }
        int status = this.httpClient.executeMethod((HttpMethod)post);
        if (assertMessage == null) {
            HttpTestBase.assertEquals((int)expectedStatusCode, (int)status);
        } else {
            HttpTestBase.assertEquals((String)assertMessage, (int)expectedStatusCode, (int)status);
        }
        return post;
    }

    protected String getContent(String url, String expectedContentType) throws IOException {
        return this.getContent(url, expectedContentType, null);
    }

    protected String getContent(String url, String expectedContentType, List<NameValuePair> params) throws IOException {
        return this.getContent(url, expectedContentType, params, 200);
    }

    protected String getContent(String url, String expectedContentType, List<NameValuePair> params, int expectedStatusCode) throws IOException {
        GetMethod get = new GetMethod(url);
        if (params != null) {
            NameValuePair[] nvp = new NameValuePair[]{};
            get.setQueryString(params.toArray(nvp));
        }
        int status = this.httpClient.executeMethod((HttpMethod)get);
        String content = HttpTestBase.getResponseBodyAsStream((HttpMethodBase)get, 0);
        HttpTestBase.assertEquals((String)("Expected status " + expectedStatusCode + " for " + url + " (content=" + content + ")"), (int)expectedStatusCode, (int)status);
        Header h = get.getResponseHeader("Content-Type");
        if (expectedContentType == null) {
            if (h != null) {
                HttpTestBase.fail((String)("Expected null Content-Type, got " + h.getValue()));
            }
        } else if (!CONTENT_TYPE_DONTCARE.equals(expectedContentType)) {
            if (h == null) {
                HttpTestBase.fail((String)("Expected Content-Type that starts with '" + expectedContentType + " but got no Content-Type header at " + url));
            } else {
                HttpTestBase.assertTrue((String)("Expected Content-Type that starts with '" + expectedContentType + "' for " + url + ", got '" + h.getValue() + "'"), (boolean)h.getValue().startsWith(expectedContentType));
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uploadTestScript(String scriptPath, String localFilename, String filenameOnServer) throws IOException {
        String url = WEBDAV_BASE_URL + scriptPath + SLING_POST_SERVLET_CREATE_SUFFIX + filenameOnServer;
        String testFile = "/integration-test/" + localFilename;
        InputStream data = ((Object)((Object)this)).getClass().getResourceAsStream(testFile);
        if (data == null) {
            HttpTestBase.fail((String)("Test file not found:" + testFile));
        }
        try {
            this.testClient.upload(url, data);
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
        return url;
    }

    protected String executeScript(String localFilename) throws Exception {
        return this.executeScript(localFilename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeScript(String localFilename, List<NameValuePair> params) throws Exception {
        int counter = 0;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            counter = ++executeCounter;
        }
        String resourceType = EXECUTE_RESOURCE_TYPE + counter;
        String scriptPath = "/apps/" + resourceType;
        this.testClient.mkdirs(WEBDAV_BASE_URL, scriptPath);
        int pos = localFilename.lastIndexOf(".");
        if (pos < 1) {
            throw new IllegalArgumentException("localFilename must have extension (" + localFilename + ")");
        }
        String ext = localFilename.substring(pos + 1);
        LinkedList<String> toDelete = new LinkedList<String>();
        try {
            toDelete.add(this.uploadTestScript(scriptPath, localFilename, "txt." + ext));
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(SLING_RESOURCE_TYPE, resourceType);
            String nodePath = scriptPath + "/node" + counter;
            String nodeUrl = this.testClient.createNode(HTTP_BASE_URL + nodePath, props);
            toDelete.add(nodeUrl);
            String string = this.getContent(nodeUrl + DEFAULT_EXT, CONTENT_TYPE_DONTCARE, params);
            return string;
        }
        finally {
            for (String url : toDelete) {
                this.testClient.delete(url);
            }
        }
    }

    protected void assertJavascript(String expectedOutput, String jsonData, String code) throws IOException {
        this.assertJavascript(expectedOutput, jsonData, code, null);
    }

    protected void assertJavascript(String expectedOutput, String jsonData, String code, String testInfo) throws IOException {
        String result = this.javascriptEngine.execute(code, jsonData);
        if (!result.equals(expectedOutput)) {
            HttpTestBase.fail((String)("Expected '" + expectedOutput + "' but got '" + result + "' for script='" + code + "'" + "' and data='" + jsonData + "'" + (testInfo == null ? "" : ", test info=" + testInfo)));
        }
    }

    public static String getResponseBodyAsStream(HttpMethodBase m, int maxLength) throws IOException {
        InputStream is = m.getResponseBodyAsStream();
        StringBuilder content = new StringBuilder();
        String charset = m.getResponseCharSet();
        byte[] buffer = new byte[16384];
        int n = 0;
        while ((n = is.read(buffer, 0, buffer.length)) > 0) {
            content.append(new String(buffer, 0, n, charset));
            if (maxLength == 0 || content.length() <= maxLength) continue;
            throw new IllegalArgumentException("Response body size is over maxLength (" + maxLength + ")");
        }
        return content.toString();
    }

    static {
        READY_TIMEOUT_SECONDS = Integer.getInteger("HttpTestBase.readyTimeoutSeconds", 60);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TestNode {
        public final String testText;
        public final String nodeUrl;
        public final String resourceType;
        public final String scriptPath;

        public TestNode(String parentPath, Map<String, String> properties) throws IOException {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            this.testText = "This is a test node " + System.currentTimeMillis();
            properties.put("text", this.testText);
            this.nodeUrl = HttpTestBase.this.testClient.createNode(parentPath + HttpTestBase.SLING_POST_SERVLET_CREATE_SUFFIX, properties);
            this.resourceType = properties.get(HttpTestBase.SLING_RESOURCE_TYPE);
            this.scriptPath = "/apps/" + (this.resourceType == null ? "nt/unstructured" : this.resourceType);
            HttpTestBase.this.testClient.mkdirs(WEBDAV_BASE_URL, this.scriptPath);
        }

        public void delete() throws IOException {
            HttpTestBase.this.testClient.delete(this.nodeUrl);
        }
    }
}

