/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;

public class EventHelper
implements EventListener {
    private final Session session;
    private int eventCount;
    public static final String WAIT_NODE_FOLDER = "WAIT_NODE";
    public static final String WAIT_NODE_NODE = EventHelper.class.getSimpleName();
    private final Node waitNodeFolder;

    public EventHelper(Session s) throws RepositoryException {
        this.session = s;
        int eventTypes = 3;
        boolean isDeep = true;
        boolean noLocal = false;
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 3, "/WAIT_NODE", true, null, null, false);
        this.waitNodeFolder = this.session.getRootNode().hasNode(WAIT_NODE_FOLDER) ? this.session.getRootNode().getNode(WAIT_NODE_FOLDER) : this.session.getRootNode().addNode(WAIT_NODE_FOLDER, "nt:unstructured");
        this.session.save();
    }

    public void onEvent(EventIterator it) {
        ++this.eventCount;
    }

    public void waitForEvents(long timeoutMsec) throws RepositoryException {
        int targetEventCount = this.eventCount + 1;
        if (this.waitNodeFolder.hasNode(WAIT_NODE_NODE)) {
            this.waitNodeFolder.getNode(WAIT_NODE_NODE).remove();
        } else {
            this.waitNodeFolder.addNode(WAIT_NODE_NODE);
        }
        this.session.save();
        long end = System.currentTimeMillis() + timeoutMsec;
        while (this.eventCount < targetEventCount && System.currentTimeMillis() < end) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.eventCount < targetEventCount) {
            throw new IllegalStateException("Event counter did not reach " + targetEventCount + ", waited " + timeoutMsec + " msec");
        }
    }

    public void dispose() {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }
}

