/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View {
    private static final Logger logger = LoggerFactory.getLogger(View.class);
    private final Resource resource;

    public View(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof View)) {
            return false;
        }
        View other = (View)obj;
        return this.getResource().getPath().equals(other.getResource().getPath());
    }

    public int hashCode() {
        return this.getResource().getPath().hashCode();
    }

    public String getViewId() {
        return this.getResource().getName();
    }

    public boolean matchesLiveView(Resource clusterInstancesRes, Config config) {
        return this.matches(ViewHelper.determineLiveInstances(clusterInstancesRes, config));
    }

    public boolean matches(Set<String> view) {
        HashSet<String> viewCopy = new HashSet<String>(view);
        Resource members = this.getResource().getChild("members");
        if (members == null) {
            return false;
        }
        try {
            for (Resource aMemberRes : members.getChildren()) {
                if (viewCopy.remove(aMemberRes.getName())) continue;
                return false;
            }
        }
        catch (RuntimeException re) {
            logger.info("matches: cannot compare due to " + re);
            return false;
        }
        return viewCopy.size() == 0;
    }

    public void remove() {
        ResourceResolver resourceResolver = this.getResource().getResourceResolver();
        try {
            resourceResolver.delete(this.getResource());
            resourceResolver.commit();
        }
        catch (PersistenceException pe) {
            logger.error("remove: Could not remove node: " + (Object)((Object)pe), (Throwable)pe);
            resourceResolver.refresh();
        }
    }
}

