/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.connector;

import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.topology.announcement.Announcement;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementFilter;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.TopologyConnectorClientInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyConnectorClient
implements TopologyConnectorClientInformation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final URL connectorUrl;
    private final ClusterViewService clusterViewService;
    private final Config config;
    private final UUID id;
    private final AnnouncementRegistry announcementRegistry;
    private Announcement lastInheritedAnnouncement;
    private final String serverInfo;
    private int lastStatusCode = -1;
    private boolean suppressPingWarnings_ = false;

    TopologyConnectorClient(ClusterViewService clusterViewService, AnnouncementRegistry announcementRegistry, Config config, URL connectorUrl, String serverInfo) {
        if (clusterViewService == null) {
            throw new IllegalArgumentException("clusterViewService must not be null");
        }
        if (announcementRegistry == null) {
            throw new IllegalArgumentException("announcementRegistry must not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (connectorUrl == null) {
            throw new IllegalArgumentException("connectorUrl must not be null");
        }
        this.clusterViewService = clusterViewService;
        this.announcementRegistry = announcementRegistry;
        this.config = config;
        this.connectorUrl = connectorUrl;
        this.serverInfo = serverInfo;
        this.id = UUID.randomUUID();
    }

    void ping() {
        String uri = this.connectorUrl.toString() + "." + this.clusterViewService.getSlingId() + ".json";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ping: connectorUrl=" + this.connectorUrl + ", complete uri=" + uri);
        }
        HttpClient httpClient = new HttpClient();
        PutMethod method = new PutMethod(uri);
        try {
            String userInfo = this.connectorUrl.getUserInfo();
            if (userInfo != null) {
                UsernamePasswordCredentials c = new UsernamePasswordCredentials(userInfo);
                httpClient.getState().setCredentials(new AuthScope(method.getURI().getHost(), method.getURI().getPort()), (Credentials)c);
            }
            Announcement topologyAnnouncement = new Announcement(this.clusterViewService.getSlingId());
            topologyAnnouncement.setServerInfo(this.serverInfo);
            topologyAnnouncement.setLocalCluster(this.clusterViewService.getClusterView());
            this.announcementRegistry.addAllExcept(topologyAnnouncement, new AnnouncementFilter(){

                public boolean accept(String receivingSlingId, Announcement announcement) {
                    for (InstanceDescription instance : TopologyConnectorClient.this.clusterViewService.getClusterView().getInstances()) {
                        if (!instance.getSlingId().equals(receivingSlingId)) continue;
                        return true;
                    }
                    return false;
                }
            });
            String p = topologyAnnouncement.asJSON();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ping: topologyAnnouncement json is: " + p);
            }
            method.setRequestEntity((RequestEntity)new StringRequestEntity(p, "application/json", "UTF-8"));
            DefaultHttpMethodRetryHandler retryhandler = new DefaultHttpMethodRetryHandler(0, false);
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)retryhandler);
            httpClient.executeMethod((HttpMethod)method);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ping: done. code=" + method.getStatusCode() + " - " + method.getStatusText());
            }
            this.lastStatusCode = method.getStatusCode();
            if (method.getStatusCode() == 200) {
                String responseBody = method.getResponseBodyAsString(0x1000000);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ping: response body=" + responseBody);
                }
                if (responseBody != null && responseBody.length() > 0) {
                    Announcement inheritedAnnouncement = Announcement.fromJSON(responseBody);
                    if (inheritedAnnouncement.isLoop()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("ping: connector response indicated a loop detected. not registering this announcement from " + inheritedAnnouncement.getOwnerId());
                        }
                    } else {
                        inheritedAnnouncement.setInherited(true);
                        if (!this.announcementRegistry.registerAnnouncement(inheritedAnnouncement)) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("ping: connector response is from an instance which I already see in my topology" + inheritedAnnouncement);
                            }
                            this.lastInheritedAnnouncement = null;
                            return;
                        }
                    }
                    this.lastInheritedAnnouncement = inheritedAnnouncement;
                } else {
                    this.lastInheritedAnnouncement = null;
                }
            } else {
                this.lastInheritedAnnouncement = null;
            }
            this.suppressPingWarnings_ = false;
        }
        catch (URIException e) {
            this.logger.warn("ping: Got URIException: " + (Object)((Object)e) + ", uri=" + uri);
            this.lastInheritedAnnouncement = null;
        }
        catch (IOException e) {
            if (this.suppressPingWarnings_) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ping: got IOException: " + e + ", uri=" + uri);
                }
            } else {
                this.suppressPingWarnings_ = true;
                this.logger.warn("ping: got IOException [suppressing further warns]: " + e + ", uri=" + uri);
            }
            this.lastInheritedAnnouncement = null;
        }
        catch (JSONException e) {
            this.logger.warn("ping: got JSONException: " + (Object)((Object)e));
            this.lastInheritedAnnouncement = null;
        }
        catch (RuntimeException re) {
            this.logger.warn("ping: got RuntimeException: " + re, (Throwable)re);
            this.lastInheritedAnnouncement = null;
        }
    }

    public int getStatusCode() {
        return this.lastStatusCode;
    }

    public URL getConnectorUrl() {
        return this.connectorUrl;
    }

    public boolean representsLoop() {
        if (this.lastInheritedAnnouncement == null) {
            return false;
        }
        return this.lastInheritedAnnouncement.isLoop();
    }

    public boolean isConnected() {
        if (this.lastInheritedAnnouncement == null) {
            return false;
        }
        return !this.lastInheritedAnnouncement.hasExpired(this.config);
    }

    public String getRemoteSlingId() {
        if (this.lastInheritedAnnouncement == null) {
            return null;
        }
        return this.lastInheritedAnnouncement.getOwnerId();
    }

    public String getId() {
        return this.id.toString();
    }

    public void disconnect() {
        String uri = this.connectorUrl.toString() + "." + this.clusterViewService.getSlingId() + ".json";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("disconnect: connectorUrl=" + this.connectorUrl + ", complete uri=" + uri);
        }
        if (this.lastInheritedAnnouncement != null) {
            this.announcementRegistry.unregisterAnnouncement(this.lastInheritedAnnouncement.getOwnerId());
        }
        HttpClient httpClient = new HttpClient();
        DeleteMethod method = new DeleteMethod(uri);
        try {
            String userInfo = this.connectorUrl.getUserInfo();
            if (userInfo != null) {
                UsernamePasswordCredentials c = new UsernamePasswordCredentials(userInfo);
                httpClient.getState().setCredentials(new AuthScope(method.getURI().getHost(), method.getURI().getPort()), (Credentials)c);
            }
            httpClient.executeMethod((HttpMethod)method);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("disconnect: done. code=" + method.getStatusCode() + " - " + method.getStatusText());
            }
        }
        catch (URIException e) {
            this.logger.warn("disconnect: Got URIException: " + (Object)((Object)e));
        }
        catch (IOException e) {
            this.logger.warn("disconnect: got IOException: " + e);
        }
        catch (RuntimeException re) {
            this.logger.error("disconnect: got RuntimeException: " + re, (Throwable)re);
        }
    }
}

