/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common.heartbeat;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.DiscoveryServiceImpl;
import org.apache.sling.discovery.impl.cluster.voting.VotingHandler;
import org.apache.sling.discovery.impl.cluster.voting.VotingHelper;
import org.apache.sling.discovery.impl.cluster.voting.VotingView;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.ConnectorRegistry;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={HeartbeatHandler.class, StartupListener.class})
public class HeartbeatHandler
implements Runnable,
StartupListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String NAME = "discovery.impl.heartbeat.runner";
    @Reference
    private SlingSettingsService slingSettingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ConnectorRegistry connectorRegistry;
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private Scheduler scheduler;
    @Reference
    private Config config;
    @Reference
    private VotingHandler votingHandler;
    private DiscoveryServiceImpl discoveryService;
    private String slingId;
    private String nextVotingId = UUID.randomUUID().toString();
    private boolean resetLeaderElectionId = false;
    private final Object lock = new Object();
    private long firstHeartbeatWritten = -1L;
    private Calendar lastHeartbeatWritten = null;
    private volatile boolean activated = false;
    private String runtimeId;
    private ComponentContext context;
    private boolean startupFinished = false;
    private boolean forcePing;

    public void inform(StartupMode mode, boolean finished) {
        if (finished) {
            this.startupFinished(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startupFinished(StartupMode mode) {
        Object object = this.lock;
        synchronized (object) {
            this.startupFinished = true;
            this.issueHeartbeat();
        }
    }

    public void startupProgress(float ratio) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) {
        Object object = this.lock;
        synchronized (object) {
            this.context = context;
            this.slingId = this.slingSettingsService.getSlingId();
            this.resetLeaderElectionId = true;
            this.runtimeId = UUID.randomUUID().toString();
            this.firstHeartbeatWritten = -1L;
            this.lastHeartbeatWritten = null;
            this.activated = true;
        }
    }

    @Deactivate
    protected void deactivate() {
        this.activated = false;
        this.scheduler.removeJob(NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DiscoveryServiceImpl discoveryService, String initialVotingId) {
        Object object = this.lock;
        synchronized (object) {
            this.discoveryService = discoveryService;
            this.nextVotingId = initialVotingId;
            this.issueHeartbeat();
        }
        try {
            this.scheduler.addPeriodicJob(NAME, (Object)this, null, this.config.getHeartbeatInterval(), false);
        }
        catch (Exception e) {
            this.logger.error("activate: Could not start heartbeat runner: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.activated) {
                return;
            }
            this.issueHeartbeat();
            this.checkView();
        }
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        if (this.resourceResolverFactory == null) {
            this.logger.error("getResourceResolver: resourceResolverFactory is null!");
            return null;
        }
        return this.resourceResolverFactory.getAdministrativeResourceResolver(null);
    }

    private String getLocalClusterNodePath() {
        return this.config.getClusterInstancesPath() + "/" + this.slingId;
    }

    public void triggerHeartbeat() {
        this.forcePing = true;
        try {
            this.scheduler.fireJob((Object)this, null);
        }
        catch (Exception e) {
            this.logger.info("triggerHeartbeat: Could not trigger heartbeat: " + e);
        }
    }

    private void issueHeartbeat() {
        if (this.discoveryService == null) {
            this.logger.error("issueHeartbeat: discoveryService is null");
        } else {
            this.discoveryService.updateProperties();
        }
        this.issueClusterLocalHeartbeat();
        this.issueRemoteHeartbeats();
    }

    private void issueRemoteHeartbeats() {
        if (this.connectorRegistry == null) {
            this.logger.error("issueRemoteHeartbeats: connectorRegistry is null");
            return;
        }
        if (!this.startupFinished) {
            this.logger.debug("issueRemoteHeartbeats: not issuing remote heartbeat yet, startup not yet finished");
            return;
        }
        this.connectorRegistry.pingOutgoingConnectors(this.forcePing);
        this.forcePing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void issueClusterLocalHeartbeat() {
        ResourceResolver resourceResolver = null;
        String myClusterNodePath = this.getLocalClusterNodePath();
        Calendar currentTime = Calendar.getInstance();
        try {
            resourceResolver = this.getResourceResolver();
            if (resourceResolver == null) {
                this.logger.error("issueClusterLocalHeartbeat: no resourceresolver available!");
                return;
            }
            Resource resource = ResourceHelper.getOrCreateResource(resourceResolver, myClusterNodePath);
            ModifiableValueMap resourceMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            if (this.firstHeartbeatWritten != -1L && this.lastHeartbeatWritten != null) {
                String readRuntimeId;
                Calendar lastHeartbeat;
                long timeSinceFirstHeartbeat = System.currentTimeMillis() - this.firstHeartbeatWritten;
                if (timeSinceFirstHeartbeat > 2L * this.config.getHeartbeatInterval() && (lastHeartbeat = (Calendar)resourceMap.get("lastHeartbeat", Calendar.class)) != null && !this.lastHeartbeatWritten.getTime().equals(lastHeartbeat.getTime())) {
                    this.logger.error("issueClusterLocalHeartbeat: SLING-2892: Detected unexpected, concurrent update of: " + myClusterNodePath + " 'lastHeartbeat'. If not done manually, " + "this likely indicates that there is more than 1 instance running in this cluster" + " with the same sling.id. My sling.id is " + this.slingId + "." + " Check for sling.id.file in your installation of all instances in this cluster " + "to verify this! Duplicate sling.ids are not allowed within a cluster!");
                }
                if (!this.runtimeId.equals(readRuntimeId = (String)resourceMap.get("runtimeId", String.class))) {
                    this.logger.error("issueClusterLocalHeartbeat: SLING-2091: Detected more than 1 instance running in this cluster  with the same sling.id. My sling.id is " + this.slingId + ", " + " Check for sling.id.file in your installation of all instances in this cluster " + "to verify this! Duplicate sling.ids are not allowed within a cluster!");
                    this.logger.error("issueClusterLocalHeartbeat: sending TOPOLOGY_CHANGING before self-disabling.");
                    this.discoveryService.forcedShutdown();
                    this.logger.error("issueClusterLocalHeartbeat: disabling discovery.impl");
                    this.activated = false;
                    if (this.context != null) {
                        try {
                            this.context.getBundleContext().getBundle().stop();
                        }
                        catch (BundleException e) {
                            this.logger.warn("issueClusterLocalHeartbeat: could not stop bundle: " + (Object)((Object)e), (Throwable)e);
                            this.context.disableComponent(null);
                        }
                    }
                    return;
                }
            }
            resourceMap.put((Object)"lastHeartbeat", (Object)currentTime);
            if (this.firstHeartbeatWritten == -1L) {
                resourceMap.put((Object)"runtimeId", (Object)this.runtimeId);
            }
            if (this.resetLeaderElectionId || !resourceMap.containsKey((Object)"leaderElectionId")) {
                String value;
                Session session;
                int maxLongLength = String.valueOf(Long.MAX_VALUE).length();
                String currentTimeMillisStr = String.format("%0" + maxLongLength + "d", System.currentTimeMillis());
                String prefix = "0";
                String leaderElectionRepositoryDescriptor = this.config.getLeaderElectionRepositoryDescriptor();
                if (leaderElectionRepositoryDescriptor != null && leaderElectionRepositoryDescriptor.length() != 0 && (session = (Session)resourceResolver.adaptTo(Session.class)) != null && (value = session.getRepository().getDescriptor(leaderElectionRepositoryDescriptor)) != null && value.equalsIgnoreCase("true")) {
                    prefix = "1";
                }
                resourceMap.put((Object)"leaderElectionId", (Object)(prefix + "_" + currentTimeMillisStr + "_" + this.slingId));
                this.resetLeaderElectionId = false;
            }
            resourceResolver.commit();
            this.lastHeartbeatWritten = currentTime;
            if (this.firstHeartbeatWritten == -1L) {
                this.firstHeartbeatWritten = System.currentTimeMillis();
            }
        }
        catch (LoginException e) {
            this.logger.error("issueHeartbeat: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("issueHeartbeat: Got a PersistenceException: " + myClusterNodePath + " " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkView() {
        if (this.announcementRegistry == null) {
            this.logger.error("announcementRegistry is null");
            return;
        }
        this.announcementRegistry.checkExpiredAnnouncements();
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            this.doCheckView(resourceResolver);
        }
        catch (LoginException e) {
            this.logger.error("checkView: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("checkView: encountered a persistence exception during view check: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private void doCheckView(ResourceResolver resourceResolver) throws PersistenceException {
        if (this.votingHandler == null) {
            this.logger.info("doCheckView: votingHandler is null!");
        } else {
            this.votingHandler.analyzeVotings(resourceResolver);
            try {
                this.votingHandler.cleanupTimedoutVotings(resourceResolver);
            }
            catch (Exception e) {
                this.logger.warn("doCheckView: Exception occurred while cleaning up votings: " + e, (Throwable)e);
            }
        }
        VotingView winningVoting = VotingHelper.getWinningVoting(resourceResolver, this.config);
        int numOpenNonWinningVotes = VotingHelper.listOpenNonWinningVotings(resourceResolver, this.config).size();
        if (winningVoting != null || numOpenNonWinningVotes > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("doCheckView: " + numOpenNonWinningVotes + " ongoing votings, no one winning yet - I shall wait for them to settle.");
            }
            return;
        }
        Resource clusterNodesRes = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath());
        Set<String> liveInstances = ViewHelper.determineLiveInstances(clusterNodesRes, this.config);
        if (ViewHelper.establishedViewMatches(resourceResolver, this.config, liveInstances)) {
            this.logger.debug("doCheckView: no pending nor winning votes. view is fine. we're all happy.");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("doCheckView: no pending nor winning votes. But: view does not match established or no established yet. Initiating a new voting");
            Iterator<String> it = liveInstances.iterator();
            while (it.hasNext()) {
                this.logger.debug("doCheckView: one of the live instances is: " + it.next());
            }
        }
        String votingId = this.nextVotingId;
        this.nextVotingId = UUID.randomUUID().toString();
        VotingView.newVoting(resourceResolver, this.config, votingId, this.slingId, liveInstances);
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    protected void bindVotingHandler(VotingHandler votingHandler) {
        this.votingHandler = votingHandler;
    }

    protected void unbindVotingHandler(VotingHandler votingHandler) {
        if (this.votingHandler == votingHandler) {
            this.votingHandler = null;
        }
    }
}

