/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.announcement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.common.DefaultClusterViewImpl;
import org.apache.sling.discovery.impl.common.DefaultInstanceDescriptionImpl;
import org.apache.sling.discovery.impl.topology.announcement.IncomingInstanceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Announcement {
    private static final int PROTOCOL_VERSION = 1;
    private final String ownerId;
    private final int protocolVersion;
    private ClusterView localCluster;
    private List<Announcement> incomings = new LinkedList<Announcement>();
    private boolean inherited = false;
    private String serverInfo;
    private boolean loop = false;
    private long backoffInterval = -1L;
    private boolean resetBackoff = false;

    public Announcement(String ownerId) {
        this(ownerId, 1);
    }

    public Announcement(String ownerId, int protocolVersion) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("ownerId must not be null or empty");
        }
        this.ownerId = ownerId;
        this.protocolVersion = protocolVersion;
    }

    public String toString() {
        StringBuilder incomingList = new StringBuilder();
        for (Announcement anIncomingAnnouncement : this.incomings) {
            if (incomingList.length() != 0) {
                incomingList.append(", ");
            }
            incomingList.append(anIncomingAnnouncement);
        }
        return "Announcement[ownerId=" + this.getOwnerId() + ", protocolVersion=" + this.protocolVersion + ", inherited=" + this.isInherited() + ", loop=" + this.loop + ", incomings=" + incomingList + "]";
    }

    public boolean isCorrectVersion() {
        return this.protocolVersion == 1;
    }

    public boolean isValid() {
        if (this.ownerId == null || this.ownerId.length() == 0) {
            return false;
        }
        if (this.loop) {
            return true;
        }
        if (!this.isCorrectVersion()) {
            return false;
        }
        if (this.localCluster == null) {
            return false;
        }
        try {
            List instances = this.localCluster.getInstances();
            if (instances == null || instances.size() == 0) {
                return false;
            }
            boolean isOwnerMemberOfLocalCluster = false;
            for (InstanceDescription instanceDescription : instances) {
                if (!instanceDescription.getSlingId().equals(this.ownerId)) continue;
                isOwnerMemberOfLocalCluster = true;
            }
            if (!isOwnerMemberOfLocalCluster) {
                return false;
            }
        }
        catch (Exception ise) {
            return false;
        }
        return true;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setBackoffInterval(long backoffInterval) {
        this.backoffInterval = backoffInterval;
    }

    public long getBackoffInterval() {
        return this.backoffInterval;
    }

    public void setResetBackoff(boolean resetBackoff) {
        this.resetBackoff = resetBackoff;
    }

    public boolean getResetBackoff() {
        return this.resetBackoff;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public JSONObject asJSONObject() throws JSONException {
        return this.asJSONObject(false);
    }

    private JSONObject asJSONObject(boolean filterTimes) throws JSONException {
        JSONObject announcement = new JSONObject();
        announcement.put("ownerId", (Object)this.ownerId);
        announcement.put("protocolVersion", this.protocolVersion);
        if (!filterTimes) {
            announcement.put("created", System.currentTimeMillis());
        }
        announcement.put("inherited", this.inherited);
        if (this.loop) {
            announcement.put("loop", this.loop);
        }
        if (this.serverInfo != null) {
            announcement.put("serverInfo", (Object)this.serverInfo);
        }
        if (this.localCluster != null) {
            announcement.put("localClusterView", (Object)Announcement.asJSON(this.localCluster));
        }
        if (!filterTimes && this.backoffInterval > 0L) {
            announcement.put("backoffInterval", this.backoffInterval);
        }
        if (this.resetBackoff) {
            announcement.put("resetBackoff", this.resetBackoff);
        }
        JSONArray incomingAnnouncements = new JSONArray();
        for (Announcement incoming : this.incomings) {
            incomingAnnouncements.put((Object)incoming.asJSONObject(filterTimes));
        }
        announcement.put("topologyAnnouncements", (Object)incomingAnnouncements);
        return announcement;
    }

    public static Announcement fromJSON(String topologyAnnouncementJSON) throws JSONException {
        JSONObject announcement = new JSONObject(topologyAnnouncementJSON);
        String ownerId = announcement.getString("ownerId");
        int protocolVersion = !announcement.has("protocolVersion") ? -1 : announcement.getInt("protocolVersion");
        Announcement result = new Announcement(ownerId, protocolVersion);
        if (announcement.has("backoffInterval")) {
            long backoffInterval;
            result.backoffInterval = backoffInterval = announcement.getLong("backoffInterval");
        }
        if (announcement.has("resetBackoff")) {
            boolean resetBackoff;
            result.resetBackoff = resetBackoff = announcement.getBoolean("resetBackoff");
        }
        if (announcement.has("loop") && announcement.getBoolean("loop")) {
            result.setLoop(true);
            return result;
        }
        String localClusterViewJSON = announcement.getString("localClusterView");
        ClusterView localClusterView = Announcement.asClusterView(localClusterViewJSON);
        JSONArray subAnnouncements = announcement.getJSONArray("topologyAnnouncements");
        if (announcement.has("inherited")) {
            Boolean inherited = announcement.getBoolean("inherited");
            result.inherited = inherited;
        }
        if (announcement.has("serverInfo")) {
            String serverInfo;
            result.serverInfo = serverInfo = announcement.getString("serverInfo");
        }
        result.setLocalCluster(localClusterView);
        for (int i = 0; i < subAnnouncements.length(); ++i) {
            String subAnnouncementJSON = subAnnouncements.getString(i);
            result.addIncomingTopologyAnnouncement(Announcement.fromJSON(subAnnouncementJSON));
        }
        return result;
    }

    private static ClusterView asClusterView(String localClusterViewJSON) throws JSONException {
        JSONObject obj = new JSONObject(localClusterViewJSON);
        DefaultClusterViewImpl clusterView = new DefaultClusterViewImpl(obj.getString("id"));
        JSONArray instancesObj = obj.getJSONArray("instances");
        for (int i = 0; i < instancesObj.length(); ++i) {
            JSONObject anInstance = instancesObj.getJSONObject(i);
            clusterView.addInstanceDescription(Announcement.asInstance(anInstance));
        }
        return clusterView;
    }

    private static JSONObject asJSON(ClusterView clusterView) throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("id", (Object)clusterView.getId());
        JSONArray instancesObj = new JSONArray();
        List instances = clusterView.getInstances();
        for (InstanceDescription instanceDescription : instances) {
            instancesObj.put((Object)Announcement.asJSON(instanceDescription));
        }
        obj.put("instances", (Object)instancesObj);
        return obj;
    }

    private static DefaultInstanceDescriptionImpl asInstance(JSONObject anInstance) throws JSONException {
        boolean isLeader = anInstance.getBoolean("isLeader");
        String slingId = anInstance.getString("slingId");
        JSONObject propertiesObj = anInstance.getJSONObject("properties");
        Iterator it = propertiesObj.keys();
        HashMap<String, String> properties = new HashMap<String, String>();
        while (it.hasNext()) {
            String key = (String)it.next();
            properties.put(key, propertiesObj.getString(key));
        }
        IncomingInstanceDescription instance = new IncomingInstanceDescription(null, isLeader, slingId, properties);
        return instance;
    }

    private static JSONObject asJSON(InstanceDescription instanceDescription) throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("slingId", (Object)instanceDescription.getSlingId());
        obj.put("isLeader", instanceDescription.isLeader());
        ClusterView cluster = instanceDescription.getClusterView();
        if (cluster != null) {
            obj.put("cluster", (Object)cluster.getId());
        }
        JSONObject propertiesObj = new JSONObject();
        Map propertiesMap = instanceDescription.getProperties();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            propertiesObj.put((String)entry.getKey(), entry.getValue());
        }
        obj.put("properties", (Object)propertiesObj);
        return obj;
    }

    public void setLocalCluster(ClusterView localCluster) {
        this.localCluster = localCluster;
    }

    public void addIncomingTopologyAnnouncement(Announcement incomingTopologyAnnouncement) {
        this.incomings.add(incomingTopologyAnnouncement);
    }

    public String asJSON() throws JSONException {
        return this.asJSONObject().toString();
    }

    public String getPrimaryKey() {
        return this.ownerId;
    }

    public Collection<InstanceDescription> listInstances() {
        LinkedList<InstanceDescription> instances = new LinkedList<InstanceDescription>();
        instances.addAll(this.localCluster.getInstances());
        for (Announcement incomingAnnouncement : this.incomings) {
            instances.addAll(incomingAnnouncement.listInstances());
        }
        return instances;
    }

    public void persistTo(Resource announcementsResource) throws PersistenceException, JSONException {
        Resource announcementChildResource = announcementsResource.getChild(this.getPrimaryKey());
        String announcementJson = this.asJSON();
        if (announcementChildResource == null) {
            ResourceResolver resourceResolver = announcementsResource.getResourceResolver();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("topologyAnnouncement", announcementJson);
            resourceResolver.create(announcementsResource, this.getPrimaryKey(), properties);
        } else {
            ModifiableValueMap announcementChildMap = (ModifiableValueMap)announcementChildResource.adaptTo(ModifiableValueMap.class);
            announcementChildMap.put((Object)"topologyAnnouncement", (Object)announcementJson);
        }
    }

    public void removeInherited(String ownerId) {
        Iterator<Announcement> it = this.incomings.iterator();
        while (it.hasNext()) {
            Announcement anIncomingAnnouncement = it.next();
            if (!anIncomingAnnouncement.isInherited() || !anIncomingAnnouncement.getOwnerId().equals(ownerId)) continue;
            it.remove();
        }
    }

    public boolean correspondsTo(Announcement announcement) throws JSONException {
        JSONObject myJson = this.asJSONObject(true);
        JSONObject otherJson = announcement.asJSONObject(true);
        return myJson.toString().equals(otherJson.toString());
    }
}

