/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyViewImpl
implements TopologyView {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean current = true;
    private final Set<InstanceDescription> instances = new HashSet<InstanceDescription>();

    public TopologyViewImpl() {
    }

    public TopologyViewImpl(Collection<InstanceDescription> instances) {
        if (instances != null) {
            this.instances.addAll(instances);
        }
    }

    public TopologyEvent.Type compareTopology(TopologyViewImpl other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        if (this.instances.size() != other.instances.size()) {
            this.logger.debug("compareTopology: different number of instances");
            return TopologyEvent.Type.TOPOLOGY_CHANGED;
        }
        boolean propertiesChanged = false;
        for (InstanceDescription instance : this.instances) {
            Iterator<InstanceDescription> it2 = other.instances.iterator();
            InstanceDescription matchingInstance = null;
            while (it2.hasNext()) {
                InstanceDescription otherInstance = it2.next();
                if (!instance.getSlingId().equals(otherInstance.getSlingId())) continue;
                matchingInstance = otherInstance;
                break;
            }
            if (matchingInstance == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("compareTopology: no matching instance found for {}", (Object)instance);
                }
                return TopologyEvent.Type.TOPOLOGY_CHANGED;
            }
            if (!instance.getClusterView().getId().equals(matchingInstance.getClusterView().getId())) {
                this.logger.debug("compareTopology: cluster view id does not match");
                return TopologyEvent.Type.TOPOLOGY_CHANGED;
            }
            if (instance.getProperties().equals(matchingInstance.getProperties())) continue;
            propertiesChanged = true;
        }
        if (propertiesChanged) {
            return TopologyEvent.Type.PROPERTIES_CHANGED;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TopologyViewImpl)) {
            return false;
        }
        TopologyViewImpl other = (TopologyViewImpl)obj;
        if (this.current != other.current) {
            return false;
        }
        TopologyEvent.Type diff = this.compareTopology(other);
        return diff == null;
    }

    public int hashCode() {
        int code = 0;
        for (InstanceDescription instance : this.instances) {
            code += instance.hashCode();
        }
        return code;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void markOld() {
        this.current = false;
    }

    public InstanceDescription getLocalInstance() {
        for (InstanceDescription instance : this.instances) {
            if (!instance.isLocal()) continue;
            return instance;
        }
        return null;
    }

    public Set<InstanceDescription> getInstances() {
        return Collections.unmodifiableSet(this.instances);
    }

    public void addInstances(Collection<InstanceDescription> instances) {
        if (instances == null) {
            return;
        }
        block0: for (InstanceDescription instanceDescription : instances) {
            for (InstanceDescription existingInstance : this.instances) {
                if (!existingInstance.getSlingId().equals(instanceDescription.getSlingId())) continue;
                this.logger.info("addInstance: cannot add same instance twice: " + instanceDescription);
                continue block0;
            }
            this.instances.add(instanceDescription);
        }
    }

    public Set<InstanceDescription> findInstances(InstanceFilter picker) {
        if (picker == null) {
            throw new IllegalArgumentException("picker must not be null");
        }
        HashSet<InstanceDescription> result = new HashSet<InstanceDescription>();
        for (InstanceDescription instance : this.instances) {
            if (!picker.accept(instance)) continue;
            result.add(instance);
        }
        return result;
    }

    public Set<ClusterView> getClusterViews() {
        HashSet<ClusterView> result = new HashSet<ClusterView>();
        for (InstanceDescription instance : this.instances) {
            ClusterView cluster = instance.getClusterView();
            if (cluster == null) continue;
            result.add(cluster);
        }
        return new HashSet<ClusterView>(result);
    }

    public String toString() {
        return "TopologyViewImpl [current=" + this.current + ", instances=" + this.instances + "]";
    }
}

