/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%config.name", description="%config.description")
@Service(value={Config.class})
public class Config {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CLUSTERINSTANCES_RESOURCE = "clusterInstances";
    private static final String ESTABLISHED_VIEW_RESOURCE = "establishedView";
    private static final String PREVIOUS_VIEW_RESOURCE = "previousView";
    private static final String ONGOING_VOTING_RESOURCE = "ongoingVotings";
    public static final long DEFAULT_HEARTBEAT_TIMEOUT = 45L;
    @Property(longValue={45L})
    public static final String HEARTBEAT_TIMEOUT_KEY = "heartbeatTimeout";
    private long heartbeatTimeout = 45L;
    public static final long DEFAULT_HEARTBEAT_INTERVAL = 15L;
    @Property(longValue={15L})
    public static final String HEARTBEAT_INTERVAL_KEY = "heartbeatInterval";
    private long heartbeatInterval = 15L;
    public static final int DEFAULT_MIN_EVENT_DELAY = 3;
    @Property(intValue={3})
    public static final String MIN_EVENT_DELAY_KEY = "minEventDelay";
    private int minEventDelay = 3;
    @Property(cardinality=1024)
    public static final String TOPOLOGY_CONNECTOR_URLS_KEY = "topologyConnectorUrls";
    private URL[] topologyConnectorUrls = new URL[]{null};
    private static final String[] DEFAULT_TOPOLOGY_CONNECTOR_WHITELIST = new String[]{"localhost", "127.0.0.1"};
    @Property(value={"localhost", "127.0.0.1"})
    public static final String TOPOLOGY_CONNECTOR_WHITELIST_KEY = "topologyConnectorWhitelist";
    private String[] topologyConnectorWhitelist = DEFAULT_TOPOLOGY_CONNECTOR_WHITELIST;
    private static final String DEFAULT_DISCOVERY_RESOURCE_PATH = "/var/discovery/impl/";
    @Property(value={"/var/discovery/impl/"}, propertyPrivate=true)
    public static final String DISCOVERY_RESOURCE_PATH_KEY = "discoveryResourcePath";
    private String discoveryResourcePath = "/var/discovery/impl/";
    @Property
    public static final String LEADER_ELECTION_REPOSITORY_DESCRIPTOR_NAME_KEY = "leaderElectionRepositoryDescriptor";
    @Property(boolValue={false})
    private static final String HMAC_ENABLED = "hmacEnabled";
    @Property(boolValue={false})
    private static final String ENCRYPTION_ENABLED = "enableEncryption";
    @Property
    private static final String SHARED_KEY = "sharedKey";
    private static final long DEFAULT_SHARED_KEY_INTERVAL = 14400000L;
    @Property(longValue={14400000L})
    private static final String SHARED_KEY_INTERVAL = "hmacSharedKeyTTL";
    private String leaderElectionRepositoryDescriptor;
    private boolean hmacEnabled;
    private String sharedKey;
    private long keyInterval;
    private boolean encryptionEnabled;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.logger.debug("activate: config activated.");
        this.configure(properties);
    }

    protected void configure(Map<String, Object> properties) {
        this.heartbeatTimeout = PropertiesUtil.toLong((Object)properties.get(HEARTBEAT_TIMEOUT_KEY), (long)45L);
        this.logger.debug("configure: heartbeatTimeout='{}'", (Object)this.heartbeatTimeout);
        this.heartbeatInterval = PropertiesUtil.toLong((Object)properties.get(HEARTBEAT_INTERVAL_KEY), (long)15L);
        this.logger.debug("configure: heartbeatInterval='{}'", (Object)this.heartbeatInterval);
        this.minEventDelay = PropertiesUtil.toInteger((Object)properties.get(MIN_EVENT_DELAY_KEY), (int)3);
        this.logger.debug("configure: minEventDelay='{}'", (Object)this.minEventDelay);
        String[] topologyConnectorUrlsStr = PropertiesUtil.toStringArray((Object)properties.get(TOPOLOGY_CONNECTOR_URLS_KEY), null);
        if (topologyConnectorUrlsStr != null && topologyConnectorUrlsStr.length > 0) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (int i = 0; i < topologyConnectorUrlsStr.length; ++i) {
                String anUrlStr = topologyConnectorUrlsStr[i];
                try {
                    if (anUrlStr == null || anUrlStr.length() <= 0) continue;
                    URL url = new URL(anUrlStr);
                    this.logger.debug("configure: a topologyConnectorbUrl='{}'", (Object)url);
                    urls.add(url);
                    continue;
                }
                catch (MalformedURLException e) {
                    this.logger.error("configure: could not set a topologyConnectorUrl: " + e, (Throwable)e);
                }
            }
            if (urls.size() > 0) {
                this.topologyConnectorUrls = urls.toArray(new URL[urls.size()]);
                this.logger.debug("configure: number of topologyConnectorUrls='{}''", (Object)urls.size());
            } else {
                this.topologyConnectorUrls = null;
                this.logger.debug("configure: no (valid) topologyConnectorUrls configured");
            }
        } else {
            this.topologyConnectorUrls = null;
            this.logger.debug("configure: no (valid) topologyConnectorUrls configured");
        }
        this.topologyConnectorWhitelist = PropertiesUtil.toStringArray((Object)properties.get(TOPOLOGY_CONNECTOR_WHITELIST_KEY), (String[])DEFAULT_TOPOLOGY_CONNECTOR_WHITELIST);
        this.logger.debug("configure: topologyConnectorWhitelist='{}'", (Object[])this.topologyConnectorWhitelist);
        this.discoveryResourcePath = PropertiesUtil.toString((Object)properties.get(DISCOVERY_RESOURCE_PATH_KEY), (String)"");
        while (this.discoveryResourcePath.endsWith("/")) {
            this.discoveryResourcePath = this.discoveryResourcePath.substring(0, this.discoveryResourcePath.length() - 1);
        }
        this.discoveryResourcePath = this.discoveryResourcePath + "/";
        if (this.discoveryResourcePath == null || this.discoveryResourcePath.length() <= 1) {
            this.discoveryResourcePath = DEFAULT_DISCOVERY_RESOURCE_PATH;
        }
        this.logger.debug("configure: discoveryResourcePath='{}'", (Object)this.discoveryResourcePath);
        this.leaderElectionRepositoryDescriptor = PropertiesUtil.toString((Object)properties.get(LEADER_ELECTION_REPOSITORY_DESCRIPTOR_NAME_KEY), null);
        this.logger.debug("configure: leaderElectionRepositoryDescriptor='{}'", (Object)this.leaderElectionRepositoryDescriptor);
        this.hmacEnabled = PropertiesUtil.toBoolean((Object)properties.get(HMAC_ENABLED), (boolean)true);
        this.encryptionEnabled = PropertiesUtil.toBoolean((Object)properties.get(ENCRYPTION_ENABLED), (boolean)false);
        this.sharedKey = PropertiesUtil.toString((Object)properties.get(SHARED_KEY), null);
        this.keyInterval = PropertiesUtil.toLong((Object)SHARED_KEY_INTERVAL, (long)14400000L);
    }

    public long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public int getMinEventDelay() {
        return this.minEventDelay;
    }

    public URL[] getTopologyConnectorURLs() {
        return this.topologyConnectorUrls;
    }

    public String[] getTopologyConnectorWhitelist() {
        return this.topologyConnectorWhitelist;
    }

    public String getClusterInstancesPath() {
        return this.discoveryResourcePath + CLUSTERINSTANCES_RESOURCE;
    }

    public String getEstablishedViewPath() {
        return this.discoveryResourcePath + ESTABLISHED_VIEW_RESOURCE;
    }

    public String getOngoingVotingsPath() {
        return this.discoveryResourcePath + ONGOING_VOTING_RESOURCE;
    }

    public String getPreviousViewPath() {
        return this.discoveryResourcePath + PREVIOUS_VIEW_RESOURCE;
    }

    public String getLeaderElectionRepositoryDescriptor() {
        return this.leaderElectionRepositoryDescriptor;
    }

    public boolean isHmacEnabled() {
        return this.hmacEnabled;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public long getKeyInterval() {
        return this.keyInterval;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }
}

