/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.topology.announcement.Announcement;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.ConnectorRegistry;
import org.apache.sling.discovery.impl.topology.connector.TopologyConnectorClientInformation;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={TopologyEventListener.class, Servlet.class})
@Properties(value={@Property(name="service.description", value={"Apache Sling Web Console Plugin to display Background servlets and ExecutionEngine status"}), @Property(name="felix.webconsole.label", value={"topology"}), @Property(name="felix.webconsole.title", value={"Topology Management"}), @Property(name="felix.webconsole.configprinter.modes", value={"zip"})})
public class TopologyWebConsolePlugin
extends AbstractWebConsolePlugin
implements TopologyEventListener {
    public static final String LABEL = "topology";
    public static final String TITLE = "Topology Management";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<String> propertyChangeLog = new LinkedList<String>();
    private final List<String> topologyLog = new LinkedList<String>();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Reference
    private ClusterViewService clusterViewService;
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private ConnectorRegistry connectorRegistry;
    private TopologyView currentView;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Object rawRoot = req.getAttribute("felix.webconsole.pluginRoot");
        if (!(rawRoot instanceof String)) {
            throw new ServletException("Illegal attr: felix.webconsole.pluginRoot");
        }
        String root = rawRoot.toString();
        String pathInfo = req.getRequestURI().substring(root.length());
        PrintWriter pw = res.getWriter();
        if (pathInfo.equals("")) {
            if (this.currentView != null) {
                this.renderOverview(pw, this.currentView);
            }
        } else {
            StringTokenizer st = new StringTokenizer(pathInfo, "/");
            String nodeId = st.nextToken();
            this.renderProperties(pw, req.getContextPath(), nodeId);
        }
    }

    private void renderProperties(PrintWriter pw, String contextPath, final String nodeId) {
        TopologyView tv;
        Set instances;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("renderProperties: nodeId=" + nodeId);
        }
        Set set = instances = (tv = this.currentView) == null ? Collections.EMPTY_SET : tv.findInstances(new InstanceFilter(){

            public boolean accept(InstanceDescription instance) {
                String slingId = instance.getSlingId();
                if (TopologyWebConsolePlugin.this.logger.isDebugEnabled()) {
                    TopologyWebConsolePlugin.this.logger.debug("renderProperties/picks: slingId={}", (Object)slingId);
                }
                return slingId.equals(nodeId);
            }
        });
        if (instances != null && instances.size() == 1) {
            InstanceDescription instance = (InstanceDescription)instances.iterator().next();
            pw.println("Properties of " + instance.getSlingId() + ":<br/>");
            pw.println("<table class=\"adapters nicetable ui-widget\">");
            pw.println("<thead>");
            pw.println("<tr>");
            pw.println("<th class=\"header ui-widget-header\">Key</th>");
            pw.println("<th class=\"header ui-widget-header\">Value</th>");
            pw.println("</tr>");
            pw.println("</thead>");
            pw.println("<tbody>");
            boolean odd = true;
            for (Map.Entry entry : instance.getProperties().entrySet()) {
                String oddEven = odd ? "odd" : "even";
                odd = !odd;
                pw.println("<tr class=\"" + oddEven + " ui-state-default\">");
                pw.println("<td>" + (String)entry.getKey() + "</td>");
                pw.println("<td>" + (String)entry.getValue() + "</td>");
                pw.println("</tr>");
            }
            pw.println("</tbody>");
            pw.println("</table>");
        }
    }

    private void renderOverview(PrintWriter pw, TopologyView topology) {
        pw.println("<p class=\"statline ui-state-highlight\">Configuration</p>");
        pw.println("<br/>");
        pw.print("<a href=\"${appRoot}/configMgr/org.apache.sling.discovery.impl.Config\">Configure Discovery Service</a>");
        pw.println("<br/>");
        pw.println("<br/>");
        String changing = !topology.isCurrent() ? " <b><i>changing</i></b>" : "";
        pw.println("<p class=\"statline ui-state-highlight\">Topology" + changing + "</p>");
        pw.println("<div class=\"ui-widget-header ui-corner-top buttonGroup\" style=\"height: 15px;\">");
        pw.println("<span style=\"float: left; margin-left: 1em;\">Instances in the topology</span>");
        pw.println("</div>");
        pw.println("<table class=\"adapters nicetable ui-widget\">");
        pw.println("<thead>");
        pw.println("<tr>");
        pw.println("<th class=\"header ui-widget-header\">Sling id (click for properties)</th>");
        pw.println("<th class=\"header ui-widget-header\">ClusterView id</th>");
        pw.println("<th class=\"header ui-widget-header\">Local instance</th>");
        pw.println("<th class=\"header ui-widget-header\">Leader instance</th>");
        pw.println("<th class=\"header ui-widget-header\">In local cluster</th>");
        pw.println("<th class=\"header ui-widget-header\">Announced by</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody>");
        Set clusters = topology.getClusterViews();
        ClusterView myCluster = topology.getLocalInstance().getClusterView();
        boolean odd = true;
        this.renderCluster(pw, myCluster, odd);
        for (ClusterView clusterView : clusters) {
            if (clusterView.equals(myCluster)) continue;
            odd = !odd;
            this.renderCluster(pw, clusterView, odd);
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("<br/>");
        pw.println("<br/>");
        pw.println("<p class=\"statline ui-state-highlight\">Connectors</p>");
        this.listIncomingTopologyConnectors(pw);
        this.listOutgoingTopologyConnectors(pw);
        pw.println("<br/>");
        pw.println("<p class=\"statline ui-state-highlight\">Topology Change History</p>");
        pw.println("<pre>");
        for (String aLogEntry : this.topologyLog) {
            pw.println(aLogEntry);
        }
        pw.println("</pre>");
        pw.println("<br/>");
        pw.println("<p class=\"statline ui-state-highlight\">Property Change History</p>");
        pw.println("<pre>");
        for (String aLogEntry : this.propertyChangeLog) {
            pw.println(aLogEntry);
        }
        pw.println("</pre>");
        pw.println("</br>");
    }

    private void renderCluster(PrintWriter pw, ClusterView cluster, boolean odd) {
        Collection<Announcement> announcements = this.announcementRegistry.listAnnouncements(AnnouncementRegistry.ListScope.AllInSameCluster);
        for (InstanceDescription instanceDescription : cluster.getInstances()) {
            String oddEven;
            boolean inLocalCluster = this.clusterViewService.contains(instanceDescription.getSlingId());
            Announcement parentAnnouncement = null;
            block1: for (Announcement announcement : announcements) {
                for (InstanceDescription announcedInstance : announcement.listInstances()) {
                    if (!announcedInstance.getSlingId().equals(instanceDescription.getSlingId())) continue;
                    parentAnnouncement = announcement;
                    continue block1;
                }
            }
            String string = oddEven = odd ? "odd" : "even";
            if (inLocalCluster || parentAnnouncement != null) {
                pw.println("<tr class=\"" + oddEven + " ui-state-default\">");
            } else {
                pw.println("<tr class=\"" + oddEven + " ui-state-error\">");
            }
            boolean isLocal = instanceDescription.isLocal();
            String slingId = instanceDescription.getSlingId();
            pw.print("<td>");
            if (isLocal) {
                pw.print("<b>");
            }
            pw.print("<a href=\"");
            pw.print(this.getLabel());
            pw.print('/');
            pw.print(slingId);
            pw.print("\">");
            pw.print(slingId);
            pw.print("</a>");
            if (isLocal) {
                pw.print("</b>");
            }
            pw.println("</td>");
            pw.println("<td>" + (instanceDescription.getClusterView() == null ? "null" : instanceDescription.getClusterView().getId()) + "</td>");
            pw.println("<td>" + (isLocal ? "<b>true</b>" : "false") + "</td>");
            pw.println("<td>" + (instanceDescription.isLeader() ? "<b>true</b>" : "false") + "</td>");
            if (inLocalCluster) {
                pw.println("<td>local</td>");
                pw.println("<td>n/a</td>");
            } else {
                pw.println("<td>remote</td>");
                if (parentAnnouncement != null) {
                    pw.println("<td>" + parentAnnouncement.getOwnerId() + "</td>");
                } else {
                    pw.println("<td><b>(changing)</b></td>");
                }
            }
            pw.println("</tr>");
        }
    }

    private void listOutgoingTopologyConnectors(PrintWriter pw) {
        boolean odd = false;
        pw.println("<div class=\"ui-widget-header ui-corner-top buttonGroup\" style=\"height: 15px;\">");
        pw.println("<span style=\"float: left; margin-left: 1em;\">Outgoing topology connectors</span>");
        pw.println("</div>");
        pw.println("<table class=\"adapters nicetable ui-widget\">");
        pw.println("<thead>");
        pw.println("<tr>");
        pw.println("<th class=\"header ui-widget-header\">Connector url</th>");
        pw.println("<th class=\"header ui-widget-header\">Connected to slingId</th>");
        pw.println("<th class=\"header ui-widget-header\">Connector status</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody>");
        Collection<TopologyConnectorClientInformation> outgoingConnections = this.connectorRegistry.listOutgoingConnectors();
        for (TopologyConnectorClientInformation topologyConnectorClient : outgoingConnections) {
            String tooltipText;
            boolean isConnected;
            String oddEven = odd ? "odd" : "even";
            odd = !odd;
            String remoteSlingId = topologyConnectorClient.getRemoteSlingId();
            boolean bl = isConnected = topologyConnectorClient.isConnected() && remoteSlingId != null;
            if (isConnected) {
                pw.println("<tr class=\"" + oddEven + " ui-state-default\">");
            } else {
                pw.println("<tr class=\"" + oddEven + " ui-state-error\">");
            }
            pw.println("<td>" + topologyConnectorClient.getConnectorUrl().toString() + "</td>");
            if (isConnected && !topologyConnectorClient.representsLoop()) {
                pw.println("<td>" + remoteSlingId + "</td>");
                pw.println("<td>ok, in use</td>");
                continue;
            }
            if (isConnected && topologyConnectorClient.representsLoop()) {
                pw.println("<td>" + remoteSlingId + "</td>");
                pw.println("<td>ok, unused (loop or duplicate): standby</td>");
                continue;
            }
            int statusCode = topologyConnectorClient.getStatusCode();
            switch (statusCode) {
                case 401: {
                    tooltipText = "401: possible setup issue of discovery.impl on target instance";
                    break;
                }
                case 404: {
                    tooltipText = "404: possible white list rejection by target instance";
                    break;
                }
                case -1: {
                    tooltipText = "-1: check error log. possible connection refused.";
                    break;
                }
                default: {
                    tooltipText = null;
                }
            }
            String tooltip = tooltipText == null ? "" : " title=\"" + tooltipText + "\"";
            pw.println("<td" + tooltip + "><b>not connected (" + statusCode + ")</b></td>");
            pw.println("<td>not ok</td>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
    }

    private void listIncomingTopologyConnectors(PrintWriter pw) {
        boolean odd = false;
        pw.println("<div class=\"ui-widget-header ui-corner-top buttonGroup\" style=\"height: 15px;\">");
        pw.println("<span style=\"float: left; margin-left: 1em;\">Incoming topology connectors</span>");
        pw.println("</div>");
        pw.println("<table class=\"adapters nicetable ui-widget\">");
        pw.println("<thead>");
        pw.println("<tr>");
        pw.println("<th class=\"header ui-widget-header\">Owner slingId</th>");
        pw.println("<th class=\"header ui-widget-header\">Server info</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody>");
        Collection<Announcement> outgoingConnections = this.announcementRegistry.listAnnouncements(AnnouncementRegistry.ListScope.OnlyInherited);
        for (Announcement incomingAnnouncement : outgoingConnections) {
            String oddEven = odd ? "odd" : "even";
            odd = !odd;
            pw.println("<tr class=\"" + oddEven + " ui-state-default\">");
            pw.println("<td>" + incomingAnnouncement.getOwnerId() + "</td>");
            if (incomingAnnouncement.getServerInfo() != null) {
                pw.println("<td>" + incomingAnnouncement.getServerInfo() + "</td>");
            } else {
                pw.println("<td><i>n/a</i></td>");
            }
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("<br/>");
        pw.println("<br/>");
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
            this.currentView = event.getNewView();
            Set newInstances = event.getNewView().getInstances();
            StringBuilder sb = new StringBuilder();
            for (InstanceDescription newInstanceDescription : newInstances) {
                Map newProps;
                InstanceDescription oldInstanceDescription = this.findInstance(event.getOldView(), newInstanceDescription.getSlingId());
                if (oldInstanceDescription == null) {
                    this.logger.error("handleTopologyEvent: got a property changed but did not find instance " + newInstanceDescription + " in oldview.. event=" + event);
                    this.addEventLog(event.getType(), event.getType().toString());
                    return;
                }
                Map oldProps = oldInstanceDescription.getProperties();
                StringBuilder diff = this.diff(oldProps, newProps = newInstanceDescription.getProperties());
                if (diff.length() <= 0) continue;
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append("on instance " + newInstanceDescription.getSlingId() + ": " + diff);
            }
            this.addEventLog(event.getType(), sb.toString());
        } else if (event.getType() == TopologyEvent.Type.TOPOLOGY_INIT) {
            this.currentView = event.getNewView();
            StringBuilder details = new StringBuilder();
            for (InstanceDescription newInstance : event.getNewView().getInstances()) {
                if (details.length() != 0) {
                    details.append(", ");
                }
                details.append(newInstance.getSlingId());
            }
            this.addEventLog(event.getType(), "view: " + this.shortViewInfo(event.getNewView()) + ". " + details);
        } else if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            this.currentView = event.getOldView();
            this.addEventLog(event.getType(), "old view: " + this.shortViewInfo(event.getOldView()));
        } else {
            this.currentView = event.getNewView();
            if (event.getOldView() == null) {
                this.addEventLog(event.getType(), "new view: " + this.shortViewInfo(event.getNewView()));
            } else {
                StringBuilder details = new StringBuilder();
                for (InstanceDescription newInstance : event.getNewView().getInstances()) {
                    if (this.findInstance(event.getOldView(), newInstance.getSlingId()) != null) continue;
                    if (details.length() != 0) {
                        details.append(", ");
                    }
                    details.append(newInstance.getSlingId() + " joined");
                }
                for (InstanceDescription oldInstance : event.getOldView().getInstances()) {
                    if (this.findInstance(event.getNewView(), oldInstance.getSlingId()) != null) continue;
                    if (details.length() != 0) {
                        details.append(", ");
                    }
                    details.append(oldInstance.getSlingId() + " left");
                }
                this.addEventLog(event.getType(), "old view: " + this.shortViewInfo(event.getOldView()) + ", new view: " + this.shortViewInfo(event.getNewView()) + ". " + details);
            }
        }
    }

    private InstanceDescription findInstance(TopologyView view, final String slingId) {
        Set foundInstances = view.findInstances(new InstanceFilter(){

            public boolean accept(InstanceDescription instance) {
                return instance.getSlingId().equals(slingId);
            }
        });
        if (foundInstances.size() == 1) {
            return (InstanceDescription)foundInstances.iterator().next();
        }
        return null;
    }

    private synchronized void addEventLog(TopologyEvent.Type type, String info) {
        String dateStr = this.sdf.format(Calendar.getInstance().getTime());
        String logEntry = dateStr + ": " + type + ". " + info;
        if (type == TopologyEvent.Type.PROPERTIES_CHANGED) {
            this.propertyChangeLog.add(logEntry);
            while (this.propertyChangeLog.size() > 12) {
                this.propertyChangeLog.remove(0);
            }
        } else {
            this.topologyLog.add(logEntry);
            while (this.topologyLog.size() > 12) {
                this.topologyLog.remove(0);
            }
        }
    }

    private String shortViewInfo(TopologyView view) {
        int clusters = view.getClusterViews().size();
        int instances = view.getInstances().size();
        return (clusters == 1 ? "1 cluster" : clusters + " clusters") + ", " + (instances == 1 ? "1 instance" : instances + " instances");
    }

    private StringBuilder diff(Map<String, String> oldProps, Map<String, String> newProps) {
        HashSet<String> oldKeys = new HashSet<String>(oldProps.keySet());
        HashSet<String> newKeys = new HashSet<String>(newProps.keySet());
        StringBuilder sb = new StringBuilder();
        Iterator it = oldKeys.iterator();
        while (it.hasNext()) {
            String oldKey = (String)it.next();
            if (newKeys.contains(oldKey)) {
                if (!oldProps.get(oldKey).equals(newProps.get(oldKey))) {
                    sb.append("(" + oldKey + " changed from " + oldProps.get(oldKey) + " to " + newProps.get(oldKey) + ")");
                }
                newKeys.remove(oldKey);
            } else {
                sb.append("(" + oldKey + " was removed)");
            }
            it.remove();
        }
        for (String newKey : newKeys) {
            sb.append("(" + newKey + " was added)");
        }
        return sb;
    }

    public void printConfiguration(PrintWriter pw) {
        Collection<TopologyConnectorClientInformation> outgoingConnections;
        TopologyView topology = this.currentView;
        pw.println(TITLE);
        pw.println("---------------------------------------");
        pw.println();
        if (topology == null) {
            pw.println("No topology available yet!");
            return;
        }
        pw.print("Topology");
        if (!topology.isCurrent()) {
            pw.print(" changing!");
        }
        pw.println();
        pw.println();
        Set clusters = topology.getClusterViews();
        ClusterView myCluster = topology.getLocalInstance().getClusterView();
        this.printCluster(pw, myCluster);
        for (ClusterView clusterView : clusters) {
            if (clusterView.equals(myCluster)) continue;
            this.printCluster(pw, clusterView);
        }
        pw.println();
        pw.println();
        Collection<Announcement> incomingConnections = this.announcementRegistry.listAnnouncements(AnnouncementRegistry.ListScope.OnlyInherited);
        if (incomingConnections.size() > 0) {
            pw.println("Incoming topology connectors");
            pw.println("---------------------------------------");
            for (Announcement incomingAnnouncement : incomingConnections) {
                pw.print("Owner Sling Id : ");
                pw.print(incomingAnnouncement.getOwnerId());
                pw.println();
                if (incomingAnnouncement.getServerInfo() != null) {
                    pw.print("Server Info : ");
                    pw.print(incomingAnnouncement.getServerInfo());
                    pw.println();
                }
                pw.println();
            }
            pw.println();
            pw.println();
        }
        if ((outgoingConnections = this.connectorRegistry.listOutgoingConnectors()).size() > 0) {
            pw.println("Outgoing topology connectors");
            pw.println("---------------------------------------");
            for (TopologyConnectorClientInformation topologyConnectorClient : outgoingConnections) {
                String remoteSlingId = topologyConnectorClient.getRemoteSlingId();
                boolean isConnected = topologyConnectorClient.isConnected() && remoteSlingId != null;
                pw.print("Connector URL : ");
                pw.print(topologyConnectorClient.getConnectorUrl());
                pw.println();
                if (isConnected && !topologyConnectorClient.representsLoop()) {
                    pw.print("Connected to Sling Id : ");
                    pw.println(remoteSlingId);
                    pw.println("Connector status : ok, in use");
                } else if (isConnected && topologyConnectorClient.representsLoop()) {
                    pw.print("Connected to Sling Id : ");
                    pw.println(remoteSlingId);
                    pw.println("Connector status : ok, unused (loop or duplicate): standby");
                } else {
                    String tooltipText;
                    int statusCode = topologyConnectorClient.getStatusCode();
                    switch (statusCode) {
                        case 401: {
                            tooltipText = "401: possible setup issue of discovery.impl on target instance";
                            break;
                        }
                        case 404: {
                            tooltipText = "404: possible white list rejection by target instance";
                            break;
                        }
                        case -1: {
                            tooltipText = "-1: check error log. possible connection refused.";
                            break;
                        }
                        default: {
                            tooltipText = null;
                        }
                    }
                    pw.print("Connected to Sling Id : not connected");
                    if (tooltipText != null) {
                        pw.print(" (");
                        pw.print(tooltipText);
                        pw.print(")");
                    }
                    pw.println();
                    pw.println("Connector status : not ok");
                }
                pw.println();
            }
            pw.println();
            pw.println();
        }
        if (this.topologyLog.size() > 0) {
            pw.println("Topology Change History");
            pw.println("---------------------------------------");
            for (String aLogEntry : this.topologyLog) {
                pw.println(aLogEntry);
            }
            pw.println();
            pw.println();
        }
        if (this.propertyChangeLog.size() > 0) {
            pw.println("Property Change History");
            pw.println("---------------------------------------");
            for (String aLogEntry : this.propertyChangeLog) {
                pw.println(aLogEntry);
            }
            pw.println();
        }
    }

    private void printCluster(PrintWriter pw, ClusterView cluster) {
        Collection<Announcement> announcements = this.announcementRegistry.listAnnouncements(AnnouncementRegistry.ListScope.AllInSameCluster);
        for (InstanceDescription instanceDescription : cluster.getInstances()) {
            boolean inLocalCluster = this.clusterViewService.contains(instanceDescription.getSlingId());
            Announcement parentAnnouncement = null;
            block1: for (Announcement announcement : announcements) {
                for (InstanceDescription announcedInstance : announcement.listInstances()) {
                    if (!announcedInstance.getSlingId().equals(instanceDescription.getSlingId())) continue;
                    parentAnnouncement = announcement;
                    continue block1;
                }
            }
            boolean isLocal = instanceDescription.isLocal();
            String slingId = instanceDescription.getSlingId();
            pw.print("Sling ID : ");
            pw.print(slingId);
            pw.println();
            pw.print("Cluster View ID : ");
            pw.print(instanceDescription.getClusterView() == null ? "null" : instanceDescription.getClusterView().getId());
            pw.println();
            pw.print("Local instance : ");
            pw.print(isLocal);
            pw.println();
            pw.print("Leader instance : ");
            pw.print(instanceDescription.isLeader());
            pw.println();
            pw.print("In local cluster : ");
            if (inLocalCluster) {
                pw.print("local");
            } else {
                pw.print("remote");
            }
            pw.println();
            pw.print("Announced by : ");
            if (inLocalCluster) {
                pw.print("n/a");
            } else if (parentAnnouncement != null) {
                pw.print(parentAnnouncement.getOwnerId());
            } else {
                pw.print("(changing)");
            }
            pw.println();
            pw.println("Properties:");
            for (Map.Entry entry : instanceDescription.getProperties().entrySet()) {
                pw.print("- ");
                pw.print((String)entry.getKey());
                pw.print(" : ");
                pw.print((String)entry.getValue());
                pw.println();
            }
            pw.println();
            pw.println();
        }
    }

    protected void bindClusterViewService(ClusterViewService clusterViewService) {
        this.clusterViewService = clusterViewService;
    }

    protected void unbindClusterViewService(ClusterViewService clusterViewService) {
        if (this.clusterViewService == clusterViewService) {
            this.clusterViewService = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }
}

