/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewHelper {
    private static final Logger logger = LoggerFactory.getLogger(ViewHelper.class);

    public static Set<String> determineLiveInstances(Resource clusterInstancesResource, Config config) {
        HashSet<String> myView = new HashSet<String>();
        for (Resource aClusterInstance : clusterInstancesResource.getChildren()) {
            if (!ViewHelper.isHeartBeatCurrent(aClusterInstance, config)) continue;
            myView.add(aClusterInstance.getName());
        }
        return myView;
    }

    private static boolean isHeartBeatCurrent(Resource aClusterInstanceResource, Config config) {
        ValueMap properties = (ValueMap)aClusterInstanceResource.adaptTo(ValueMap.class);
        Date lastHeartbeat = (Date)properties.get("lastHeartbeat", Date.class);
        long now = System.currentTimeMillis();
        if (lastHeartbeat == null) {
            return false;
        }
        long then = lastHeartbeat.getTime();
        long diff = now - then;
        return diff < 1000L * config.getHeartbeatTimeout();
    }

    public static View getEstablishedView(ResourceResolver resourceResolver, Config config) {
        Resource establishedParent = resourceResolver.getResource(config.getEstablishedViewPath());
        if (establishedParent == null) {
            return null;
        }
        Iterable children = establishedParent.getChildren();
        if (children == null) {
            return null;
        }
        Iterator it = children.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Resource establishedView = (Resource)it.next();
        if (!it.hasNext()) {
            return new View(establishedView);
        }
        while (true) {
            logger.error("getEstablishedView: more than one established view encountered! Removing: " + establishedView);
            new View(establishedView).remove();
            if (!it.hasNext()) {
                return null;
            }
            establishedView = (Resource)it.next();
        }
    }

    public static boolean establishedViewMatches(ResourceResolver resourceResolver, Config config, Set<String> view) {
        View establishedView = ViewHelper.getEstablishedView(resourceResolver, config);
        if (establishedView == null) {
            return false;
        }
        return establishedView.matches(view);
    }
}

