/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common.resource;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.DefaultClusterViewImpl;
import org.apache.sling.discovery.impl.common.View;
import org.apache.sling.discovery.impl.common.resource.EstablishedInstanceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstablishedClusterView
extends DefaultClusterViewImpl {
    private static final Logger logger = LoggerFactory.getLogger(EstablishedClusterView.class);

    public EstablishedClusterView(Config config, View view, String localId) {
        super(view.getViewId());
        String leaderId = (String)((ValueMap)view.getResource().adaptTo(ValueMap.class)).get("leaderId", String.class);
        Iterator it1 = view.getResource().getChild("members").getChildren().iterator();
        LinkedList instanceRess = new LinkedList();
        while (it1.hasNext()) {
            instanceRess.add(it1.next());
        }
        Collections.sort(instanceRess, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (leaderId == null || leaderId.length() == 0) {
            Resource leader = (Resource)instanceRess.get(0);
            leaderId = leader.getName();
        }
        EstablishedInstanceDescription leaderInstance = null;
        for (Resource resource : instanceRess) {
            String slingId;
            Resource instanceResource = resource.getResourceResolver().getResource(config.getClusterInstancesPath() + "/" + resource.getName());
            EstablishedInstanceDescription instance = new EstablishedInstanceDescription((DefaultClusterViewImpl)this, instanceResource, slingId = resource.getName(), slingId.equals(leaderId), slingId.equals(localId));
            if (!instance.isLeader()) continue;
            if (leaderInstance != null) {
                logger.error("More than one instance chosen as leader! overwritten leader=" + leaderInstance + ", new leader=" + instance);
            }
            leaderInstance = instance;
        }
    }
}

