/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.DiscoveryServiceImpl;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventHandler.class})
@Properties(value={@Property(name="service.description", value={"Cluster View Change Listener 2."}), @Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"})})
public class TopologyChangeHandler
implements EventHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService slingSettingsService;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private DiscoveryServiceImpl discoveryService;
    @Reference
    private Config config;
    private String slingId;

    protected void activate(ComponentContext context) {
        this.slingId = this.slingSettingsService.getSlingId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("activated. slingid=" + this.slingId + ", discoveryservice=" + this.discoveryService);
        }
    }

    public void handleEvent(Event event) {
        String resourcePath = (String)event.getProperty("path");
        if (this.config == null) {
            return;
        }
        String establishedViewPath = this.config.getEstablishedViewPath();
        String clusterInstancesPath = this.config.getClusterInstancesPath();
        if (resourcePath == null) {
            return;
        }
        if (resourcePath.startsWith(establishedViewPath)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleEvent: establishedViewPath resourcePath=" + resourcePath + ", event=" + event);
            }
            this.handleTopologyChanged();
        } else if (resourcePath.startsWith(clusterInstancesPath)) {
            String[] resourceChangedAttributesStrings;
            Object resourceChangedAttributes = event.getProperty("resourceChangedAttributes");
            if (resourceChangedAttributes != null && resourceChangedAttributes instanceof String[] && (resourceChangedAttributesStrings = (String[])resourceChangedAttributes).length == 1 && resourceChangedAttributesStrings[0].equals("lastHeartbeat")) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleEvent: clusterInstancesPath (announcement or properties) resourcePath=" + resourcePath + ", event=" + event);
            }
            this.handleTopologyChanged();
        } else {
            return;
        }
    }

    private void handleTopologyChanged() {
        this.discoveryService.handleTopologyChanged();
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindDiscoveryService(DiscoveryServiceImpl discoveryServiceImpl) {
        this.discoveryService = discoveryServiceImpl;
    }

    protected void unbindDiscoveryService(DiscoveryServiceImpl discoveryServiceImpl) {
        if (this.discoveryService == discoveryServiceImpl) {
            this.discoveryService = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

