/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.announcement;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;
import org.apache.sling.discovery.impl.topology.announcement.Announcement;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementFilter;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={AnnouncementRegistry.class})
public class AnnouncementRegistryImpl
implements AnnouncementRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private Config config;

    @Override
    public void unregisterAnnouncement(String ownerId) {
        if (this.resourceResolverFactory == null) {
            this.logger.error("unregisterAnnouncement: resourceResolverFactory is null");
            return;
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            String path = this.config.getClusterInstancesPath() + "/" + this.settingsService.getSlingId() + "/announcements/" + ownerId;
            Resource announcementsResource = resourceResolver.getResource(path);
            if (announcementsResource != null) {
                resourceResolver.delete(announcementsResource);
                resourceResolver.commit();
            }
        }
        catch (LoginException e) {
            this.logger.error("unregisterAnnouncement: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("unregisterAnnouncement: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public Collection<Announcement> listAnnouncements(AnnouncementRegistry.ListScope scope) {
        ResourceResolver resourceResolver = null;
        LinkedList<Announcement> incomingAnnouncements = new LinkedList<Announcement>();
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            if (scope != AnnouncementRegistry.ListScope.AllInSameCluster) {
                Resource announcementsResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath() + "/" + this.settingsService.getSlingId() + "/announcements");
                for (Resource anAnnouncement : announcementsResource.getChildren()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("listIncomingAnnouncements: anAnnouncement=" + anAnnouncement);
                    }
                    Announcement topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class));
                    if (scope == AnnouncementRegistry.ListScope.OnlyInherited && topologyAnnouncement.isInherited()) continue;
                    incomingAnnouncements.add(topologyAnnouncement);
                }
            } else {
                Resource clusterInstancesResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath());
                for (Resource aClusterInstanceResource : clusterInstancesResource.getChildren()) {
                    Resource announcementsResource = aClusterInstanceResource.getChild("announcements");
                    if (announcementsResource == null) continue;
                    for (Resource anAnnouncement : announcementsResource.getChildren()) {
                        Announcement topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class));
                        if (topologyAnnouncement.hasExpired(this.config)) continue;
                        incomingAnnouncements.add(topologyAnnouncement);
                    }
                }
            }
            resourceResolver.commit();
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("handleEvent: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JSONException e) {
            this.logger.error("handleEvent: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("listAnnouncements: result: " + incomingAnnouncements.size());
        }
        return incomingAnnouncements;
    }

    @Override
    public boolean registerAnnouncement(Announcement topologyAnnouncement) {
        if (topologyAnnouncement == null) {
            throw new IllegalArgumentException("topologyAnnouncement must not be null");
        }
        if (!topologyAnnouncement.isValid()) {
            this.logger.warn("topologyAnnouncement is not valid");
            return false;
        }
        if (this.resourceResolverFactory == null) {
            this.logger.error("registerAnnouncement: resourceResolverFactory is null");
            return false;
        }
        Collection<Announcement> announcements = this.listAnnouncements(AnnouncementRegistry.ListScope.AllLocally);
        for (Announcement announcement : announcements) {
            if (announcement.getOwnerId().equals(topologyAnnouncement.getOwnerId())) continue;
            Collection<InstanceDescription> attachedInstances = announcement.listInstances();
            for (InstanceDescription instanceDescription : attachedInstances) {
                if (!topologyAnnouncement.getOwnerId().equals(instanceDescription.getSlingId())) continue;
                this.logger.info("registerAnnouncement: already have this instance attached: " + instanceDescription.getSlingId());
                return false;
            }
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource announcementsResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath() + "/" + this.settingsService.getSlingId() + "/announcements");
            topologyAnnouncement.persistTo(announcementsResource);
            resourceResolver.commit();
        }
        catch (LoginException e) {
            this.logger.error("registerAnnouncement: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("registerAnnouncement: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JSONException e) {
            this.logger.error("registerAnnouncement: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return true;
    }

    @Override
    public void addAllExcept(Announcement target, AnnouncementFilter filter) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource clusterInstancesResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath());
            for (Resource aClusterInstanceResource : clusterInstancesResource.getChildren()) {
                Resource announcementsResource = aClusterInstanceResource.getChild("announcements");
                if (announcementsResource == null) continue;
                for (Resource anAnnouncement : announcementsResource.getChildren()) {
                    Announcement topologyAnnouncement;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("addAllExcept: anAnnouncement=" + anAnnouncement);
                    }
                    if ((topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class))).hasExpired(this.config) || filter != null && !filter.accept(aClusterInstanceResource.getName(), topologyAnnouncement)) continue;
                    target.addIncomingTopologyAnnouncement(topologyAnnouncement);
                }
            }
            resourceResolver.commit();
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("handleEvent: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JSONException e) {
            this.logger.error("handleEvent: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public void checkExpiredAnnouncements() {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource announcementsResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath() + "/" + this.settingsService.getSlingId() + "/announcements");
            for (Resource anAnnouncement : announcementsResource.getChildren()) {
                Announcement topologyAnnouncement;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("checkExpiredAnnouncements: anAnnouncement=" + anAnnouncement);
                }
                if ((topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class))).hasExpired(this.config)) {
                    this.logger.info("checkExpiredAnnouncements: topology announcement has expired: " + anAnnouncement);
                    resourceResolver.delete(anAnnouncement);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("checkExpiredAnnouncements: topology announcement still valid: " + anAnnouncement);
            }
            resourceResolver.commit();
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("handleEvent: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JSONException e) {
            this.logger.error("handleEvent: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public Collection<InstanceDescription> listInstances() {
        LinkedList<InstanceDescription> instances = new LinkedList<InstanceDescription>();
        Collection<Announcement> announcements = this.listAnnouncements(AnnouncementRegistry.ListScope.AllInSameCluster);
        if (announcements == null) {
            return instances;
        }
        for (Announcement announcement : announcements) {
            instances.addAll(announcement.listInstances());
        }
        return instances;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

