/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.connector;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.common.heartbeat.HeartbeatHandler;
import org.apache.sling.discovery.impl.topology.announcement.Announcement;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementFilter;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.TopologyRequestValidator;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/libs/sling/topology/connector"})
@Property(name="sling.auth.requirements", value={"-/libs/sling/topology/connector"})
public class TopologyConnectorServlet
extends SlingAllMethodsServlet {
    public static final String TOPOLOGY_CONNECTOR_PATH = "/libs/sling/topology/connector";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private ClusterViewService clusterViewService;
    @Reference
    private HeartbeatHandler heartbeatHandler;
    @Reference
    private Config config;
    private final Set<String> whitelist = new HashSet<String>();
    private TopologyRequestValidator requestValidator;

    protected void activate(ComponentContext context) {
        this.whitelist.clear();
        if (!this.config.isHmacEnabled()) {
            String[] whitelistConfig = this.config.getTopologyConnectorWhitelist();
            for (int i = 0; i < whitelistConfig.length; ++i) {
                String aWhitelistEntry = whitelistConfig[i];
                this.logger.info("activate: adding whitelist entry: " + aWhitelistEntry);
                this.whitelist.add(aWhitelistEntry);
            }
        }
        this.requestValidator = new TopologyRequestValidator(this.config);
    }

    protected void doDelete(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.isWhitelisted(request)) {
            response.sendError(404);
            return;
        }
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String extension = pathInfo.getExtension();
        if (!"json".equals(extension)) {
            response.sendError(404);
            return;
        }
        String selector = pathInfo.getSelectorString();
        this.announcementRegistry.unregisterAnnouncement(selector);
    }

    protected void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.isWhitelisted(request)) {
            response.sendError(404);
            return;
        }
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String extension = pathInfo.getExtension();
        if (!"json".equals(extension)) {
            response.sendError(404);
            return;
        }
        String selector = pathInfo.getSelectorString();
        String topologyAnnouncementJSON = this.requestValidator.decodeMessage((HttpServletRequest)request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("doPost: incoming topology announcement is: " + topologyAnnouncementJSON);
        }
        try {
            final Announcement incomingTopologyAnnouncement = Announcement.fromJSON(topologyAnnouncementJSON);
            if (!incomingTopologyAnnouncement.getOwnerId().equals(selector)) {
                response.sendError(400);
                return;
            }
            String slingId = this.clusterViewService.getSlingId();
            if (slingId == null) {
                response.sendError(500);
                this.logger.info("doPut: no slingId available. Service not ready as expected at the moment.");
                return;
            }
            incomingTopologyAnnouncement.removeInherited(slingId);
            Announcement replyAnnouncement = new Announcement(slingId);
            if (!incomingTopologyAnnouncement.isCorrectVersion()) {
                this.logger.warn("doPost: rejecting an announcement from an incompatible connector protocol version: " + incomingTopologyAnnouncement);
                response.sendError(400);
                return;
            }
            if (this.clusterViewService.contains(incomingTopologyAnnouncement.getOwnerId())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doPost: rejecting an announcement from an instance that is part of my cluster: " + incomingTopologyAnnouncement);
                }
                replyAnnouncement.setLoop(true);
            } else if (this.clusterViewService.containsAny(incomingTopologyAnnouncement.listInstances())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doPost: rejecting an announcement as it contains instance(s) that is/are part of my cluster: " + incomingTopologyAnnouncement);
                }
                replyAnnouncement.setLoop(true);
            } else if (!this.announcementRegistry.registerAnnouncement(incomingTopologyAnnouncement)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doPost: rejecting an announcement from an instance that I already see in my topology: " + incomingTopologyAnnouncement);
                }
                replyAnnouncement.setLoop(true);
            } else {
                replyAnnouncement.setLocalCluster(this.clusterViewService.getClusterView());
                this.announcementRegistry.addAllExcept(replyAnnouncement, new AnnouncementFilter(){

                    public boolean accept(String receivingSlingId, Announcement announcement) {
                        return !announcement.getPrimaryKey().equals(incomingTopologyAnnouncement.getPrimaryKey());
                    }
                });
            }
            String p = this.requestValidator.encodeMessage(replyAnnouncement.asJSON());
            this.requestValidator.trustMessage((HttpServletResponse)response, (HttpServletRequest)request, p);
            PrintWriter pw = response.getWriter();
            pw.print(p);
            pw.flush();
        }
        catch (JSONException e) {
            this.logger.error("doPost: Got a JSONException: " + (Object)((Object)e), (Throwable)e);
            response.sendError(500);
        }
    }

    private boolean isWhitelisted(SlingHttpServletRequest request) {
        if (this.config.isHmacEnabled()) {
            return this.requestValidator.isTrusted((HttpServletRequest)request);
        }
        if (this.whitelist.contains(request.getRemoteAddr())) {
            return true;
        }
        if (this.whitelist.contains(request.getRemoteHost())) {
            return true;
        }
        this.logger.info("isWhitelisted: rejecting " + request.getRemoteAddr() + ", " + request.getRemoteHost());
        return false;
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindClusterViewService(ClusterViewService clusterViewService) {
        this.clusterViewService = clusterViewService;
    }

    protected void unbindClusterViewService(ClusterViewService clusterViewService) {
        if (this.clusterViewService == clusterViewService) {
            this.clusterViewService = null;
        }
    }

    protected void bindHeartbeatHandler(HeartbeatHandler heartbeatHandler) {
        this.heartbeatHandler = heartbeatHandler;
    }

    protected void unbindHeartbeatHandler(HeartbeatHandler heartbeatHandler) {
        if (this.heartbeatHandler == heartbeatHandler) {
            this.heartbeatHandler = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

