/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.connector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.topology.announcement.Announcement;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementFilter;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.TopologyConnectorClientInformation;
import org.apache.sling.discovery.impl.topology.connector.TopologyRequestValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyConnectorClient
implements TopologyConnectorClientInformation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final URL connectorUrl;
    private final ClusterViewService clusterViewService;
    private final Config config;
    private final UUID id;
    private final AnnouncementRegistry announcementRegistry;
    private Announcement lastInheritedAnnouncement;
    private long lastPingedAt;
    private final String serverInfo;
    private int lastStatusCode = -1;
    private boolean autoStopped = false;
    private String statusDetails = null;
    private boolean suppressPingWarnings_ = false;
    private TopologyRequestValidator requestValidator;
    private String lastRequestEncoding;
    private String lastResponseEncoding;
    private long backoffPeriodEnd = -1L;

    TopologyConnectorClient(ClusterViewService clusterViewService, AnnouncementRegistry announcementRegistry, Config config, URL connectorUrl, String serverInfo) {
        if (clusterViewService == null) {
            throw new IllegalArgumentException("clusterViewService must not be null");
        }
        if (announcementRegistry == null) {
            throw new IllegalArgumentException("announcementRegistry must not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (connectorUrl == null) {
            throw new IllegalArgumentException("connectorUrl must not be null");
        }
        this.requestValidator = new TopologyRequestValidator(config);
        this.clusterViewService = clusterViewService;
        this.announcementRegistry = announcementRegistry;
        this.config = config;
        this.connectorUrl = connectorUrl;
        this.serverInfo = serverInfo;
        this.id = UUID.randomUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ping(boolean force) {
        if (this.autoStopped) {
            this.logger.debug("ping: autoStopped=true, hence suppressing any further pings.");
            return;
        }
        if (force) {
            this.backoffPeriodEnd = -1L;
        } else if (this.backoffPeriodEnd > 0L) {
            if (System.currentTimeMillis() < this.backoffPeriodEnd) {
                this.logger.debug("ping: not issueing a heartbeat due to backoff instruction from peer.");
                return;
            }
            this.logger.debug("ping: backoff period ended, issuing another ping now.");
        }
        String uri = this.connectorUrl.toString() + "." + this.clusterViewService.getSlingId() + ".json";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ping: connectorUrl=" + this.connectorUrl + ", complete uri=" + uri);
        }
        HttpClient httpClient = new HttpClient();
        PutMethod method = new PutMethod(uri);
        Announcement resultingAnnouncement = null;
        try {
            String userInfo = this.connectorUrl.getUserInfo();
            if (userInfo != null) {
                UsernamePasswordCredentials c = new UsernamePasswordCredentials(userInfo);
                httpClient.getState().setCredentials(new AuthScope(method.getURI().getHost(), method.getURI().getPort()), (Credentials)c);
            }
            Announcement topologyAnnouncement = new Announcement(this.clusterViewService.getSlingId());
            topologyAnnouncement.setServerInfo(this.serverInfo);
            ClusterView clusterView = this.clusterViewService.getClusterView();
            topologyAnnouncement.setLocalCluster(clusterView);
            if (force) {
                this.logger.debug("ping: sending a resetBackoff");
                topologyAnnouncement.setResetBackoff(true);
            }
            this.announcementRegistry.addAllExcept(topologyAnnouncement, clusterView, new AnnouncementFilter(){

                public boolean accept(String receivingSlingId, Announcement announcement) {
                    for (InstanceDescription instance : TopologyConnectorClient.this.clusterViewService.getClusterView().getInstances()) {
                        if (!instance.getSlingId().equals(receivingSlingId)) continue;
                        return true;
                    }
                    return false;
                }
            });
            String p = this.requestValidator.encodeMessage(topologyAnnouncement.asJSON());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ping: topologyAnnouncement json is: " + p);
            }
            this.requestValidator.trustMessage((HttpMethod)method, p);
            if (this.config.isGzipConnectorRequestsEnabled()) {
                method.addRequestHeader("Content-Encoding", "gzip");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
                gzipOut.write(p.getBytes("UTF-8"));
                gzipOut.close();
                byte[] gzippedEncodedJson = baos.toByteArray();
                method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(gzippedEncodedJson, "application/json"));
                this.lastRequestEncoding = "gzip";
            } else {
                method.setRequestEntity((RequestEntity)new StringRequestEntity(p, "application/json", "UTF-8"));
                this.lastRequestEncoding = "plaintext";
            }
            method.addRequestHeader("Accept-Encoding", "gzip");
            DefaultHttpMethodRetryHandler retryhandler = new DefaultHttpMethodRetryHandler(0, false);
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)retryhandler);
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(1000 * this.config.getConnectionTimeout());
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(1000 * this.config.getSoTimeout());
            method.getParams().setSoTimeout(1000 * this.config.getSoTimeout());
            httpClient.executeMethod((HttpMethod)method);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ping: done. code=" + method.getStatusCode() + " - " + method.getStatusText());
            }
            this.lastStatusCode = method.getStatusCode();
            this.lastResponseEncoding = null;
            if (method.getStatusCode() == 200) {
                Header contentEncoding = method.getResponseHeader("Content-Encoding");
                this.lastResponseEncoding = contentEncoding != null && contentEncoding.getValue() != null && contentEncoding.getValue().contains("gzip") ? "gzip" : "plaintext";
                String responseBody = this.requestValidator.decodeMessage((HttpMethod)method);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ping: response body=" + responseBody);
                }
                if (responseBody != null && responseBody.length() > 0) {
                    Announcement inheritedAnnouncement = Announcement.fromJSON(responseBody);
                    long backoffInterval = inheritedAnnouncement.getBackoffInterval();
                    if (backoffInterval > 0L) {
                        this.backoffPeriodEnd = System.currentTimeMillis() + 1000L * backoffInterval - 1000L;
                        this.logger.debug("ping: servlet instructed to backoff: backoffInterval=" + backoffInterval + ", resulting in period end of " + new Date(this.backoffPeriodEnd));
                    } else {
                        this.logger.debug("ping: servlet did not instruct any backoff-ing at this stage");
                        this.backoffPeriodEnd = -1L;
                    }
                    if (inheritedAnnouncement.isLoop()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("ping: connector response indicated a loop detected. not registering this announcement from " + inheritedAnnouncement.getOwnerId());
                        }
                        if (inheritedAnnouncement.getOwnerId().equals(this.clusterViewService.getSlingId()) && this.config.isAutoStopLocalLoopEnabled()) {
                            inheritedAnnouncement = null;
                            this.autoStopped = true;
                        }
                    } else {
                        inheritedAnnouncement.setInherited(true);
                        if (this.announcementRegistry.registerAnnouncement(inheritedAnnouncement) == -1L) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("ping: connector response is from an instance which I already see in my topology" + inheritedAnnouncement);
                            }
                            this.statusDetails = "receiving side is seeing me via another path (connector or cluster) already (loop)";
                            return;
                        }
                    }
                    resultingAnnouncement = inheritedAnnouncement;
                    this.statusDetails = null;
                } else {
                    this.statusDetails = "no response body received";
                }
            } else {
                this.statusDetails = "got HTTP Status-Code: " + this.lastStatusCode;
            }
            this.suppressPingWarnings_ = false;
        }
        catch (URIException e) {
            this.logger.warn("ping: Got URIException: " + (Object)((Object)e) + ", uri=" + uri);
            this.statusDetails = e.toString();
        }
        catch (IOException e) {
            if (this.suppressPingWarnings_) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ping: got IOException: " + e + ", uri=" + uri);
                }
            } else {
                this.suppressPingWarnings_ = true;
                this.logger.warn("ping: got IOException [suppressing further warns]: " + e + ", uri=" + uri);
            }
            this.statusDetails = e.toString();
        }
        catch (JSONException e) {
            this.logger.warn("ping: got JSONException: " + (Object)((Object)e));
            this.statusDetails = e.toString();
        }
        catch (RuntimeException re) {
            this.logger.warn("ping: got RuntimeException: " + re, (Throwable)re);
            this.statusDetails = re.toString();
        }
        finally {
            method.releaseConnection();
            this.lastInheritedAnnouncement = resultingAnnouncement;
            this.lastPingedAt = System.currentTimeMillis();
        }
    }

    public int getStatusCode() {
        return this.lastStatusCode;
    }

    public URL getConnectorUrl() {
        return this.connectorUrl;
    }

    public boolean representsLoop() {
        if (this.autoStopped) {
            return true;
        }
        if (this.lastInheritedAnnouncement == null) {
            return false;
        }
        return this.lastInheritedAnnouncement.isLoop();
    }

    public boolean isConnected() {
        if (this.autoStopped) {
            return false;
        }
        if (this.lastInheritedAnnouncement == null) {
            return false;
        }
        return this.announcementRegistry.hasActiveAnnouncement(this.lastInheritedAnnouncement.getOwnerId());
    }

    public String getStatusDetails() {
        if (this.autoStopped) {
            return "auto-stopped";
        }
        if (this.lastInheritedAnnouncement == null) {
            return this.statusDetails;
        }
        if (this.announcementRegistry.hasActiveAnnouncement(this.lastInheritedAnnouncement.getOwnerId())) {
            return null;
        }
        return "received announcement has expired (it was last renewed " + new Date(this.lastPingedAt) + ") - consider increasing heartbeat timeout";
    }

    public long getLastHeartbeatSent() {
        return this.lastPingedAt;
    }

    public int getNextHeartbeatDue() {
        long absDue = this.backoffPeriodEnd > 0L ? this.backoffPeriodEnd : this.lastPingedAt + 1000L * this.config.getHeartbeatInterval();
        int relDue = (int)((absDue - System.currentTimeMillis()) / 1000L);
        if (relDue < 0) {
            return -1;
        }
        return relDue;
    }

    public boolean isAutoStopped() {
        return this.autoStopped;
    }

    public String getLastRequestEncoding() {
        return this.lastRequestEncoding == null ? "" : this.lastRequestEncoding;
    }

    public String getLastResponseEncoding() {
        return this.lastResponseEncoding == null ? "" : this.lastResponseEncoding;
    }

    public String getRemoteSlingId() {
        if (this.lastInheritedAnnouncement == null) {
            return null;
        }
        return this.lastInheritedAnnouncement.getOwnerId();
    }

    public String getId() {
        return this.id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        String uri = this.connectorUrl.toString() + "." + this.clusterViewService.getSlingId() + ".json";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("disconnect: connectorUrl=" + this.connectorUrl + ", complete uri=" + uri);
        }
        if (this.lastInheritedAnnouncement != null) {
            this.announcementRegistry.unregisterAnnouncement(this.lastInheritedAnnouncement.getOwnerId());
        }
        HttpClient httpClient = new HttpClient();
        DeleteMethod method = new DeleteMethod(uri);
        try {
            String userInfo = this.connectorUrl.getUserInfo();
            if (userInfo != null) {
                UsernamePasswordCredentials c = new UsernamePasswordCredentials(userInfo);
                httpClient.getState().setCredentials(new AuthScope(method.getURI().getHost(), method.getURI().getPort()), (Credentials)c);
            }
            this.requestValidator.trustMessage((HttpMethod)method, null);
            httpClient.executeMethod((HttpMethod)method);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("disconnect: done. code=" + method.getStatusCode() + " - " + method.getStatusText());
            }
        }
        catch (URIException e) {
            this.logger.warn("disconnect: Got URIException: " + (Object)((Object)e));
        }
        catch (IOException e) {
            this.logger.warn("disconnect: got IOException: " + e);
        }
        catch (RuntimeException re) {
            this.logger.error("disconnect: got RuntimeException: " + re, (Throwable)re);
        }
        finally {
            method.releaseConnection();
        }
    }
}

