/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster.voting;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.voting.VotingHelper;
import org.apache.sling.discovery.impl.cluster.voting.VotingView;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventHandler.class, VotingHandler.class})
@Properties(value={@Property(name="service.description", value={"New Voting Event Listener."}), @Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"})})
public class VotingHandler
implements EventHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService slingSettingsService;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private Config config;
    private String slingId;

    protected void activate(ComponentContext context) {
        this.slingId = this.slingSettingsService.getSlingId();
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getCanonicalName() + "." + this.slingId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        String resourcePath = (String)event.getProperty("path");
        String ongoingVotingsPath = this.config.getOngoingVotingsPath();
        if (resourcePath == null) {
            return;
        }
        if (!resourcePath.startsWith(ongoingVotingsPath)) {
            return;
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            return;
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleEvent: path = " + resourcePath + ", event = " + event);
            }
            this.analyzeVotings(resourceResolver);
        }
        catch (PersistenceException e) {
            this.logger.error("handleEvent: got a PersistenceException during votings analysis: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    public synchronized void analyzeVotings(ResourceResolver resourceResolver) throws PersistenceException {
        resourceResolver.refresh();
        VotingView winningVote = VotingHelper.getWinningVoting(resourceResolver, this.config);
        if (winningVote != null) {
            if (winningVote.isInitiatedBy(this.slingId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("analyzeVotings: my voting was winning. I'll mark it as established then! " + winningVote);
                }
                this.promote(resourceResolver, winningVote.getResource());
                resourceResolver.commit();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("analyzeVotings: there is a winning vote. No need to vote any further. Expecting it to get promoted to established: " + winningVote);
            }
        }
        List<VotingView> ongoingVotings = VotingHelper.listOpenNonWinningVotings(resourceResolver, this.config);
        Resource clusterNodesRes = resourceResolver.getResource(this.config.getClusterInstancesPath());
        Iterator<VotingView> it = ongoingVotings.iterator();
        while (it.hasNext()) {
            VotingView ongoingVotingRes = it.next();
            if (winningVote != null && !winningVote.equals(ongoingVotingRes) && !ongoingVotingRes.hasVotedOrIsInitiator(this.slingId)) {
                ongoingVotingRes.vote(this.slingId, false);
                it.remove();
                continue;
            }
            if (!ongoingVotingRes.matchesLiveView(clusterNodesRes, this.config)) {
                this.logger.warn("analyzeVotings: encountered a voting which does not match mine. Voting no: " + ongoingVotingRes);
                ongoingVotingRes.vote(this.slingId, false);
                it.remove();
                continue;
            }
            if (!ongoingVotingRes.isInitiatedBy(this.slingId) || !ongoingVotingRes.hasNoVotes()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("analyzeVotings: there were no votes for my voting, so I have to remove it: " + ongoingVotingRes);
            }
            ongoingVotingRes.remove();
            it.remove();
        }
        if (winningVote != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("analyzeVotings: done with vote-handling. there was a winner.");
            }
            return;
        }
        if (ongoingVotings.size() == 0) {
            return;
        }
        if (ongoingVotings.size() == 1) {
            VotingView votingResource = ongoingVotings.get(0);
            if (votingResource.isInitiatedBy(this.slingId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("analyzeVotings: only one voting found, and it is mine. I dont have to vote therefore: " + votingResource);
                }
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("analyzeVotings: only one voting found for which I did not yet vote - and it is not mine. I'll vote yes then: " + votingResource);
            }
            votingResource.vote(this.slingId, true);
        }
        Collections.sort(ongoingVotings, new Comparator<VotingView>(){

            @Override
            public int compare(VotingView o1, VotingView o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return 1;
                }
                if (o2 == null && o1 != null) {
                    return -1;
                }
                return o1.getViewId().compareTo(o2.getViewId());
            }
        });
        VotingView myYesVoteResource = VotingHelper.getYesVotingOf(resourceResolver, this.config, this.slingId);
        VotingView lowestVoting = ongoingVotings.get(0);
        if (myYesVoteResource != null && lowestVoting.equals(myYesVoteResource)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("analyzeVotings: my voted for view is currently already the lowest id. which is good. I dont have to change any voting. " + myYesVoteResource);
            }
        } else if (myYesVoteResource == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("analyzeVotings: I apparently have not yet voted. So I shall vote now for the lowest id which is: " + lowestVoting);
            }
            lowestVoting.vote(this.slingId, true);
        } else {
            this.logger.warn("analyzeVotings: I've already voted - but it so happened that there was a lower voting created after I voted... so I shall change my vote from " + myYesVoteResource + " to " + lowestVoting);
            myYesVoteResource.vote(this.slingId, null);
            lowestVoting.vote(this.slingId, true);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("analyzeVotings: all done now. I've voted yes for " + lowestVoting);
        }
    }

    public void cleanupTimedoutVotings(ResourceResolver resourceResolver) {
        List<VotingView> timedoutVotings = VotingHelper.listTimedoutVotings(resourceResolver, this.config);
        for (VotingView timedoutVotingRes : timedoutVotings) {
            if (timedoutVotingRes == null) continue;
            this.logger.info("cleanupTimedoutVotings: removing a timed out voting: " + timedoutVotingRes);
            timedoutVotingRes.remove();
        }
    }

    private void promote(ResourceResolver resourceResolver, Resource winningVoteResource) throws PersistenceException {
        Resource previousViewsResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getPreviousViewPath());
        Resource establishedViewsResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getEstablishedViewPath());
        Resource ongoingVotingsResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getOngoingVotingsPath());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("promote: previousViewsResource=" + previousViewsResource.getPath());
            this.logger.debug("promote: establishedViewsResource=" + establishedViewsResource.getPath());
            this.logger.debug("promote: ongoingVotingsResource=" + ongoingVotingsResource.getPath());
            this.logger.debug("promote: winningVoteResource=" + winningVoteResource.getPath());
        }
        for (Resource previousView : previousViewsResource.getChildren()) {
            resourceResolver.delete(previousView);
        }
        Iterator it = establishedViewsResource.getChildren().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Resource retiredView = (Resource)it.next();
            if (first) {
                boolean bl = first = !first;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("promote: moving the old established view to previous views: " + retiredView.getPath());
                }
                ResourceHelper.moveResource(retiredView, previousViewsResource.getPath() + "/" + retiredView.getName());
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("promote: retiring an erroneously additionally established node " + retiredView.getPath());
            }
            resourceResolver.delete(retiredView);
        }
        Iterator it2 = winningVoteResource.getChild("members").getChildren().iterator();
        String leaderElectionId = null;
        String leaderid = null;
        while (it2.hasNext()) {
            Resource aMember = (Resource)it2.next();
            String leid = (String)((ValueMap)aMember.adaptTo(ValueMap.class)).get("leaderElectionId", String.class);
            if (leaderElectionId != null && (leid == null || leid.compareTo(leaderElectionId) >= 0)) continue;
            leaderElectionId = leid;
            leaderid = aMember.getName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("promote: leader is " + leaderid + " - with leaderElectionId=" + leaderElectionId);
        }
        ModifiableValueMap winningVoteMap = (ModifiableValueMap)winningVoteResource.adaptTo(ModifiableValueMap.class);
        winningVoteMap.put((Object)"leaderId", leaderid);
        winningVoteMap.put((Object)"leaderElectionId", (Object)leaderElectionId);
        winningVoteMap.put((Object)"promotedAt", (Object)Calendar.getInstance());
        winningVoteMap.put((Object)"promotedBy", (Object)this.slingId);
        String newEstablishedViewPath = establishedViewsResource.getPath() + "/" + winningVoteResource.getName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("promote: promote to new established node " + newEstablishedViewPath);
        }
        ResourceHelper.moveResource(winningVoteResource, newEstablishedViewPath);
        Iterable ongoingVotingsChildren = ongoingVotingsResource.getChildren();
        if (ongoingVotingsChildren != null) {
            for (Resource anOngoingVoting : ongoingVotingsChildren) {
                resourceResolver.delete(anOngoingVoting);
            }
        }
        for (Resource resource : ongoingVotingsResource.getParent().getChildren()) {
            if (!resource.getPath().startsWith(this.config.getOngoingVotingsPath()) || resource.getPath().equals(this.config.getOngoingVotingsPath())) continue;
            this.logger.warn("promote: cleaning up a duplicate ongoingVotingPath: " + resource.getPath());
            resourceResolver.delete(resource);
        }
        this.logger.debug("promote: done with promotiong. saving.");
        resourceResolver.commit();
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

