/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.announcement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;
import org.apache.sling.discovery.impl.topology.announcement.Announcement;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementFilter;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.announcement.CachedAnnouncement;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={AnnouncementRegistry.class})
public class AnnouncementRegistryImpl
implements AnnouncementRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private Config config;
    private final Map<String, CachedAnnouncement> ownAnnouncementsCache = new HashMap<String, CachedAnnouncement>();

    @Override
    public synchronized void unregisterAnnouncement(String ownerId) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("ownerId must not be null or empty");
        }
        this.ownAnnouncementsCache.remove(ownerId);
        if (this.resourceResolverFactory == null) {
            this.logger.error("unregisterAnnouncement: resourceResolverFactory is null");
            return;
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            String path = this.config.getClusterInstancesPath() + "/" + this.settingsService.getSlingId() + "/announcements/" + ownerId;
            Resource announcementsResource = resourceResolver.getResource(path);
            if (announcementsResource != null) {
                resourceResolver.delete(announcementsResource);
                resourceResolver.commit();
            }
        }
        catch (LoginException e) {
            this.logger.error("unregisterAnnouncement: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("unregisterAnnouncement: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public synchronized Collection<Announcement> listLocalAnnouncements() {
        return this.fillWithCachedAnnouncements(new LinkedList<Announcement>());
    }

    @Override
    public synchronized Collection<CachedAnnouncement> listLocalIncomingAnnouncements() {
        LinkedList<CachedAnnouncement> result = new LinkedList<CachedAnnouncement>(this.ownAnnouncementsCache.values());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CachedAnnouncement cachedAnnouncement = (CachedAnnouncement)it.next();
            if (cachedAnnouncement.getAnnouncement().isInherited()) {
                it.remove();
                continue;
            }
            if (!cachedAnnouncement.hasExpired()) continue;
            it.remove();
        }
        return result;
    }

    private final InstanceDescription getLocalInstanceDescription(ClusterView localClusterView) {
        for (InstanceDescription id : localClusterView.getInstances()) {
            if (!id.isLocal()) continue;
            return id;
        }
        return null;
    }

    @Override
    public synchronized Collection<Announcement> listAnnouncementsInSameCluster(ClusterView localClusterView) {
        if (localClusterView == null) {
            throw new IllegalArgumentException("clusterView must not be null");
        }
        ResourceResolver resourceResolver = null;
        LinkedList<Announcement> incomingAnnouncements = new LinkedList<Announcement>();
        InstanceDescription localInstance = this.getLocalInstanceDescription(localClusterView);
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource clusterInstancesResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath());
            for (Resource aClusterInstanceResource : clusterInstancesResource.getChildren()) {
                Resource announcementsResource;
                String instanceId = aClusterInstanceResource.getName();
                if (localInstance != null && localInstance.getSlingId().equals(instanceId)) {
                    this.fillWithCachedAnnouncements(incomingAnnouncements);
                    continue;
                }
                if (!this.contains(localClusterView, instanceId) || (announcementsResource = aClusterInstanceResource.getChild("announcements")) == null) continue;
                for (Resource anAnnouncement : announcementsResource.getChildren()) {
                    Announcement topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class));
                    incomingAnnouncements.add(topologyAnnouncement);
                }
            }
        }
        catch (LoginException e) {
            this.logger.error("listAnnouncementsInSameCluster: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("listAnnouncementsInSameCluster: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JSONException e) {
            this.logger.error("listAnnouncementsInSameCluster: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("listAnnouncementsInSameCluster: result: " + incomingAnnouncements.size());
        }
        return incomingAnnouncements;
    }

    private final Collection<Announcement> fillWithCachedAnnouncements(Collection<Announcement> incomingAnnouncements) {
        for (Map.Entry<String, CachedAnnouncement> entry : this.ownAnnouncementsCache.entrySet()) {
            if (entry.getValue().hasExpired()) continue;
            incomingAnnouncements.add(entry.getValue().getAnnouncement());
        }
        return incomingAnnouncements;
    }

    private final boolean contains(ClusterView clusterView, String instanceId) {
        for (InstanceDescription instance : clusterView.getInstances()) {
            if (!instance.getSlingId().equals(instanceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean hasActiveAnnouncement(String ownerId) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("ownerId must not be null or empty: " + ownerId);
        }
        CachedAnnouncement cachedAnnouncement = this.ownAnnouncementsCache.get(ownerId);
        if (cachedAnnouncement == null) {
            return false;
        }
        return !cachedAnnouncement.hasExpired();
    }

    @Override
    public synchronized long registerAnnouncement(Announcement topologyAnnouncement) {
        if (topologyAnnouncement == null) {
            throw new IllegalArgumentException("topologyAnnouncement must not be null");
        }
        if (!topologyAnnouncement.isValid()) {
            this.logger.warn("topologyAnnouncement is not valid");
            return -1L;
        }
        if (this.resourceResolverFactory == null) {
            this.logger.error("registerAnnouncement: resourceResolverFactory is null");
            return -1L;
        }
        CachedAnnouncement cachedAnnouncement = this.ownAnnouncementsCache.get(topologyAnnouncement.getOwnerId());
        if (cachedAnnouncement != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("registerAnnouncement: got existing cached announcement for ownerId=" + topologyAnnouncement.getOwnerId());
            }
            try {
                if (topologyAnnouncement.correspondsTo(cachedAnnouncement.getAnnouncement())) {
                    this.logger.debug("registerAnnouncement: nothing has changed, only updating heartbeat in-memory.");
                    return cachedAnnouncement.registerHeartbeat(topologyAnnouncement, this.config);
                }
                this.logger.debug("registerAnnouncement: incoming announcement differs from existing one!");
            }
            catch (JSONException e) {
                this.logger.error("registerAnnouncement: got JSONException while converting incoming announcement to JSON: " + (Object)((Object)e), (Throwable)e);
            }
            this.ownAnnouncementsCache.remove(topologyAnnouncement.getOwnerId());
        } else {
            this.logger.debug("registerAnnouncement: no cached announcement yet for ownerId=" + topologyAnnouncement.getOwnerId());
        }
        this.logger.debug("registerAnnouncement: getting the list of all local announcements");
        LinkedList<Announcement> announcements = new LinkedList<Announcement>();
        this.fillWithCachedAnnouncements(announcements);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("registerAnnouncement: list returned: " + (announcements == null ? "null" : Integer.valueOf(announcements.size())));
        }
        for (Announcement announcement : announcements) {
            if (announcement.getOwnerId().equals(topologyAnnouncement.getOwnerId())) continue;
            Collection<InstanceDescription> attachedInstances = announcement.listInstances();
            for (InstanceDescription instanceDescription : attachedInstances) {
                if (!topologyAnnouncement.getOwnerId().equals(instanceDescription.getSlingId())) continue;
                this.logger.info("registerAnnouncement: already have this instance attached: " + instanceDescription.getSlingId());
                return -1L;
            }
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource announcementsResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath() + "/" + this.settingsService.getSlingId() + "/announcements");
            topologyAnnouncement.persistTo(announcementsResource);
            resourceResolver.commit();
            this.ownAnnouncementsCache.put(topologyAnnouncement.getOwnerId(), new CachedAnnouncement(topologyAnnouncement, this.config));
        }
        catch (LoginException e) {
            this.logger.error("registerAnnouncement: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("registerAnnouncement: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JSONException e) {
            this.logger.error("registerAnnouncement: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return 0L;
    }

    @Override
    public synchronized void addAllExcept(Announcement target, ClusterView clusterView, AnnouncementFilter filter) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource clusterInstancesResource = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath());
            for (Resource aClusterInstanceResource : clusterInstancesResource.getChildren()) {
                Resource announcementsResource;
                String instanceId = aClusterInstanceResource.getName();
                if (!this.contains(clusterView, instanceId) || (announcementsResource = aClusterInstanceResource.getChild("announcements")) == null) continue;
                for (Resource anAnnouncement : announcementsResource.getChildren()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("addAllExcept: anAnnouncement=" + anAnnouncement);
                    }
                    Announcement topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class));
                    if (filter != null && !filter.accept(aClusterInstanceResource.getName(), topologyAnnouncement)) continue;
                    target.addIncomingTopologyAnnouncement(topologyAnnouncement);
                }
            }
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("handleEvent: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JSONException e) {
            this.logger.error("handleEvent: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public synchronized void checkExpiredAnnouncements() {
        Iterator<Map.Entry<String, CachedAnnouncement>> it = this.ownAnnouncementsCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CachedAnnouncement> entry = it.next();
            if (!entry.getValue().hasExpired()) continue;
            it.remove();
            String instanceId = entry.getKey();
            this.logger.info("checkExpiredAnnouncements: topology connector of " + instanceId + " has expired.");
            this.deleteAnnouncementsOf(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteAnnouncementsOf(String instanceId) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            ResourceHelper.deleteResource(resourceResolver, this.config.getClusterInstancesPath() + "/" + this.settingsService.getSlingId() + "/announcements/" + instanceId);
            resourceResolver.commit();
            resourceResolver.close();
            resourceResolver = null;
        }
        catch (LoginException e) {
            this.logger.error("deleteAnnouncementsOf: could not log in administratively when deleting announcements of instanceId=" + instanceId + ": " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("deleteAnnouncementsOf: got PersistenceException when deleting announcements of instanceId=" + instanceId + ": " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.revert();
                resourceResolver.close();
                resourceResolver = null;
            }
        }
    }

    @Override
    public synchronized Collection<InstanceDescription> listInstances(ClusterView localClusterView) {
        LinkedList<InstanceDescription> instances = new LinkedList<InstanceDescription>();
        Collection<Announcement> announcements = this.listAnnouncementsInSameCluster(localClusterView);
        if (announcements == null) {
            return instances;
        }
        for (Announcement announcement : announcements) {
            instances.addAll(announcement.listInstances());
        }
        return instances;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

