/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.common.View;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.apache.sling.discovery.impl.common.resource.EstablishedClusterView;
import org.apache.sling.discovery.impl.common.resource.IsolatedInstanceDescription;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={ClusterViewService.class})
public class ClusterViewServiceImpl
implements ClusterViewService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Config config;
    private String isolatedClusterViewId = UUID.randomUUID().toString();

    @Override
    public String getIsolatedClusterViewId() {
        return this.isolatedClusterViewId;
    }

    private ClusterView getIsolatedClusterView() {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource instanceResource = resourceResolver.getResource(this.config.getClusterInstancesPath() + "/" + this.getSlingId());
            IsolatedInstanceDescription ownInstance = new IsolatedInstanceDescription(instanceResource, this.isolatedClusterViewId, this.getSlingId());
            ClusterView clusterView = ownInstance.getClusterView();
            return clusterView;
        }
        catch (LoginException e) {
            this.logger.error("Could not do a login: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not do a login", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public String getSlingId() {
        if (this.settingsService == null) {
            return null;
        }
        return this.settingsService.getSlingId();
    }

    @Override
    public boolean contains(String slingId) {
        List localInstances = this.getClusterView().getInstances();
        for (InstanceDescription aLocalInstance : localInstances) {
            if (!aLocalInstance.getSlingId().equals(slingId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(Collection<InstanceDescription> listInstances) {
        for (InstanceDescription instanceDescription : listInstances) {
            if (!this.contains(instanceDescription.getSlingId())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterView getClusterView() {
        if (this.resourceResolverFactory == null) {
            this.logger.warn("getClusterView: no resourceResolverFactory set at the moment.");
            return null;
        }
        ResourceResolver resourceResolver = null;
        try {
            EstablishedClusterView establishedClusterView;
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            View view = ViewHelper.getEstablishedView(resourceResolver, this.config);
            if (view == null) {
                this.logger.debug("getClusterView: no view established at the moment. isolated mode");
                ClusterView clusterView = this.getIsolatedClusterView();
                return clusterView;
            }
            EstablishedClusterView clusterViewImpl = new EstablishedClusterView(this.config, view, this.getSlingId());
            boolean foundLocal = false;
            for (InstanceDescription instance : clusterViewImpl.getInstances()) {
                if (!instance.isLocal()) continue;
                foundLocal = true;
                break;
            }
            if (foundLocal) {
                establishedClusterView = clusterViewImpl;
                return establishedClusterView;
            }
            this.logger.info("getClusterView: the existing established view does not incude the local instance (" + this.getSlingId() + ") yet! Assuming isolated mode. " + "If this occurs at runtime - other than at startup - it could cause a pseudo-network-partition, see SLING-3432. " + "Consider increasing heartbeatTimeout then!");
            establishedClusterView = this.getIsolatedClusterView();
            return establishedClusterView;
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            ClusterView clusterView = null;
            return clusterView;
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

