/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster.voting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.voting.VotingView;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VotingHelper {
    private static final Logger logger = LoggerFactory.getLogger(VotingHelper.class);

    public static List<VotingView> listOpenNonWinningVotings(ResourceResolver resourceResolver, Config config) {
        if (config == null) {
            logger.info("listOpenNonWinningVotings: config is null, bundle likely deactivated.");
            return new ArrayList<VotingView>();
        }
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            logger.info("listOpenNonWinningVotings: no ongoing votings parent resource found");
            return new ArrayList<VotingView>();
        }
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        if (!it.hasNext()) {
            return result;
        }
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            if (c.matchesLiveView(config) && c.isOngoingVoting(config) && !c.hasNoVotes() && !c.isWinning()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("listOpenNonWinningVotings: found a valid voting: " + aChild + ", properties=" + ResourceHelper.getPropertiesForLogging(aChild));
                }
                result.add(c);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("listOpenNonWinningVotings: found an invalid voting: " + aChild + ", matches live: " + c.matchesLiveView(config) + ", is ongoing: " + c.isOngoingVoting(config) + ", has no votes: " + c.hasNoVotes() + ", is winning: " + c.isWinning() + ", properties=" + ResourceHelper.getPropertiesForLogging(aChild));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listOpenNonWinningVotings: votings found: " + result.size());
        }
        return result;
    }

    public static List<VotingView> listTimedoutVotings(ResourceResolver resourceResolver, Config config) {
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            logger.info("listTimedoutVotings: no ongoing votings parent resource found");
            return new ArrayList<VotingView>();
        }
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        if (!it.hasNext()) {
            return result;
        }
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            if (!c.isTimedoutVoting(config)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("listTimedoutVotings: found a timed-out voting: " + aChild + ", properties=" + ResourceHelper.getPropertiesForLogging(aChild));
            }
            result.add(c);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listTimedoutVotings: votings found: " + result.size());
        }
        return result;
    }

    public static VotingView getWinningVoting(ResourceResolver resourceResolver, Config config) {
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            logger.info("getWinningVoting: no ongoing votings parent resource found");
            return null;
        }
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            if (!c.isOngoingVoting(config) || !c.isWinning()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("getWinningVoting: a winning voting: " + c);
            }
            result.add(c);
        }
        if (result.size() == 1) {
            return (VotingView)result.get(0);
        }
        return null;
    }

    public static VotingView getYesVotingOf(ResourceResolver resourceResolver, Config config, String slingId) {
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            if (!c.hasVotedOrIsInitiator(slingId)) continue;
            result.add(c);
        }
        if (result.size() >= 1) {
            return (VotingView)result.get(0);
        }
        return null;
    }
}

