/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common.resource;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class ResourceHelper {
    private static final String DEFAULT_RESOURCE_TYPE = "sling:Folder";

    public static Resource getOrCreateResource(ResourceResolver resourceResolver, String path) throws PersistenceException {
        return ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)path, (String)DEFAULT_RESOURCE_TYPE, (String)DEFAULT_RESOURCE_TYPE, (boolean)true);
    }

    public static boolean deleteResource(ResourceResolver resourceResolver, String path) throws PersistenceException {
        Resource resource = resourceResolver.getResource(path);
        if (resource == null) {
            return false;
        }
        resourceResolver.delete(resource);
        return true;
    }

    public static StringBuilder getPropertiesForLogging(Resource resource) {
        ValueMap valueMap;
        try {
            valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
        }
        catch (RuntimeException re) {
            return new StringBuilder("non-existing resource: " + resource + " (" + re.getMessage() + ")");
        }
        if (valueMap == null) {
            return new StringBuilder("non-existing resource: " + resource + " (no ValueMap)");
        }
        Set entrySet = valueMap.entrySet();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : entrySet) {
            sb.append(" ");
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return sb;
    }

    public static void moveResource(Resource res, String path) throws PersistenceException {
        Node node = (Node)res.adaptTo(Node.class);
        if (node != null) {
            try {
                Session session = node.getSession();
                session.move(res.getPath(), path);
            }
            catch (RepositoryException re) {
                throw new PersistenceException("Move from " + res.getPath() + " to " + path + " failed.", (Throwable)re);
            }
        } else {
            ResourceHelper.moveResourceWithResourceAPI(res, path);
        }
    }

    private static void moveResourceWithResourceAPI(Resource res, String path) throws PersistenceException {
        String parentPath = ResourceUtil.getParent((String)path);
        Resource parent = res.getResourceResolver().getResource(parentPath);
        if (parent == null) {
            throw new PersistenceException("Parent resource does not exist: " + parentPath);
        }
        ResourceHelper.copyResourceWithResourceAPI(res, parent, ResourceUtil.getName((String)path));
        res.getResourceResolver().delete(res);
    }

    private static void copyResourceWithResourceAPI(Resource source, Resource destParent, String name) throws PersistenceException {
        Resource copy = source.getResourceResolver().create(destParent, name, (Map)ResourceUtil.getValueMap((Resource)source));
        Iterator children = source.listChildren();
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            ResourceHelper.copyResourceWithResourceAPI(child, copy, child.getName());
        }
    }

    public static boolean isValidPropertyName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return name.matches("[a-zA-Z0-9._-]+");
    }
}

