/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.announcement;

import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.topology.announcement.Announcement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedAnnouncement {
    private static final Logger logger = LoggerFactory.getLogger(CachedAnnouncement.class);
    private long lastHeartbeat = System.currentTimeMillis();
    private final Announcement announcement;
    private long firstHeartbeat = System.currentTimeMillis();
    private long backoffIntervalSeconds = -1L;
    private final Config config;

    CachedAnnouncement(Announcement announcement, Config config) {
        this.announcement = announcement;
        this.config = config;
    }

    private long getConfiguredHeartbeatTimeout() {
        return this.config.getHeartbeatTimeout();
    }

    private long getConfiguredHeartbeatInterval() {
        return this.config.getHeartbeatInterval();
    }

    public final boolean hasExpired() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastHeartbeat;
        return diff >= 1000L * this.getEffectiveHeartbeatTimeout();
    }

    public final long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public final long getSecondsUntilTimeout() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastHeartbeat;
        long left = 1000L * this.getEffectiveHeartbeatTimeout() - diff;
        return left / 1000L;
    }

    private final long getEffectiveHeartbeatTimeout() {
        long configuredGoodwill = this.getConfiguredHeartbeatTimeout() - this.getConfiguredHeartbeatInterval();
        return Math.max(this.getConfiguredHeartbeatTimeout(), this.backoffIntervalSeconds + configuredGoodwill);
    }

    final long registerHeartbeat(Announcement incomingAnnouncement, Config config) {
        this.lastHeartbeat = System.currentTimeMillis();
        if (incomingAnnouncement.isInherited()) {
            this.backoffIntervalSeconds = incomingAnnouncement.getBackoffInterval();
            logger.debug("registerHeartbeat: inherited announcement - hence returning 0");
            return 0L;
        }
        if (incomingAnnouncement.getResetBackoff()) {
            this.firstHeartbeat = this.lastHeartbeat;
            logger.debug("registerHeartbeat: got a resetBackoff - hence returning 0");
            return 0L;
        }
        long stableSince = this.lastHeartbeat - this.firstHeartbeat;
        long numStableTimeouts = stableSince / config.getHeartbeatTimeoutMillis();
        long backoffFactor = Math.min(numStableTimeouts, (long)config.getBackoffStableFactor());
        this.backoffIntervalSeconds = backoffFactor * config.getHeartbeatInterval();
        return this.backoffIntervalSeconds;
    }

    public final Announcement getAnnouncement() {
        return this.announcement;
    }
}

