/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.DiscoveryServiceMBeanImpl;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.cluster.UndefinedClusterViewException;
import org.apache.sling.discovery.impl.common.DefaultClusterViewImpl;
import org.apache.sling.discovery.impl.common.DefaultInstanceDescriptionImpl;
import org.apache.sling.discovery.impl.common.heartbeat.HeartbeatHandler;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;
import org.apache.sling.discovery.impl.topology.TopologyViewImpl;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.ConnectorRegistry;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DiscoveryService.class, DiscoveryServiceImpl.class})
public class DiscoveryServiceImpl
implements DiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryServiceImpl.class);
    @Reference
    private SlingSettingsService settingsService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=TopologyEventListener.class)
    private TopologyEventListener[] eventListeners = new TopologyEventListener[0];
    private Map<TopologyEventListener, TopologyEvent.Type> lastEventMap = new HashMap<TopologyEventListener, TopologyEvent.Type>();
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=PropertyProvider.class, updated="updatedPropertyProvider")
    private List<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
    private final Object lock = new Object();
    private boolean activated = false;
    private boolean initEventDelayed = false;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private HeartbeatHandler heartbeatHandler;
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private ConnectorRegistry connectorRegistry;
    @Reference
    private ClusterViewService clusterViewService;
    @Reference
    private Config config;
    private String slingId;
    private TopologyViewImpl oldView;
    private volatile boolean delayedEventPending = false;
    private volatile boolean delayedEventPendingFailed = false;
    private ServiceRegistration mbeanRegistration;
    private AsyncEventSender asyncEventSender;

    protected void registerMBean(BundleContext bundleContext) {
        if (this.mbeanRegistration != null) {
            try {
                if (this.mbeanRegistration != null) {
                    this.mbeanRegistration.unregister();
                    this.mbeanRegistration = null;
                }
            }
            catch (Exception e) {
                logger.error("registerMBean: Error on unregister: " + e, (Throwable)e);
            }
        }
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
            ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=discovery,name=DiscoveryServiceImpl");
            DiscoveryServiceMBeanImpl mbean = new DiscoveryServiceMBeanImpl(this.heartbeatHandler);
            this.mbeanRegistration = bundleContext.registerService(DiscoveryServiceMBeanImpl.class.getName(), (Object)mbean, mbeanProps);
        }
        catch (Throwable t) {
            logger.warn("registerMBean: Unable to register DiscoveryServiceImpl MBean", t);
        }
    }

    private void setOldView(TopologyViewImpl view) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        this.oldView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.debug("DiscoveryServiceImpl activating...");
        if (this.settingsService == null) {
            throw new IllegalStateException("settingsService not found");
        }
        if (this.heartbeatHandler == null) {
            throw new IllegalStateException("heartbeatHandler not found");
        }
        this.slingId = this.settingsService.getSlingId();
        String isolatedClusterId = UUID.randomUUID().toString();
        DefaultClusterViewImpl isolatedCluster = new DefaultClusterViewImpl(isolatedClusterId);
        Object emptyProperties = new HashMap<String, String>();
        DefaultInstanceDescriptionImpl isolatedInstance = new DefaultInstanceDescriptionImpl(isolatedCluster, true, true, this.slingId, (Map<String, String>)emptyProperties);
        ArrayList<InstanceDescription> col = new ArrayList<InstanceDescription>();
        col.add(isolatedInstance);
        TopologyViewImpl topology = new TopologyViewImpl();
        topology.addInstances(col);
        topology.markOld();
        this.setOldView(topology);
        this.setOldView((TopologyViewImpl)this.getTopology());
        this.oldView.markOld();
        this.heartbeatHandler.initialize(this, isolatedClusterId);
        emptyProperties = this.lock;
        synchronized (emptyProperties) {
            this.asyncEventSender = new AsyncEventSender();
            Thread th = new Thread(this.asyncEventSender);
            th.setName("Discovery-AsyncEventSender");
            th.setDaemon(true);
            th.start();
            TopologyEventListener[] registeredServices = this.eventListeners;
            this.doUpdateProperties();
            TopologyViewImpl newView = (TopologyViewImpl)this.getTopology();
            if (!newView.isCurrent()) {
                logger.info("activate: this instance is in isolated mode and must yet finish voting before it can send out TOPOLOGY_INIT.");
                this.initEventDelayed = true;
            } else {
                TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_INIT, null, (TopologyView)newView);
                for (TopologyEventListener da : registeredServices) {
                    this.enqueueAsyncTopologyEvent(da, event);
                }
            }
            this.activated = true;
            this.setOldView(newView);
        }
        URL[] topologyConnectorURLs = this.config.getTopologyConnectorURLs();
        if (topologyConnectorURLs != null) {
            for (int i = 0; i < topologyConnectorURLs.length; ++i) {
                URL aURL = topologyConnectorURLs[i];
                if (aURL == null) continue;
                try {
                    logger.info("activate: registering outgoing topology connector to " + aURL);
                    this.connectorRegistry.registerOutgoingConnector(this.clusterViewService, aURL);
                    continue;
                }
                catch (Exception e) {
                    logger.info("activate: could not register url: " + aURL + " due to: " + e, (Throwable)e);
                }
            }
        }
        this.registerMBean(bundleContext);
        logger.debug("DiscoveryServiceImpl activated.");
    }

    private void enqueueAsyncTopologyEvent(TopologyEventListener da, TopologyEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("enqueueAsyncTopologyEvent: sending topologyEvent {}, to {}", (Object)event, (Object)da);
        }
        if (this.asyncEventSender == null) {
            logger.warn("enqueueAsyncTopologyEvent: asyncEventSender is null, cannot send event ({}, {})!", (Object)da, (Object)event);
            return;
        }
        if (this.lastEventMap.get(da) == event.getType() && event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            logger.debug("enqueueAsyncTopologyEvent: listener already got TOPOLOGY_CHANGING: {}", (Object)da);
            return;
        }
        this.asyncEventSender.enqueue(da, event);
        this.lastEventMap.put(da, event.getType());
        if (logger.isDebugEnabled()) {
            logger.debug("enqueueAsyncTopologyEvent: sending topologyEvent {}, to {}", (Object)event, (Object)da);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        logger.debug("DiscoveryServiceImpl deactivated.");
        Object object = this.lock;
        synchronized (object) {
            this.activated = false;
            if (this.asyncEventSender != null) {
                this.asyncEventSender.flushThenStop();
                this.asyncEventSender = null;
            }
        }
        try {
            if (this.mbeanRegistration != null) {
                this.mbeanRegistration.unregister();
                this.mbeanRegistration = null;
            }
        }
        catch (Exception e) {
            logger.error("deactivate: Error on unregister: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindTopologyEventListener(TopologyEventListener eventListener) {
        logger.debug("bindTopologyEventListener: Binding TopologyEventListener {}", (Object)eventListener);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<TopologyEventListener> currentList = new ArrayList<TopologyEventListener>(Arrays.asList(this.eventListeners));
            currentList.add(eventListener);
            this.eventListeners = currentList.toArray(new TopologyEventListener[currentList.size()]);
            if (this.activated && !this.initEventDelayed) {
                TopologyViewImpl topology = (TopologyViewImpl)this.getTopology();
                if (this.delayedEventPending) {
                    topology.markOld();
                }
                this.enqueueAsyncTopologyEvent(eventListener, new TopologyEvent(TopologyEvent.Type.TOPOLOGY_INIT, null, (TopologyView)topology));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindTopologyEventListener(TopologyEventListener eventListener) {
        logger.debug("unbindTopologyEventListener: Releasing TopologyEventListener {}", (Object)eventListener);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<TopologyEventListener> currentList = new ArrayList<TopologyEventListener>(Arrays.asList(this.eventListeners));
            currentList.remove(eventListener);
            this.eventListeners = currentList.toArray(new TopologyEventListener[currentList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("bindPropertyProvider: Binding PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.bindPropertyProviderInteral(propertyProvider, props);
        }
    }

    private void bindPropertyProviderInteral(PropertyProvider propertyProvider, Map<String, Object> props) {
        ProviderInfo info = new ProviderInfo(propertyProvider, props);
        this.providerInfos.add(info);
        Collections.sort(this.providerInfos);
        this.doUpdateProperties();
        this.handlePotentialTopologyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("bindPropertyProvider: Updating PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.unbindPropertyProviderInternal(propertyProvider, props, false);
            this.bindPropertyProviderInteral(propertyProvider, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("unbindPropertyProvider: Releasing PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.unbindPropertyProviderInternal(propertyProvider, props, true);
        }
    }

    private void unbindPropertyProviderInternal(PropertyProvider propertyProvider, Map<String, Object> props, boolean update) {
        ProviderInfo info = new ProviderInfo(propertyProvider, props);
        if (this.providerInfos.remove(info) && update) {
            this.doUpdateProperties();
            this.handlePotentialTopologyChange();
        }
    }

    private void doUpdateProperties() {
        if (this.resourceResolverFactory == null) {
            logger.debug("doUpdateProperties: too early to update the properties. resourceResolverFactory not yet set.");
            return;
        }
        logger.debug("doUpdateProperties: updating properties now..");
        HashMap<String, String> newProps = new HashMap<String, String>();
        for (ProviderInfo info : this.providerInfos) {
            info.refreshProperties();
            newProps.putAll(info.properties);
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource myInstance = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath() + "/" + this.slingId + "/properties");
            resourceResolver.revert();
            resourceResolver.refresh();
            ModifiableValueMap myInstanceMap = (ModifiableValueMap)myInstance.adaptTo(ModifiableValueMap.class);
            HashSet keys = new HashSet(myInstanceMap.keySet());
            for (String key : keys) {
                if (newProps.containsKey(key) || key.indexOf(":") != -1) continue;
                myInstanceMap.remove((Object)key);
            }
            boolean anyChanges = false;
            for (Map.Entry entry : newProps.entrySet()) {
                Object existingValue = myInstanceMap.get(entry.getKey());
                if (((String)entry.getValue()).equals(existingValue)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("doUpdateProperties: unchanged: {}={}", entry.getKey(), entry.getValue());
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("doUpdateProperties: changed: {}={}", entry.getKey(), entry.getValue());
                }
                anyChanges = true;
                myInstanceMap.put(entry.getKey(), entry.getValue());
            }
            if (anyChanges) {
                resourceResolver.commit();
            }
        }
        catch (LoginException e) {
            logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            logger.error("handleEvent: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        logger.debug("doUpdateProperties: updating properties done.");
    }

    public TopologyView getTopology() {
        if (this.clusterViewService == null) {
            throw new IllegalStateException("DiscoveryService not yet initialized with IClusterViewService");
        }
        TopologyViewImpl topology = new TopologyViewImpl();
        ClusterView localClusterView = null;
        try {
            localClusterView = this.clusterViewService.getClusterView();
        }
        catch (UndefinedClusterViewException e) {
            logger.info("getTopology: undefined cluster view: " + (Object)((Object)e.getReason()) + "] " + e);
            this.oldView.markOld();
            if (e.getReason() == UndefinedClusterViewException.Reason.ISOLATED_FROM_TOPOLOGY && this.heartbeatHandler != null && this.heartbeatHandler.resetLeaderElectionId()) {
                logger.info("getTopology: reset leaderElectionId to force this instance to the end of the instance order (thus incl not to remain leader)");
            }
            return this.oldView;
        }
        List localInstances = localClusterView.getInstances();
        topology.addInstances(localInstances);
        Collection<InstanceDescription> attachedInstances = this.announcementRegistry.listInstances(localClusterView);
        topology.addInstances(attachedInstances);
        return topology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties() {
        Object object = this.lock;
        synchronized (object) {
            logger.debug("updateProperties: calling doUpdateProperties.");
            this.doUpdateProperties();
            logger.debug("updateProperties: calling handlePotentialTopologyChange.");
            this.handlePotentialTopologyChange();
            logger.debug("updateProperties: done.");
        }
    }

    private void handlePotentialTopologyChange() {
        if (!this.activated) {
            logger.debug("handlePotentialTopologyChange: ignoring early change before activate finished.");
            return;
        }
        if (this.delayedEventPending && !this.delayedEventPendingFailed) {
            logger.debug("handlePotentialTopologyChange: ignoring potential change since a delayed event is pending.");
            return;
        }
        TopologyViewImpl newView = (TopologyViewImpl)this.getTopology();
        if (this.initEventDelayed) {
            if (!newView.isCurrent()) {
                logger.info("handlePotentialTopologyChange: still in isolated mode - cannot send TOPOLOGY_INIT yet.");
            } else {
                logger.info("handlePotentialTopologyChange: new view is no longer isolated sending delayed TOPOLOGY_INIT now.");
                this.enqueueForAll(TopologyEvent.Type.TOPOLOGY_INIT, null, newView);
                this.initEventDelayed = false;
            }
            return;
        }
        TopologyViewImpl oldView = this.oldView;
        TopologyEvent.Type difference = !newView.isCurrent() ? TopologyEvent.Type.TOPOLOGY_CHANGING : newView.compareTopology(oldView);
        if (difference == null) {
            if (this.delayedEventPendingFailed) {
                this.enqueueForAll(TopologyEvent.Type.TOPOLOGY_CHANGED, oldView, newView);
                this.delayedEventPendingFailed = false;
                this.delayedEventPending = false;
            } else {
                logger.debug("handlePotentialTopologyChange: identical views. not informing listeners");
            }
            return;
        }
        if (difference == TopologyEvent.Type.PROPERTIES_CHANGED) {
            this.enqueueForAll(TopologyEvent.Type.PROPERTIES_CHANGED, oldView, newView);
            return;
        }
        this.delayedEventPendingFailed = false;
        this.delayedEventPending = false;
        if (logger.isDebugEnabled()) {
            logger.debug("handlePotentialTopologyChange: difference: {}, oldView={}, newView={}", new Object[]{difference, oldView, newView});
        }
        logger.info("handlePotentialTopologyChange: sending " + TopologyEvent.Type.TOPOLOGY_CHANGING + " to all listeners (that have not gotten one yet) (oldView={}).", (Object)oldView);
        oldView.markOld();
        for (TopologyEventListener da : this.eventListeners) {
            this.enqueueAsyncTopologyEvent(da, new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGING, (TopologyView)oldView, null));
        }
        int minEventDelay = this.config.getMinEventDelay();
        if (!newView.isCurrent() && minEventDelay <= 0) {
            minEventDelay = 1;
        }
        if (minEventDelay <= 0) {
            this.enqueueForAll(TopologyEvent.Type.TOPOLOGY_CHANGED, oldView, newView);
            return;
        }
        logger.debug("handlePotentialTopologyChange: delaying event sending to avoid event flooding");
        if (this.runAfter(minEventDelay, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug("handlePotentialTopologyChange: acquiring synchronized(lock)...");
                Object object = DiscoveryServiceImpl.this.lock;
                synchronized (object) {
                    logger.debug("handlePotentialTopologyChange: sending delayed event now");
                    if (!DiscoveryServiceImpl.this.activated) {
                        DiscoveryServiceImpl.this.delayedEventPending = false;
                        DiscoveryServiceImpl.this.delayedEventPendingFailed = false;
                        logger.debug("handlePotentialTopologyChange: no longer activated. not sending delayed event");
                        return;
                    }
                    TopologyViewImpl newView = (TopologyViewImpl)DiscoveryServiceImpl.this.getTopology();
                    if (!newView.isCurrent()) {
                        if (DiscoveryServiceImpl.this.runAfter(1, this)) {
                            logger.warn("handlePotentialTopologyChange: local instance is isolated from topology. Waiting for rejoining...");
                            return;
                        }
                        DiscoveryServiceImpl.this.delayedEventPendingFailed = true;
                        logger.warn("handlePotentialTopologyChange: local instance is isolated from topology but failed to trigger delay-job");
                        return;
                    }
                    DiscoveryServiceImpl.this.enqueueForAll(TopologyEvent.Type.TOPOLOGY_CHANGED, DiscoveryServiceImpl.this.oldView, newView);
                    DiscoveryServiceImpl.this.delayedEventPending = false;
                    DiscoveryServiceImpl.this.delayedEventPendingFailed = false;
                }
            }
        })) {
            this.delayedEventPending = true;
            this.delayedEventPendingFailed = false;
            logger.debug("handlePotentialTopologyChange: delayed event triggering.");
            return;
        }
        logger.debug("handlePotentialTopologyChange: delaying event triggering did not work for some reason. Will be retriggered lazily via later heartbeat.");
        this.delayedEventPending = true;
        this.delayedEventPendingFailed = true;
    }

    private void enqueueForAll(TopologyEvent.Type eventType, TopologyViewImpl oldView, TopologyViewImpl newView) {
        if (oldView != null) {
            oldView.markOld();
        }
        logger.info("enqueueForAll: sending " + eventType + " to all listeners (oldView={}, newView={}).", (Object)oldView, (Object)newView);
        for (TopologyEventListener da : this.eventListeners) {
            this.enqueueAsyncTopologyEvent(da, new TopologyEvent(eventType, (TopologyView)oldView, (TopologyView)newView));
        }
        if (eventType != TopologyEvent.Type.TOPOLOGY_CHANGING) {
            this.setOldView(newView);
        }
        if (this.heartbeatHandler != null) {
            this.heartbeatHandler.triggerHeartbeat();
        }
    }

    private boolean runAfter(int seconds, Runnable runnable) {
        Scheduler theScheduler = this.scheduler;
        if (theScheduler == null) {
            logger.info("runAfter: no scheduler set");
            return false;
        }
        logger.debug("runAfter: trying with scheduler.fireJob");
        Date date = new Date(System.currentTimeMillis() + (long)(seconds * 1000));
        try {
            theScheduler.fireJobAt(null, (Object)runnable, null, date);
            return true;
        }
        catch (Exception e) {
            logger.info("runAfter: could not schedule a job: " + e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTopologyChanged() {
        logger.debug("handleTopologyChanged: calling handlePotentialTopologyChange.");
        Object object = this.lock;
        synchronized (object) {
            this.handlePotentialTopologyChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forcedShutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.activated) {
                logger.error("forcedShutdown: ignoring forced shutdown. Service is not activated.");
                return;
            }
            if (this.oldView == null) {
                logger.error("forcedShutdown: ignoring forced shutdown. No oldView available.");
                return;
            }
            logger.error("forcedShutdown: sending TOPOLOGY_CHANGING to all listeners");
            this.oldView.markOld();
            for (TopologyEventListener da : this.eventListeners) {
                this.enqueueAsyncTopologyEvent(da, new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGING, (TopologyView)this.oldView, null));
            }
            logger.error("forcedShutdown: deactivating DiscoveryService.");
            this.activated = false;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindHeartbeatHandler(HeartbeatHandler heartbeatHandler) {
        this.heartbeatHandler = heartbeatHandler;
    }

    protected void unbindHeartbeatHandler(HeartbeatHandler heartbeatHandler) {
        if (this.heartbeatHandler == heartbeatHandler) {
            this.heartbeatHandler = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }

    protected void bindClusterViewService(ClusterViewService clusterViewService) {
        this.clusterViewService = clusterViewService;
    }

    protected void unbindClusterViewService(ClusterViewService clusterViewService) {
        if (this.clusterViewService == clusterViewService) {
            this.clusterViewService = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    private static final class ProviderInfo
    implements Comparable<ProviderInfo> {
        public final PropertyProvider provider;
        public final Object propertyProperties;
        public final int ranking;
        public final long serviceId;
        public final Map<String, String> properties = new HashMap<String, String>();

        public ProviderInfo(PropertyProvider provider, Map<String, Object> serviceProps) {
            this.provider = provider;
            this.propertyProperties = serviceProps.get("instance.properties");
            Object sr = serviceProps.get("service.ranking");
            this.ranking = sr == null || !(sr instanceof Integer) ? 0 : (Integer)sr;
            this.serviceId = (Long)serviceProps.get("service.id");
            this.refreshProperties();
        }

        public void refreshProperties() {
            this.properties.clear();
            if (this.propertyProperties instanceof String) {
                String val = this.provider.getProperty((String)this.propertyProperties);
                if (val != null) {
                    this.putPropertyIfValid((String)this.propertyProperties, val);
                }
            } else if (this.propertyProperties instanceof String[]) {
                for (String name : (String[])this.propertyProperties) {
                    String val = this.provider.getProperty(name);
                    if (val == null) continue;
                    this.putPropertyIfValid(name, val);
                }
            }
        }

        private void putPropertyIfValid(String name, String val) {
            if (ResourceHelper.isValidPropertyName(name)) {
                this.properties.put(name, val);
            }
        }

        @Override
        public int compareTo(ProviderInfo o) {
            if (this.ranking < o.ranking) {
                return -1;
            }
            if (this.ranking > o.ranking) {
                return 1;
            }
            return this.serviceId < o.serviceId ? 1 : -1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProviderInfo) {
                return ((ProviderInfo)obj).serviceId == this.serviceId;
            }
            return false;
        }

        public int hashCode() {
            return this.provider.hashCode();
        }
    }

    private static final class AsyncEventSender
    implements Runnable {
        private boolean stopped = false;
        private final List<AsyncEvent> eventQ = new LinkedList<AsyncEvent>();

        private AsyncEventSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(TopologyEventListener listener, TopologyEvent event) {
            AsyncEvent asyncEvent = new AsyncEvent(listener, event);
            List<AsyncEvent> list = this.eventQ;
            synchronized (list) {
                this.eventQ.add(asyncEvent);
                if (logger.isDebugEnabled()) {
                    logger.debug("enqueue: enqueued event {} for async sending (Q size: {})", (Object)asyncEvent, (Object)this.eventQ.size());
                }
                this.eventQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushThenStop() {
            List<AsyncEvent> list = this.eventQ;
            synchronized (list) {
                logger.info("AsyncEventSender.flushThenStop: flushing (size: {}) & stopping...", (Object)this.eventQ.size());
                this.stopped = true;
                this.eventQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            DiscoveryServiceImpl.access$000().info("AsyncEventSender.run: started.");
            while (true) {
                block15: {
                    var2_3 = this.eventQ;
                    // MONITORENTER : var2_3
                    while (!this.stopped && this.eventQ.isEmpty()) {
                        try {
                            this.eventQ.wait();
                        }
                        catch (InterruptedException e) {
                            DiscoveryServiceImpl.access$000().debug("AsyncEventSender.run: interrupted while waiting for async events");
                        }
                    }
                    if (!this.stopped) ** GOTO lbl23
                    if (!this.eventQ.isEmpty()) break block15;
                    DiscoveryServiceImpl.access$000().info("AsyncEventSender.run: flush finished. stopped.");
                    // MONITOREXIT : var2_3
                    DiscoveryServiceImpl.access$000().info("AsyncEventSender.run: quits (finally).");
                    return;
                }
                try {
                    DiscoveryServiceImpl.access$000().info("AsyncEventSender.run: flushing another event. (pending {})", (Object)this.eventQ.size());
lbl23:
                    // 2 sources

                    asyncEvent = this.eventQ.remove(0);
                    if (DiscoveryServiceImpl.access$000().isDebugEnabled()) {
                        DiscoveryServiceImpl.access$000().debug("AsyncEventSender.run: dequeued event {}, remaining: {}", (Object)asyncEvent, (Object)this.eventQ.size());
                    }
                    // MONITOREXIT : var2_3
                    if (asyncEvent == null) continue;
                    this.sendTopologyEvent(asyncEvent);
                }
                catch (Throwable th) {
                    DiscoveryServiceImpl.access$000().error("AsyncEventSender.run: Throwable occurred. Sleeping 5sec. Throwable: " + th, th);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        DiscoveryServiceImpl.access$000().warn("AsyncEventSender.run: interrupted while sleeping");
                    }
                }
                continue;
                break;
            }
            catch (Throwable var5_6) {
                DiscoveryServiceImpl.access$000().info("AsyncEventSender.run: quits (finally).");
                throw var5_6;
            }
        }

        private void sendTopologyEvent(AsyncEvent asyncEvent) {
            TopologyEventListener listener = asyncEvent.listener;
            TopologyEvent event = asyncEvent.event;
            logger.debug("sendTopologyEvent: start: listener: {}, event: {}", (Object)listener, (Object)event);
            try {
                listener.handleTopologyEvent(event);
            }
            catch (Exception e) {
                logger.warn("sendTopologyEvent: handler threw exception. handler: " + listener + ", exception: " + e, (Throwable)e);
            }
            logger.debug("sendTopologyEvent: start: listener: {}, event: {}", (Object)listener, (Object)event);
        }
    }

    private static final class AsyncEvent {
        private final TopologyEventListener listener;
        private final TopologyEvent event;

        AsyncEvent(TopologyEventListener listener, TopologyEvent event) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            if (event == null) {
                throw new IllegalArgumentException("event must not be null");
            }
            this.listener = listener;
            this.event = event;
        }

        public String toString() {
            return "an AsyncEvent[event=" + this.event + ", listener=" + this.listener + "]";
        }
    }
}

