/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster;

import java.util.Collection;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.cluster.UndefinedClusterViewException;
import org.apache.sling.discovery.impl.common.View;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.apache.sling.discovery.impl.common.resource.EstablishedClusterView;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ClusterViewService.class})
public class ClusterViewServiceImpl
implements ClusterViewService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Config config;

    @Override
    public String getSlingId() {
        if (this.settingsService == null) {
            return null;
        }
        return this.settingsService.getSlingId();
    }

    @Override
    public boolean contains(String slingId) throws UndefinedClusterViewException {
        List localInstances = this.getClusterView().getInstances();
        for (InstanceDescription aLocalInstance : localInstances) {
            if (!aLocalInstance.getSlingId().equals(slingId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(Collection<InstanceDescription> listInstances) throws UndefinedClusterViewException {
        for (InstanceDescription instanceDescription : listInstances) {
            if (!this.contains(instanceDescription.getSlingId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClusterView getClusterView() throws UndefinedClusterViewException {
        if (this.resourceResolverFactory == null) {
            this.logger.warn("getClusterView: no resourceResolverFactory set at the moment.");
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "no resourceResolverFactory set");
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            View view = ViewHelper.getEstablishedView(resourceResolver, this.config);
            if (view == null) {
                this.logger.debug("getClusterView: no view established at the moment. isolated mode");
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "no established view at the moment");
            }
            EstablishedClusterView clusterViewImpl = new EstablishedClusterView(this.config, view, this.getSlingId());
            boolean foundLocal = false;
            for (InstanceDescription instance : clusterViewImpl.getInstances()) {
                if (!instance.isLocal()) continue;
                foundLocal = true;
                break;
            }
            if (foundLocal) {
                EstablishedClusterView establishedClusterView = clusterViewImpl;
                return establishedClusterView;
            }
            try {
                this.logger.info("getClusterView: the local instance (" + this.getSlingId() + ") is currently not included in the existing established view! " + "This is normal at startup, but indicates a pseudo-network-partitioning (SLING-3432) at other times, " + "in which case increasing the heartbeatTimeout can help, but more importantly the repository-delays/network/clocks must be analyzed. " + "The local instance will stay in TOPOLOGY_CHANGING or pre _INIT mode until a new vote was successful.");
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.ISOLATED_FROM_TOPOLOGY, "established view does not include local instance - isolated");
            }
            catch (LoginException e) {
                this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "could not log in administratively: " + (Object)((Object)e));
            }
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

