/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.impl.common.DefaultClusterViewImpl;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;

public class DefaultInstanceDescriptionImpl
implements InstanceDescription {
    private ClusterView clusterView;
    private boolean isLeader;
    private boolean isLocal;
    private String slingId;
    private Map<String, String> properties;

    public DefaultInstanceDescriptionImpl(DefaultClusterViewImpl clusterView, boolean isLeader, boolean isOwn, String slingId, Map<String, String> properties) {
        if (slingId == null || slingId.length() == 0) {
            throw new IllegalArgumentException("slingId must not be null");
        }
        this.isLeader = isLeader;
        this.isLocal = isOwn;
        this.slingId = slingId;
        this.properties = this.filterValidProperties(properties);
        if (clusterView != null) {
            clusterView.addInstanceDescription(this);
            if (this.clusterView == null) {
                throw new IllegalStateException("clusterView should have been set by now");
            }
        }
    }

    public String toString() {
        String clusterInfo = this.clusterView == null ? "" : ", clusterViewId=" + this.clusterView.getId();
        return "an InstanceDescription[slindId=" + this.slingId + ", isLeader=" + this.isLeader + ", isOwn=" + this.isLocal + clusterInfo + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        return this.slingId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DefaultInstanceDescriptionImpl)) {
            return false;
        }
        DefaultInstanceDescriptionImpl other = (DefaultInstanceDescriptionImpl)obj;
        if (!this.slingId.equals(other.slingId)) {
            return false;
        }
        if (!this.slingId.equals(other.slingId)) {
            return false;
        }
        if (!this.properties.equals(other.properties)) {
            return false;
        }
        return this.getClusterView().getId().equals(other.getClusterView().getId());
    }

    public ClusterView getClusterView() {
        if (this.clusterView == null) {
            throw new IllegalStateException("clusterView was never set");
        }
        return this.clusterView;
    }

    protected void setClusterView(ClusterView clusterView) {
        if (this.clusterView != null) {
            throw new IllegalStateException("can only set clusterView once");
        }
        if (clusterView == null) {
            throw new IllegalArgumentException("clusterView must not be null");
        }
        this.clusterView = clusterView;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getSlingId() {
        return this.slingId;
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            throw new IllegalStateException("properties were never set");
        }
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            throw new IllegalStateException("properties were never set");
        }
        return Collections.unmodifiableMap(this.properties);
    }

    protected void setProperties(Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        this.properties = this.filterValidProperties(properties);
    }

    private Map<String, String> filterValidProperties(Map<String, String> rawProps) {
        if (rawProps == null) {
            return null;
        }
        HashMap<String, String> filteredProps = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entries = rawProps.entrySet();
        for (Map.Entry<String, String> anEntry : entries) {
            if (!ResourceHelper.isValidPropertyName(anEntry.getKey())) continue;
            filteredProps.put(anEntry.getKey(), anEntry.getValue());
        }
        return filteredProps;
    }
}

