/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class View {
    protected static final String VIEW_PROPERTY_CLUSTER_ID = "clusterId";
    protected static final String VIEW_PROPERTY_CLUSTER_ID_DEFINED_AT = "clusterIdDefinedAt";
    protected static final String VIEW_PROPERTY_CLUSTER_ID_DEFINED_BY = "clusterIdDefinedBy";
    private static final Logger logger = LoggerFactory.getLogger(View.class);
    private final Resource resource;

    public View(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof View)) {
            return false;
        }
        View other = (View)obj;
        return this.getResource().getPath().equals(other.getResource().getPath());
    }

    public int hashCode() {
        return this.getResource().getPath().hashCode();
    }

    public String getViewId() {
        ValueMap props = (ValueMap)this.getResource().adaptTo(ValueMap.class);
        if (props == null) {
            logger.warn("getViewId: could not get properties of " + this.getResource().getPath() + ", using resource name instead: " + this.getResource().getName());
            return this.getResource().getName();
        }
        String clusterId = (String)props.get(VIEW_PROPERTY_CLUSTER_ID, String.class);
        if (clusterId != null && clusterId.length() > 0) {
            return clusterId;
        }
        return this.getResource().getName();
    }

    public boolean matchesLiveView(Resource clusterInstancesRes, Config config) {
        return this.matches(ViewHelper.determineLiveInstances(clusterInstancesRes, config));
    }

    public boolean matches(Set<String> view) {
        HashSet<String> viewCopy = new HashSet<String>(view);
        Resource members = this.getResource().getChild("members");
        if (members == null) {
            return false;
        }
        try {
            for (Resource aMemberRes : members.getChildren()) {
                if (viewCopy.remove(aMemberRes.getName())) continue;
                return false;
            }
        }
        catch (RuntimeException re) {
            logger.info("matches: cannot compare due to " + re);
            return false;
        }
        return viewCopy.size() == 0;
    }

    public void remove(boolean logErrorOnFailure) {
        ResourceResolver resourceResolver = this.getResource().getResourceResolver();
        try {
            resourceResolver.delete(this.getResource());
            resourceResolver.commit();
        }
        catch (PersistenceException pe) {
            if (logErrorOnFailure) {
                logger.error("remove: Could not remove node: " + (Object)((Object)pe), (Throwable)pe);
            } else {
                logger.info("remove: Could not remove node: " + (Object)((Object)pe));
            }
            resourceResolver.refresh();
        }
    }
}

