/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common.heartbeat;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.DiscoveryServiceImpl;
import org.apache.sling.discovery.impl.cluster.voting.VotingHandler;
import org.apache.sling.discovery.impl.cluster.voting.VotingHelper;
import org.apache.sling.discovery.impl.cluster.voting.VotingView;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.apache.sling.discovery.impl.common.resource.ResourceHelper;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.ConnectorRegistry;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={HeartbeatHandler.class, StartupListener.class})
@Reference(referenceInterface=HttpService.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class HeartbeatHandler
implements Runnable,
StartupListener {
    private static final String PROPERTY_ID_LAST_HEARTBEAT = "lastHeartbeat";
    private static final String PROPERTY_ID_ENDPOINTS = "endpoints";
    private static final String PROPERTY_ID_SLING_HOME_PATH = "slingHomePath";
    private static final String PROPERTY_ID_RUNTIME = "runtimeId";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REG_PROPERTY_ENDPOINTS = "osgi.http.service.endpoints";
    private String NAME = "discovery.impl.heartbeat.runner.";
    @Reference
    private SlingSettingsService slingSettingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ConnectorRegistry connectorRegistry;
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private Scheduler scheduler;
    @Reference
    private Config config;
    @Reference
    private VotingHandler votingHandler;
    private DiscoveryServiceImpl discoveryService;
    private String slingId;
    private String nextVotingId = UUID.randomUUID().toString();
    private volatile boolean resetLeaderElectionId = false;
    private volatile String newLeaderElectionId;
    private final Object lock = new Object();
    private long firstHeartbeatWritten = -1L;
    private Calendar lastHeartbeatWritten = null;
    private volatile boolean activated = false;
    private String runtimeId;
    private ComponentContext context;
    private boolean startupFinished = false;
    private boolean forcePing;
    private final Map<Long, String[]> endpoints = new HashMap<Long, String[]>();

    public void inform(StartupMode mode, boolean finished) {
        if (finished) {
            this.startupFinished(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startupFinished(StartupMode mode) {
        Object object = this.lock;
        synchronized (object) {
            this.startupFinished = true;
            this.issueHeartbeat();
        }
    }

    public void startupProgress(float ratio) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) {
        Object object = this.lock;
        synchronized (object) {
            this.context = context;
            this.slingId = this.slingSettingsService.getSlingId();
            this.NAME = "discovery.impl.heartbeat.runner." + this.slingId;
            this.resetLeaderElectionId = true;
            this.runtimeId = UUID.randomUUID().toString();
            this.firstHeartbeatWritten = -1L;
            this.lastHeartbeatWritten = null;
            this.activated = true;
            this.logger.info("activate: activated with runtimeId: {}, slingId: {}", (Object)this.runtimeId, (Object)this.slingId);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.activated = false;
        this.scheduler.removeJob(this.NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DiscoveryServiceImpl discoveryService, String initialVotingId) {
        Object object = this.lock;
        synchronized (object) {
            this.discoveryService = discoveryService;
            this.nextVotingId = initialVotingId;
            this.logger.info("initialize: nextVotingId=" + this.nextVotingId);
            this.issueHeartbeat();
        }
        try {
            long interval = this.config.getHeartbeatInterval();
            this.logger.info("initialize: starting periodic heartbeat job for " + this.slingId + " with interval " + interval + " sec.");
            this.scheduler.addPeriodicJob(this.NAME, (Object)this, null, interval, false);
        }
        catch (Exception e) {
            this.logger.error("activate: Could not start heartbeat runner: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.activated) {
                return;
            }
            this.issueHeartbeat();
            this.checkView();
        }
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        if (this.resourceResolverFactory == null) {
            this.logger.error("getResourceResolver: resourceResolverFactory is null!");
            return null;
        }
        return this.resourceResolverFactory.getAdministrativeResourceResolver(null);
    }

    private String getLocalClusterNodePath() {
        return this.config.getClusterInstancesPath() + "/" + this.slingId;
    }

    public void triggerHeartbeat() {
        this.forcePing = true;
        try {
            this.scheduler.fireJobAt(this.NAME + UUID.randomUUID(), (Object)this, null, new Date(System.currentTimeMillis() - 1000L));
        }
        catch (Exception e) {
            this.logger.info("triggerHeartbeat: Could not trigger heartbeat: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetLeaderElectionId() {
        if (this.resetLeaderElectionId) {
            return false;
        }
        this.resetLeaderElectionId = true;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            if (resourceResolver != null) {
                this.newLeaderElectionId = this.newLeaderElectionId(resourceResolver);
                if (this.votingHandler != null) {
                    this.logger.info("resetLeaderElectionId: set new leaderElectionId with votingHandler to: " + this.newLeaderElectionId);
                    this.votingHandler.setLeaderElectionId(this.newLeaderElectionId);
                } else {
                    this.logger.info("resetLeaderElectionId: no votingHandler, new leaderElectionId would be: " + this.newLeaderElectionId);
                }
            } else {
                this.logger.warn("resetLeaderElectionId: could not login, new leaderElectionId will be calculated upon next heartbeat only!");
            }
        }
        catch (LoginException e) {
            this.logger.error("resetLeaderElectionid: could not login: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return true;
    }

    void issueHeartbeat() {
        if (this.discoveryService == null) {
            this.logger.error("issueHeartbeat: discoveryService is null");
        } else {
            this.discoveryService.updateProperties();
        }
        this.issueClusterLocalHeartbeat();
        this.issueRemoteHeartbeats();
    }

    private void issueRemoteHeartbeats() {
        if (this.connectorRegistry == null) {
            this.logger.error("issueRemoteHeartbeats: connectorRegistry is null");
            return;
        }
        if (!this.startupFinished) {
            this.logger.debug("issueRemoteHeartbeats: not issuing remote heartbeat yet, startup not yet finished");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("issueRemoteHeartbeats: pinging outgoing topology connectors (if there is any) for " + this.slingId);
        }
        this.connectorRegistry.pingOutgoingConnectors(this.forcePing);
        this.forcePing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void issueClusterLocalHeartbeat() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("issueClusterLocalHeartbeat: storing cluster-local heartbeat to repository for " + this.slingId);
        }
        ResourceResolver resourceResolver = null;
        String myClusterNodePath = this.getLocalClusterNodePath();
        Calendar currentTime = Calendar.getInstance();
        try {
            resourceResolver = this.getResourceResolver();
            if (resourceResolver == null) {
                this.logger.error("issueClusterLocalHeartbeat: no resourceresolver available!");
                return;
            }
            Resource resource = ResourceHelper.getOrCreateResource(resourceResolver, myClusterNodePath);
            ModifiableValueMap resourceMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            if (this.firstHeartbeatWritten != -1L && this.lastHeartbeatWritten != null) {
                String readRuntimeId;
                Calendar lastHeartbeat;
                long timeSinceFirstHeartbeat = System.currentTimeMillis() - this.firstHeartbeatWritten;
                if (timeSinceFirstHeartbeat > 2L * this.config.getHeartbeatInterval() && (lastHeartbeat = (Calendar)resourceMap.get(PROPERTY_ID_LAST_HEARTBEAT, Calendar.class)) != null && !this.lastHeartbeatWritten.getTime().equals(lastHeartbeat.getTime())) {
                    this.logger.error("issueClusterLocalHeartbeat: SLING-2892: Detected unexpected, concurrent update of: " + myClusterNodePath + " 'lastHeartbeat'. If not done manually, " + "this likely indicates that there is more than 1 instance running in this cluster" + " with the same sling.id. My sling.id is " + this.slingId + "." + " Check for sling.id.file in your installation of all instances in this cluster " + "to verify this! Duplicate sling.ids are not allowed within a cluster!");
                }
                if ((readRuntimeId = (String)resourceMap.get(PROPERTY_ID_RUNTIME, String.class)) == null) {
                    this.firstHeartbeatWritten = -1L;
                } else if (!this.runtimeId.equals(readRuntimeId)) {
                    String slingHomePath = this.slingSettingsService == null ? "n/a" : this.slingSettingsService.getSlingHomePath();
                    String endpointsAsString = this.getEndpointsAsString();
                    String readEndpoints = (String)resourceMap.get(PROPERTY_ID_ENDPOINTS, String.class);
                    String readSlingHomePath = (String)resourceMap.get(PROPERTY_ID_SLING_HOME_PATH, String.class);
                    this.logger.error("issueClusterLocalHeartbeat: SLING-2901: Detected more than 1 instance running in this cluster  with the same sling.id. My sling.id: " + this.slingId + ", my runtimeId: " + this.runtimeId + ", my endpoints: " + endpointsAsString + ", my slingHomePath: " + slingHomePath + ", other runtimeId: " + readRuntimeId + ", other endpoints: " + readEndpoints + ", other slingHomePath:" + readSlingHomePath + " Check for sling.id.file in your installation of all instances in this cluster " + "to verify this! Duplicate sling.ids are not allowed within a cluster!");
                    this.logger.error("issueClusterLocalHeartbeat: sending TOPOLOGY_CHANGING before self-disabling.");
                    this.discoveryService.forcedShutdown();
                    this.logger.error("issueClusterLocalHeartbeat: disabling discovery.impl");
                    this.activated = false;
                    if (this.context != null) {
                        try {
                            this.context.getBundleContext().getBundle().stop();
                        }
                        catch (BundleException e) {
                            this.logger.warn("issueClusterLocalHeartbeat: could not stop bundle: " + (Object)((Object)e), (Throwable)e);
                            this.context.disableComponent(null);
                        }
                    }
                    return;
                }
            }
            resourceMap.put((Object)PROPERTY_ID_LAST_HEARTBEAT, (Object)currentTime);
            if (this.firstHeartbeatWritten == -1L) {
                resourceMap.put((Object)PROPERTY_ID_RUNTIME, (Object)this.runtimeId);
                String slingHomePath = this.slingSettingsService == null ? "n/a" : this.slingSettingsService.getSlingHomePath();
                resourceMap.put((Object)PROPERTY_ID_SLING_HOME_PATH, (Object)slingHomePath);
                String endpointsAsString = this.getEndpointsAsString();
                resourceMap.put((Object)PROPERTY_ID_ENDPOINTS, (Object)endpointsAsString);
                this.logger.info("issueClusterLocalHeartbeat: storing my runtimeId: {}, endpoints: {} and sling home path: {}", new Object[]{this.runtimeId, endpointsAsString, slingHomePath});
            }
            if (this.resetLeaderElectionId || !resourceMap.containsKey((Object)"leaderElectionId")) {
                String newLeaderElectionId = this.newLeaderElectionId != null ? this.newLeaderElectionId : this.newLeaderElectionId(resourceResolver);
                this.newLeaderElectionId = null;
                resourceMap.put((Object)"leaderElectionId", (Object)newLeaderElectionId);
                resourceMap.put((Object)"leaderElectionIdCreatedAt", (Object)new Date());
                this.logger.info("issueClusterLocalHeartbeat: set leaderElectionId to " + newLeaderElectionId);
                if (this.votingHandler != null) {
                    this.votingHandler.setLeaderElectionId(newLeaderElectionId);
                }
                this.resetLeaderElectionId = false;
            }
            resourceResolver.commit();
            this.lastHeartbeatWritten = currentTime;
            if (this.firstHeartbeatWritten == -1L) {
                this.firstHeartbeatWritten = System.currentTimeMillis();
            }
        }
        catch (LoginException e) {
            this.logger.error("issueHeartbeat: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("issueHeartbeat: Got a PersistenceException: " + myClusterNodePath + " " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private String newLeaderElectionId(ResourceResolver resourceResolver) {
        String value;
        Session session;
        int maxLongLength = String.valueOf(Long.MAX_VALUE).length();
        String currentTimeMillisStr = String.format("%0" + maxLongLength + "d", System.currentTimeMillis());
        boolean shouldInvertRepositoryDescriptor = this.config.shouldInvertRepositoryDescriptor();
        String prefix = shouldInvertRepositoryDescriptor ? "1" : "0";
        String leaderElectionRepositoryDescriptor = this.config.getLeaderElectionRepositoryDescriptor();
        if (leaderElectionRepositoryDescriptor != null && leaderElectionRepositoryDescriptor.length() != 0 && (session = (Session)resourceResolver.adaptTo(Session.class)) != null && (value = session.getRepository().getDescriptor(leaderElectionRepositoryDescriptor)) != null && value.equalsIgnoreCase("true")) {
            prefix = !shouldInvertRepositoryDescriptor ? "1" : "0";
        }
        String newLeaderElectionId = prefix + "_" + currentTimeMillisStr + "_" + this.slingId;
        return newLeaderElectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkView() {
        if (this.announcementRegistry == null) {
            this.logger.error("announcementRegistry is null");
            return;
        }
        this.announcementRegistry.checkExpiredAnnouncements();
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            this.doCheckView(resourceResolver);
        }
        catch (LoginException e) {
            this.logger.error("checkView: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("checkView: encountered a persistence exception during view check: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private void doCheckView(ResourceResolver resourceResolver) throws PersistenceException {
        if (this.votingHandler == null) {
            this.logger.info("doCheckView: votingHandler is null! slingId=" + this.slingId);
        } else {
            this.votingHandler.analyzeVotings(resourceResolver);
            try {
                this.votingHandler.cleanupTimedoutVotings(resourceResolver);
            }
            catch (Exception e) {
                this.logger.warn("doCheckView: Exception occurred while cleaning up votings: " + e, (Throwable)e);
            }
        }
        VotingView winningVoting = VotingHelper.getWinningVoting(resourceResolver, this.config);
        int numOpenNonWinningVotes = VotingHelper.listOpenNonWinningVotings(resourceResolver, this.config).size();
        if (winningVoting != null || numOpenNonWinningVotes > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("doCheckView: " + numOpenNonWinningVotes + " ongoing votings, no one winning yet - I shall wait for them to settle.");
            }
            return;
        }
        Resource clusterNodesRes = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath());
        Set<String> liveInstances = ViewHelper.determineLiveInstances(clusterNodesRes, this.config);
        if (ViewHelper.establishedViewMatches(resourceResolver, this.config, liveInstances)) {
            this.logger.debug("doCheckView: no pending nor winning votes. view is fine. we're all happy.");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("doCheckView: no pending nor winning votes. But: view does not match established or no established yet. Initiating a new voting");
            Iterator<String> it = liveInstances.iterator();
            while (it.hasNext()) {
                this.logger.debug("doCheckView: one of the live instances is: " + it.next());
            }
        }
        this.doStartNewVoting(resourceResolver, liveInstances);
    }

    private void doStartNewVoting(ResourceResolver resourceResolver, Set<String> liveInstances) throws PersistenceException {
        String votingId = this.nextVotingId;
        this.nextVotingId = UUID.randomUUID().toString();
        VotingView.newVoting(resourceResolver, this.config, votingId, this.slingId, liveInstances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewVoting() {
        this.logger.info("startNewVoting: explicitly starting new voting...");
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            Resource clusterNodesRes = ResourceHelper.getOrCreateResource(resourceResolver, this.config.getClusterInstancesPath());
            Set<String> liveInstances = ViewHelper.determineLiveInstances(clusterNodesRes, this.config);
            this.doStartNewVoting(resourceResolver, liveInstances);
            this.logger.info("startNewVoting: explicit new voting was started.");
        }
        catch (LoginException e) {
            this.logger.error("startNewVoting: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("startNewVoting: encountered a persistence exception during view check: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindHttpService(ServiceReference reference) {
        String[] endpointUrls = this.toStringArray(reference.getProperty(REG_PROPERTY_ENDPOINTS));
        if (endpointUrls != null) {
            Object object = this.lock;
            synchronized (object) {
                this.endpoints.put((Long)reference.getProperty("service.id"), endpointUrls);
                this.firstHeartbeatWritten = -1L;
                this.lastHeartbeatWritten = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindHttpService(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpoints.remove(reference.getProperty("service.id")) != null) {
                this.firstHeartbeatWritten = -1L;
                this.lastHeartbeatWritten = null;
            }
        }
    }

    private String[] toStringArray(Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue instanceof String) {
            return new String[]{(String)propValue};
        }
        if (propValue instanceof String[]) {
            return (String[])propValue;
        }
        if (propValue.getClass().isArray()) {
            Object[] valueArray = (Object[])propValue;
            ArrayList<String> values = new ArrayList<String>(valueArray.length);
            for (Object value : valueArray) {
                if (value == null) continue;
                values.add(value.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (propValue instanceof Collection) {
            Collection valueCollection = (Collection)propValue;
            ArrayList<String> valueList = new ArrayList<String>(valueCollection.size());
            for (Object value : valueCollection) {
                if (value == null) continue;
                valueList.add(value.toString());
            }
            return valueList.toArray(new String[valueList.size()]);
        }
        return null;
    }

    private String getEndpointsAsString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String[] points : this.endpoints.values()) {
            for (String point : points) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(point);
            }
        }
        return sb.toString();
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    protected void bindVotingHandler(VotingHandler votingHandler) {
        this.votingHandler = votingHandler;
    }

    protected void unbindVotingHandler(VotingHandler votingHandler) {
        if (this.votingHandler == votingHandler) {
            this.votingHandler = null;
        }
    }
}

