/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.connector;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.ClusterViewService;
import org.apache.sling.discovery.impl.topology.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.impl.topology.connector.ConnectorRegistry;
import org.apache.sling.discovery.impl.topology.connector.TopologyConnectorClient;
import org.apache.sling.discovery.impl.topology.connector.TopologyConnectorClientInformation;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ConnectorRegistry.class})
public class ConnectorRegistryImpl
implements ConnectorRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, TopologyConnectorClient> outgoingClientsMap = new HashMap<String, TopologyConnectorClient>();
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private Config config;
    private String port = "";

    @Activate
    protected void activate(ComponentContext cc) {
        this.port = cc.getBundleContext().getProperty("org.osgi.service.http.port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        Map<String, TopologyConnectorClient> map = this.outgoingClientsMap;
        synchronized (map) {
            Iterator<TopologyConnectorClient> it = this.outgoingClientsMap.values().iterator();
            while (it.hasNext()) {
                TopologyConnectorClient client = it.next();
                client.disconnect();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopologyConnectorClientInformation registerOutgoingConnector(ClusterViewService clusterViewService, URL connectorUrl) {
        TopologyConnectorClient client;
        if (this.announcementRegistry == null) {
            this.logger.error("registerOutgoingConnection: announcementRegistry is null");
            return null;
        }
        Map<String, TopologyConnectorClient> map = this.outgoingClientsMap;
        synchronized (map) {
            String serverInfo;
            Iterator<Map.Entry<String, TopologyConnectorClient>> it = this.outgoingClientsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, TopologyConnectorClient> entry = it.next();
                if (!entry.getValue().getConnectorUrl().toExternalForm().equals(connectorUrl.toExternalForm())) continue;
                it.remove();
                this.logger.info("registerOutgoingConnection: re-registering connector: " + connectorUrl);
            }
            try {
                serverInfo = InetAddress.getLocalHost().getCanonicalHostName() + ":" + this.port;
            }
            catch (Exception e) {
                serverInfo = "localhost:" + this.port;
            }
            client = new TopologyConnectorClient(clusterViewService, this.announcementRegistry, this.config, connectorUrl, serverInfo);
            this.outgoingClientsMap.put(client.getId(), client);
        }
        client.ping(false);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TopologyConnectorClientInformation> listOutgoingConnectors() {
        ArrayList<TopologyConnectorClientInformation> result = new ArrayList<TopologyConnectorClientInformation>();
        Map<String, TopologyConnectorClient> map = this.outgoingClientsMap;
        synchronized (map) {
            result.addAll(this.outgoingClientsMap.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregisterOutgoingConnector(String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("id must not be null");
        }
        Map<String, TopologyConnectorClient> map = this.outgoingClientsMap;
        synchronized (map) {
            TopologyConnectorClient client = this.outgoingClientsMap.remove(id);
            if (client != null) {
                client.disconnect();
            }
            return client != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pingOutgoingConnectors(boolean force) {
        ArrayList<TopologyConnectorClient> outgoingTemplatesClone;
        Map<String, TopologyConnectorClient> map = this.outgoingClientsMap;
        synchronized (map) {
            outgoingTemplatesClone = new ArrayList<TopologyConnectorClient>(this.outgoingClientsMap.values());
        }
        Iterator it = outgoingTemplatesClone.iterator();
        while (it.hasNext()) {
            ((TopologyConnectorClient)it.next()).ping(force);
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

