/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.topology.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.discovery.impl.Config;

public class TopologyRequestValidator {
    public static final String SIG_HEADER = "X-SlingTopologyTrust";
    public static final String HASH_HEADER = "X-SlingTopologyHash";
    private static final int MAXKEYS = 5;
    private static final int MINKEYS = 3;
    private boolean trustEnabled = false;
    private boolean encryptionEnabled = false;
    private Map<Integer, Key> keys = new ConcurrentHashMap<Integer, Key>();
    private String sharedKey;
    private long interval;
    private boolean deactivated;
    private SecureRandom random = new SecureRandom();

    public TopologyRequestValidator(Config config) {
        if (config.isHmacEnabled()) {
            this.trustEnabled = true;
            this.sharedKey = config.getSharedKey();
            this.interval = config.getKeyInterval();
            this.encryptionEnabled = config.isEncryptionEnabled();
        }
        this.deactivated = false;
    }

    public String encodeMessage(String body) throws IOException {
        this.checkActive();
        if (this.encryptionEnabled) {
            try {
                JSONObject json = new JSONObject();
                json.put("payload", (Object)new JSONArray(this.encrypt(body)));
                return json.toString();
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (BadPaddingException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (JSONException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
            catch (InvalidParameterSpecException e) {
                throw new IOException("Unable to Encrypt Message " + e.getMessage());
            }
        }
        return body;
    }

    public String decodeMessage(HttpServletRequest request) throws IOException {
        this.checkActive();
        return this.decodeMessage("request:", request.getRequestURI(), this.getRequestBody(request), request.getHeader(HASH_HEADER));
    }

    public String decodeMessage(String uri, HttpResponse response) throws IOException {
        this.checkActive();
        return this.decodeMessage("response:", uri, this.getResponseBody(response), this.getResponseHeader(response, HASH_HEADER));
    }

    private String decodeMessage(String prefix, String url, String body, String requestHash) throws IOException {
        if (this.trustEnabled) {
            String bodyHash = this.hash(prefix + url + ":" + body);
            if (bodyHash.equals(requestHash) && this.encryptionEnabled) {
                try {
                    JSONObject json = new JSONObject(body);
                    if (json.has("payload")) {
                        return this.decrypt(json.getJSONArray("payload"));
                    }
                }
                catch (JSONException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
                catch (InvalidKeyException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
                catch (IllegalBlockSizeException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
                catch (BadPaddingException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
                catch (NoSuchPaddingException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
                catch (InvalidKeySpecException e) {
                    throw new IOException("Encrypted Message is in the correct json format");
                }
            }
            throw new IOException("Message is not valid, hash does not match message");
        }
        return body;
    }

    public boolean isTrusted(HttpServletRequest request) {
        this.checkActive();
        if (this.trustEnabled) {
            return this.checkTrustHeader(request.getHeader(HASH_HEADER), request.getHeader(SIG_HEADER));
        }
        return false;
    }

    public boolean isTrusted(HttpResponse response) {
        this.checkActive();
        if (this.trustEnabled) {
            return this.checkTrustHeader(this.getResponseHeader(response, HASH_HEADER), this.getResponseHeader(response, SIG_HEADER));
        }
        return false;
    }

    public void trustMessage(HttpUriRequest method, String body) {
        this.checkActive();
        if (this.trustEnabled) {
            String bodyHash = this.hash("request:" + method.getURI().getPath() + ":" + body);
            method.setHeader(HASH_HEADER, bodyHash);
            method.setHeader(SIG_HEADER, this.createTrustHeader(bodyHash));
        }
    }

    public void trustMessage(HttpServletResponse response, HttpServletRequest request, String body) {
        this.checkActive();
        if (this.trustEnabled) {
            String bodyHash = this.hash("response:" + request.getRequestURI() + ":" + body);
            response.setHeader(HASH_HEADER, bodyHash);
            response.setHeader(SIG_HEADER, this.createTrustHeader(bodyHash));
        }
    }

    private String hash(String toHash) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA-256");
            return new String(Base64.encodeBase64((byte[])m.digest(toHash.getBytes("UTF-8"))), "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String createTrustHeader(String bodyHash) {
        try {
            int keyNo = this.getCurrentKey();
            return keyNo + "/" + this.hmac(keyNo, bodyHash);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean checkTrustHeader(String bodyHash, String signature) {
        try {
            if (bodyHash == null || signature == null) {
                return false;
            }
            String[] parts = signature.split("/", 2);
            int keyNo = Integer.parseInt(parts[0]);
            return this.hmac(keyNo, bodyHash).equals(parts[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Mac getMac(int keyNo) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        Mac m = Mac.getInstance("HmacSHA256");
        m.init(this.getKey(keyNo));
        return m;
    }

    private String hmac(int keyNo, String bodyHash) throws InvalidKeyException, UnsupportedEncodingException, IllegalStateException, NoSuchAlgorithmException {
        return new String(Base64.encodeBase64((byte[])this.getMac(keyNo).doFinal(bodyHash.getBytes("UTF-8"))), "UTF-8");
    }

    private String decrypt(JSONArray jsonArray) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException, JSONException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, this.getCiperKey(Base64.decodeBase64((byte[])jsonArray.getString(0).getBytes("UTF-8"))), new IvParameterSpec(Base64.decodeBase64((byte[])jsonArray.getString(1).getBytes("UTF-8"))));
        return new String(cipher.doFinal(Base64.decodeBase64((byte[])jsonArray.getString(2).getBytes("UTF-8"))));
    }

    private List<String> encrypt(String payload) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidParameterSpecException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] salt = new byte[9];
        this.random.nextBytes(salt);
        cipher.init(1, this.getCiperKey(salt));
        AlgorithmParameters params = cipher.getParameters();
        ArrayList<String> encrypted = new ArrayList<String>();
        encrypted.add(new String(Base64.encodeBase64((byte[])salt)));
        encrypted.add(new String(Base64.encodeBase64((byte[])params.getParameterSpec(IvParameterSpec.class).getIV())));
        encrypted.add(new String(Base64.encodeBase64((byte[])cipher.doFinal(payload.getBytes("UTF-8")))));
        return encrypted;
    }

    private Key getCiperKey(byte[] salt) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(this.sharedKey.toCharArray(), salt, 256, 128);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        return key;
    }

    private Key getKey(int keyNo) throws UnsupportedEncodingException {
        if (Math.abs(keyNo - this.getCurrentKey()) > 1) {
            throw new IllegalArgumentException("Key has expired");
        }
        if (this.keys.containsKey(keyNo)) {
            return this.keys.get(keyNo);
        }
        this.trimKeys();
        SecretKeySpec key = new SecretKeySpec(this.hash(this.sharedKey + keyNo).getBytes("UTF-8"), "HmacSHA256");
        this.keys.put(keyNo, key);
        return key;
    }

    private int getCurrentKey() {
        return (int)(System.currentTimeMillis() / this.interval);
    }

    private void trimKeys() {
        if (this.keys.size() > 5) {
            ArrayList<Integer> keysKeys = new ArrayList<Integer>(this.keys.keySet());
            Collections.sort(keysKeys);
            for (Integer k : keysKeys) {
                if (this.keys.size() < 3) break;
                this.keys.remove(k);
            }
        }
    }

    private String getResponseHeader(HttpResponse response, String name) {
        Header h = response.getFirstHeader(name);
        if (h == null) {
            return null;
        }
        return h.getValue();
    }

    private String getRequestBody(HttpServletRequest request) throws IOException {
        String contentEncoding = request.getHeader("Content-Encoding");
        if (contentEncoding != null && contentEncoding.contains("gzip")) {
            GZIPInputStream gzipIn = new GZIPInputStream((InputStream)request.getInputStream());
            String gunzippedEncodedJson = IOUtils.toString((InputStream)gzipIn);
            gzipIn.close();
            return gunzippedEncodedJson;
        }
        return IOUtils.toString((Reader)request.getReader());
    }

    private String getResponseBody(HttpResponse response) throws IOException {
        Header contentEncoding = response.getFirstHeader("Content-Encoding");
        if (contentEncoding != null && contentEncoding.getValue() != null && contentEncoding.getValue().contains("gzip")) {
            GZIPInputStream gzipIn = new GZIPInputStream(response.getEntity().getContent());
            String gunzippedEncodedJson = IOUtils.toString((InputStream)gzipIn);
            gzipIn.close();
            return gunzippedEncodedJson;
        }
        return IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
    }

    private void checkActive() {
        if (this.deactivated) {
            throw new IllegalStateException(this.getClass().getName() + " is not active");
        }
        if ((this.trustEnabled || this.encryptionEnabled) && this.sharedKey == null) {
            throw new IllegalStateException(this.getClass().getName() + " Shared Key must be set if encryption or signing is enabled.");
        }
    }
}

