/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.View;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.apache.sling.discovery.impl.common.resource.EstablishedClusterView;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ClusterViewService.class, ClusterViewServiceImpl.class})
public class ClusterViewServiceImpl
implements ClusterViewService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Config config;
    private String failedEstablishedViewId;

    public static ClusterViewService testConstructor(SlingSettingsService settingsService, ResourceResolverFactory factory, Config config) {
        ClusterViewServiceImpl service = new ClusterViewServiceImpl();
        service.settingsService = settingsService;
        service.resourceResolverFactory = factory;
        service.config = config;
        return service;
    }

    public String getSlingId() {
        if (this.settingsService == null) {
            return null;
        }
        return this.settingsService.getSlingId();
    }

    public void invalidateEstablishedViewId(String establishedViewId) {
        if (!(establishedViewId == null || this.failedEstablishedViewId != null && this.failedEstablishedViewId.equals(establishedViewId))) {
            this.logger.info("invalidateEstablishedViewId: marking established view as invalid: " + establishedViewId);
        }
        this.failedEstablishedViewId = establishedViewId;
    }

    public LocalClusterView getLocalClusterView() throws UndefinedClusterViewException {
        if (this.resourceResolverFactory == null) {
            this.logger.warn("getClusterView: no resourceResolverFactory set at the moment.");
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "no resourceResolverFactory set");
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            View view = ViewHelper.getEstablishedView(resourceResolver, this.config);
            if (view == null) {
                this.logger.debug("getClusterView: no view established at the moment. isolated mode");
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "no established view at the moment");
            }
            if (this.failedEstablishedViewId != null && this.failedEstablishedViewId.equals(view.getResource().getName())) {
                this.logger.debug("getClusterView: current establishedView is marked as invalid: " + this.failedEstablishedViewId);
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "current established view was marked as invalid");
            }
            EstablishedClusterView clusterViewImpl = new EstablishedClusterView(this.config, view, this.getSlingId());
            InstanceDescription local = clusterViewImpl.getLocalInstance();
            if (local != null) {
                EstablishedClusterView establishedClusterView = clusterViewImpl;
                return establishedClusterView;
            }
            try {
                this.logger.info("getClusterView: the local instance (" + this.getSlingId() + ") is currently not included in the existing established view! " + "This is normal at startup. At other times is pseudo-network-partitioning is an indicator for repository/network-delays or clocks-out-of-sync (SLING-3432). " + "(increasing the heartbeatTimeout can help as a workaround too) " + "The local instance will stay in TOPOLOGY_CHANGING or pre _INIT mode until a new vote was successful.");
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.ISOLATED_FROM_TOPOLOGY, "established view does not include local instance - isolated");
            }
            catch (UndefinedClusterViewException e) {
                throw e;
            }
            catch (LoginException e) {
                this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "could not log in administratively: " + (Object)((Object)e));
            }
            catch (Exception e) {
                this.logger.error("handleEvent: got an exception: " + e, (Throwable)e);
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "could not log in administratively: " + e);
            }
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

