/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster.voting;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.View;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VotingView
extends View {
    private static final Logger logger = LoggerFactory.getLogger(VotingView.class);

    public static VotingView newVoting(ResourceResolver resourceResolver, Config config, String newViewId, String initiatorId, Set<String> liveInstances) throws PersistenceException {
        if (!liveInstances.contains(initiatorId)) {
            logger.warn("newVoting: liveInstances does not include initiatorId (local instance) - not creating new, invalid, voting");
            return null;
        }
        Resource votingResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)(config.getOngoingVotingsPath() + "/" + newViewId));
        ModifiableValueMap votingMap = (ModifiableValueMap)votingResource.adaptTo(ModifiableValueMap.class);
        votingMap.put((Object)"votingStart", (Object)Calendar.getInstance());
        String clusterId = null;
        Calendar clusterIdDefinedAt = null;
        String clusterIdDefinedBy = null;
        View currentlyEstablishedView = ViewHelper.getEstablishedView(resourceResolver, config);
        if (currentlyEstablishedView != null) {
            Date date;
            ValueMap establishedViewValueMap = (ValueMap)currentlyEstablishedView.getResource().adaptTo(ValueMap.class);
            clusterId = (String)establishedViewValueMap.get("clusterId", String.class);
            if (clusterId == null || clusterId.length() == 0) {
                clusterId = currentlyEstablishedView.getResource().getName();
            }
            if ((date = (Date)establishedViewValueMap.get("clusterIdDefinedAt", Date.class)) != null) {
                clusterIdDefinedAt = Calendar.getInstance();
                clusterIdDefinedAt.setTime(date);
            }
            clusterIdDefinedBy = (String)establishedViewValueMap.get("clusterIdDefinedBy", String.class);
        }
        if (clusterId == null || clusterId.length() == 0) {
            clusterId = newViewId;
            clusterIdDefinedAt = Calendar.getInstance();
        }
        votingMap.put((Object)"clusterId", (Object)clusterId);
        if (clusterIdDefinedAt != null) {
            votingMap.put((Object)"clusterIdDefinedAt", (Object)clusterIdDefinedAt);
        }
        if (clusterIdDefinedBy == null || clusterIdDefinedBy.length() == 0) {
            clusterIdDefinedBy = initiatorId;
        }
        votingMap.put((Object)"clusterIdDefinedBy", (Object)clusterIdDefinedBy);
        Resource membersResource = resourceResolver.create(votingResource, "members", null);
        for (String memberId : liveInstances) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (memberId.equals(initiatorId)) {
                properties.put("initiator", true);
                properties.put("vote", true);
                properties.put("votedAt", Calendar.getInstance());
            }
            Resource instanceResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)(config.getClusterInstancesPath() + "/" + memberId));
            String leaderElectionId = (String)((ValueMap)instanceResource.adaptTo(ValueMap.class)).get("leaderElectionId", String.class);
            properties.put("leaderElectionId", leaderElectionId);
            resourceResolver.create(membersResource, memberId, properties);
        }
        resourceResolver.commit();
        logger.info("newVoting: new voting started: newViewId=" + newViewId + ", initiatorId=" + initiatorId + ", resource=" + votingResource + ", #members: " + liveInstances.size() + ", members: " + liveInstances);
        return new VotingView(votingResource);
    }

    public VotingView(Resource viewResource) {
        super(viewResource);
    }

    public String getVotingId() {
        return this.getResource().getName();
    }

    public String toString() {
        try {
            Resource members = this.getResource().getChild("members");
            String initiatorId = null;
            StringBuilder sb = new StringBuilder();
            if (members != null) {
                for (Resource r : members.getChildren()) {
                    Boolean initiator;
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(r.getName());
                    ValueMap properties = (ValueMap)r.adaptTo(ValueMap.class);
                    if (properties == null || (initiator = (Boolean)properties.get("initiator", Boolean.class)) == null || !initiator.booleanValue()) continue;
                    initiatorId = r.getName();
                }
            }
            return "a VotingView[viewId=" + this.getViewId() + ", id=" + this.getResource().getName() + ", initiator=" + initiatorId + ", members=" + sb + "]";
        }
        catch (Exception e) {
            return "a VotingView[" + super.toString() + "]";
        }
    }

    public boolean isOngoingVoting(Config config) {
        long votingStart = this.getVotingStartTime();
        if (votingStart == -1L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long diff = now - votingStart;
        return diff < config.getHeartbeatTimeoutMillis();
    }

    public boolean isTimedoutVoting(Config config) {
        long votingStart = this.getVotingStartTime();
        if (votingStart == -1L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long diff = now - votingStart;
        return diff > config.getHeartbeatTimeoutMillis();
    }

    private long getVotingStartTime() {
        ValueMap properties = null;
        try {
            properties = (ValueMap)this.getResource().adaptTo(ValueMap.class);
        }
        catch (RuntimeException e) {
            logger.info("getVotingStartTime: could not get properties of " + this.getResource() + ". Likely in creation: " + e, (Throwable)e);
            return -1L;
        }
        if (properties == null) {
            return -1L;
        }
        Date votingStartDate = (Date)properties.get("votingStart", Date.class);
        if (votingStartDate == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getVotingStartTime: got a voting without votingStart. Likely in creation: " + this.getResource());
            }
            return -1L;
        }
        long votingStart = votingStartDate.getTime();
        return votingStart;
    }

    public boolean hasNoVotes() {
        Resource m = this.getResource().getChild("members");
        if (m == null) {
            return false;
        }
        for (Resource aMemberRes : m.getChildren()) {
            Boolean vote;
            ValueMap properties = (ValueMap)aMemberRes.adaptTo(ValueMap.class);
            if (properties == null || (vote = (Boolean)properties.get("vote", Boolean.class)) == null || vote.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVotedYes(String slingId) {
        Boolean vote = this.getVote(slingId);
        return vote != null && vote != false;
    }

    public Boolean getVote(String slingId) {
        Resource members = this.getResource().getChild("members");
        if (members == null) {
            return null;
        }
        Resource memberResource = members.getChild(slingId);
        if (memberResource == null) {
            return null;
        }
        ValueMap properties = (ValueMap)memberResource.adaptTo(ValueMap.class);
        if (properties == null) {
            return null;
        }
        Boolean vote = (Boolean)properties.get("vote", Boolean.class);
        return vote;
    }

    public boolean isInitiatedBy(String slingId) {
        boolean result;
        Resource r = this.getResource();
        if (r == null) {
            return false;
        }
        Resource members = r.getChild("members");
        if (members == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("isInitiatedBy: slingId=" + slingId + ", members null!");
            }
            return false;
        }
        Resource memberResource = members.getChild(slingId);
        if (memberResource == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("isInitiatedBy: slingId=" + slingId + ", memberResource null!");
            }
            return false;
        }
        ValueMap properties = (ValueMap)memberResource.adaptTo(ValueMap.class);
        if (properties == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("isInitiatedBy: slingId=" + slingId + ", properties null!");
            }
            return false;
        }
        Boolean initiator = (Boolean)properties.get("initiator", Boolean.class);
        boolean bl = result = initiator != null && initiator != false;
        if (logger.isDebugEnabled()) {
            logger.debug("isInitiatedBy: slingId=" + slingId + ", initiator=" + initiator + ", result=" + result);
        }
        return result;
    }

    public void vote(String slingId, Boolean vote, String leaderElectionId) {
        Resource r;
        if (logger.isDebugEnabled()) {
            logger.debug("vote: slingId=" + slingId + ", vote=" + vote);
        }
        if ((r = this.getResource()) == null) {
            logger.error("vote: no resource set. slingId = " + slingId + ", vote=" + vote);
            return;
        }
        Resource members = r.getChild("members");
        if (members == null) {
            logger.error("vote: no members resource available for " + r + ". slingId = " + slingId + ", vote=" + vote);
            return;
        }
        Resource memberResource = members.getChild(slingId);
        if (memberResource == null) {
            if (vote == null || !vote.booleanValue()) {
                logger.debug("vote: no memberResource found for slingId=" + slingId + ", vote=" + vote + ", resource=" + this.getResource());
            } else {
                logger.error("vote: no memberResource found for slingId=" + slingId + ", vote=" + vote + ", resource=" + this.getResource());
            }
            return;
        }
        ModifiableValueMap memberMap = (ModifiableValueMap)memberResource.adaptTo(ModifiableValueMap.class);
        if (vote == null) {
            if (memberMap.containsKey((Object)"vote")) {
                logger.info("vote: removing vote (vote==null) of slingId=" + slingId + " on: " + this);
            } else {
                logger.debug("vote: removing vote (vote==null) of slingId=" + slingId + " on: " + this);
            }
            memberMap.remove((Object)"vote");
        } else {
            boolean shouldVote = true;
            try {
                if (memberMap.containsKey((Object)"vote")) {
                    Boolean b;
                    Object v = memberMap.get((Object)"vote");
                    if (v instanceof Property) {
                        Property p = (Property)v;
                        if (p.getBoolean() == vote.booleanValue()) {
                            logger.debug("vote: already voted, with same vote (" + vote + "), not voting again");
                            shouldVote = false;
                        }
                    } else if (v instanceof Boolean && (b = (Boolean)v) == vote) {
                        logger.debug("vote: already voted, with same vote (" + vote + "), not voting again");
                        shouldVote = false;
                    }
                }
            }
            catch (ValueFormatException e) {
                logger.warn("vote: got a ValueFormatException: " + (Object)((Object)e), (Throwable)e);
            }
            catch (RepositoryException e) {
                logger.warn("vote: got a RepositoryException: " + (Object)((Object)e), (Throwable)e);
            }
            if (shouldVote) {
                logger.info("vote: slingId=" + slingId + " is voting vote=" + vote + " on " + this.getResource());
                memberMap.put((Object)"vote", (Object)vote);
                memberMap.put((Object)"votedAt", (Object)Calendar.getInstance());
                String currentLeaderElectionId = (String)memberMap.get("leaderElectionId", String.class);
                if (!(leaderElectionId == null || currentLeaderElectionId != null && currentLeaderElectionId.equals(leaderElectionId))) {
                    logger.info("vote: changing leaderElectionId on vote to " + leaderElectionId);
                    memberMap.put((Object)"leaderElectionId", (Object)leaderElectionId);
                    memberMap.put((Object)"leaderElectionIdCreatedAt", (Object)new Date());
                }
            }
        }
        try {
            this.getResource().getResourceResolver().commit();
        }
        catch (PersistenceException e) {
            logger.error("vote: PersistenceException while voting: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public boolean isWinning() {
        Resource members = this.getResource().getChild("members");
        if (members == null) {
            return false;
        }
        try {
            Iterable children = members.getChildren();
            Iterator it = children.iterator();
            boolean isWinning = false;
            while (it.hasNext()) {
                Resource aMemberRes = (Resource)it.next();
                try {
                    ValueMap properties = (ValueMap)aMemberRes.adaptTo(ValueMap.class);
                    Boolean vote = (Boolean)properties.get("vote", Boolean.class);
                    if (vote != null && vote.booleanValue()) {
                        isWinning = true;
                        continue;
                    }
                    return false;
                }
                catch (RuntimeException re) {
                    logger.info("isWinning: Could not check vote due to " + re);
                    return false;
                }
            }
            return isWinning;
        }
        catch (RuntimeException re) {
            logger.info("isWinning: could not check vote due to " + re);
            return false;
        }
    }

    public String matchesLiveView(Config config) throws Exception {
        Resource clusterNodesRes = this.getResource().getResourceResolver().getResource(config.getClusterInstancesPath());
        if (clusterNodesRes == null) {
            throw new Exception("no clusterNodesRes[" + this.getResource() + "]");
        }
        return this.matchesLiveView(clusterNodesRes, config);
    }
}

