/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster.voting;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.voting.VotingHelper;
import org.apache.sling.discovery.impl.cluster.voting.VotingView;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={VotingHandler.class})
public class VotingHandler
implements EventHandler {
    private static final Comparator<VotingView> VOTING_COMPARATOR = new Comparator<VotingView>(){

        @Override
        public int compare(VotingView o1, VotingView o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o2 == null && o1 != null) {
                return -1;
            }
            return o1.getVotingId().compareTo(o2.getVotingId());
        }
    };
    protected String NAME = "discovery.impl.analyzeVotings.runner.";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService slingSettingsService;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private Config config;
    private String slingId;
    private volatile String leaderElectionId;
    private volatile boolean activated;
    private ComponentContext context;
    private ServiceRegistration eventHandlerRegistration;

    public static VotingHandler testConstructor(SlingSettingsService settingsService, ResourceResolverFactory factory, Config config) {
        VotingHandler handler = new VotingHandler();
        handler.slingSettingsService = settingsService;
        handler.resolverFactory = factory;
        handler.config = config;
        return handler;
    }

    @Deactivate
    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.logger.info("deactivate: VotingHandler unregistered as EventHandler");
            this.eventHandlerRegistration = null;
        }
        this.activated = false;
        this.logger.info("deactivate: deactivated slingId: {}, this: {}", (Object)this.slingId, (Object)this);
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.slingId = this.slingSettingsService.getSlingId();
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getCanonicalName() + "." + this.slingId));
        this.context = context;
        this.activated = true;
        this.registerEventHandler();
        this.logger.info("activated: activated (" + this.slingId + ")");
    }

    private void registerEventHandler() {
        BundleContext bundleContext;
        BundleContext bundleContext2 = bundleContext = this.context == null ? null : this.context.getBundleContext();
        if (bundleContext == null) {
            this.logger.info("registerEventHandler: context or bundleContext is null - cannot register");
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "Voting Event Listener");
        String[] topics = new String[]{"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"};
        ((Dictionary)properties).put("event.topics", topics);
        String path = this.config.getDiscoveryResourcePath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        path = path + "/*";
        ((Dictionary)properties).put("event.filter", "(&(path=" + path + "))");
        this.eventHandlerRegistration = bundleContext.registerService(EventHandler.class.getName(), (Object)this, properties);
        this.logger.info("registerEventHandler: VotingHandler registered as EventHandler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (!this.activated) {
            return;
        }
        String resourcePath = (String)event.getProperty("path");
        String ongoingVotingsPath = this.config.getOngoingVotingsPath();
        if (resourcePath == null) {
            return;
        }
        if (!resourcePath.startsWith(ongoingVotingsPath)) {
            return;
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            return;
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handleEvent: path = " + resourcePath + ", event = " + event);
            }
            this.analyzeVotings(resourceResolver);
        }
        catch (PersistenceException e) {
            this.logger.error("handleEvent: got a PersistenceException during votings analysis: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    public synchronized Map<VotingView, VotingDetail> analyzeVotings(ResourceResolver resourceResolver) throws PersistenceException {
        if (!this.activated) {
            this.logger.info("analyzeVotings: VotingHandler not yet initialized, can't vote.");
            return null;
        }
        HashMap<VotingView, VotingDetail> result = new HashMap<VotingView, VotingDetail>();
        this.logger.debug("analyzeVotings: start. slingId: {}", (Object)this.slingId);
        resourceResolver.refresh();
        VotingView winningVote = VotingHelper.getWinningVoting(resourceResolver, this.config);
        if (winningVote != null) {
            if (winningVote.isInitiatedBy(this.slingId)) {
                this.logger.info("analyzeVotings: my voting was winning. I'll mark it as established then! " + winningVote);
                try {
                    this.promote(resourceResolver, winningVote.getResource());
                }
                catch (RuntimeException re) {
                    this.logger.error("analyzeVotings: RuntimeException during promotion: " + re, (Throwable)re);
                    throw re;
                }
                catch (Error er) {
                    this.logger.error("analyzeVotings: Error during promotion: " + er, (Throwable)er);
                    throw er;
                }
                resourceResolver.commit();
                result.put(winningVote, VotingDetail.PROMOTED);
                return result;
            }
            this.logger.info("analyzeVotings: there is a winning vote. No need to vote any further. Expecting it to get promoted to established: " + winningVote);
            result.put(winningVote, VotingDetail.WINNING);
            return result;
        }
        List<VotingView> ongoingVotings = VotingHelper.listVotings(resourceResolver, this.config);
        if (ongoingVotings == null || ongoingVotings.size() == 0) {
            this.logger.debug("analyzeVotings: no ongoing votings at the moment. done.");
            return result;
        }
        Collections.sort(ongoingVotings, VOTING_COMPARATOR);
        VotingView yesVote = null;
        for (VotingView voting : ongoingVotings) {
            String liveComparison;
            boolean votedYes;
            Boolean myVote = voting.getVote(this.slingId);
            boolean votedNo = myVote != null && myVote == false;
            boolean bl = votedYes = myVote != null && myVote != false;
            if (voting.isTimedoutVoting(this.config)) {
                this.logger.info("analyzeVotings: deleting a timed out voting: " + voting);
                voting.remove(false);
                result.put(voting, VotingDetail.TIMEDOUT);
                continue;
            }
            if (voting.hasNoVotes()) {
                if (!votedNo) {
                    this.logger.info("analyzeVotings: vote already has no votes, so I shall also vote no: " + voting);
                    voting.vote(this.slingId, false, null);
                    result.put(voting, VotingDetail.VOTED_NO);
                    continue;
                }
                result.put(voting, VotingDetail.UNCHANGED);
                continue;
            }
            if (!voting.isOngoingVoting(this.config)) {
                this.logger.debug("analyzeVotings: vote is not ongoing (ignoring): " + voting);
                continue;
            }
            try {
                liveComparison = voting.matchesLiveView(this.config);
            }
            catch (Exception e) {
                this.logger.error("analyzeVotings: could not compare voting with live view: " + e, (Throwable)e);
                continue;
            }
            if (liveComparison != null) {
                if (!votedNo) {
                    this.logger.info("analyzeVotings: vote doesnt match my live view, voting no. comparison result: " + liveComparison + ", vote: " + voting);
                    voting.vote(this.slingId, false, null);
                    result.put(voting, VotingDetail.VOTED_NO);
                    continue;
                }
                result.put(voting, VotingDetail.UNCHANGED);
                continue;
            }
            if (yesVote != null) {
                if (!votedNo) {
                    this.logger.info("analyzeVotings: already voted yes, so voting no for: " + voting);
                    voting.vote(this.slingId, false, null);
                    result.put(voting, VotingDetail.VOTED_NO);
                    continue;
                }
                result.put(voting, VotingDetail.UNCHANGED);
                continue;
            }
            if (!votedYes) {
                this.logger.info("analyzeVotings: not timed out, no no-votes, matches live, still ongoing, I have not yet voted yes, so noting candidate for yes as: " + voting);
            }
            yesVote = voting;
        }
        if (yesVote != null) {
            boolean votedYes;
            Boolean myVote = yesVote.getVote(this.slingId);
            boolean bl = votedYes = myVote != null && myVote != false;
            if (!votedYes) {
                this.logger.info("analyzeVotings: declaring my personal winner: " + yesVote + " (myVote==null: " + (myVote == null) + ")");
                yesVote.vote(this.slingId, true, this.leaderElectionId);
                result.put(yesVote, VotingDetail.VOTED_YES);
            } else {
                result.put(yesVote, VotingDetail.UNCHANGED);
            }
        }
        resourceResolver.commit();
        this.logger.debug("analyzeVotings: result: my yes vote was for: " + yesVote);
        return result;
    }

    public void cleanupTimedoutVotings(ResourceResolver resourceResolver) {
        List<VotingView> timedoutVotings = VotingHelper.listTimedoutVotings(resourceResolver, this.config);
        for (VotingView timedoutVotingRes : timedoutVotings) {
            if (timedoutVotingRes == null) continue;
            this.logger.info("cleanupTimedoutVotings: removing a timed out voting: " + timedoutVotingRes);
            timedoutVotingRes.remove(false);
        }
    }

    private void promote(ResourceResolver resourceResolver, Resource winningVoteResource) throws PersistenceException {
        Resource previousViewsResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getPreviousViewPath());
        Resource establishedViewsResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getEstablishedViewPath());
        Resource ongoingVotingsResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getOngoingVotingsPath());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("promote: previousViewsResource=" + previousViewsResource.getPath());
            this.logger.debug("promote: establishedViewsResource=" + establishedViewsResource.getPath());
            this.logger.debug("promote: ongoingVotingsResource=" + ongoingVotingsResource.getPath());
            this.logger.debug("promote: winningVoteResource=" + winningVoteResource.getPath());
        }
        Iterator it1 = previousViewsResource.getChildren().iterator();
        try {
            while (it1.hasNext()) {
                Resource previousView = (Resource)it1.next();
                resourceResolver.delete(previousView);
            }
        }
        catch (PersistenceException e) {
            this.logger.error("promote: Could not delete a previous view - trying move next: " + (Object)((Object)e), (Throwable)e);
            ResourceHelper.moveResource((Resource)previousViewsResource, (String)(this.config.getPreviousViewPath() + "_trash_" + UUID.randomUUID().toString()));
            this.logger.info("promote: recreating the previousviews node");
            previousViewsResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getPreviousViewPath());
        }
        Iterator it = establishedViewsResource.getChildren().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Resource retiredView = (Resource)it.next();
            if (first) {
                boolean bl = first = !first;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("promote: moving the old established view to previous views: " + retiredView.getPath());
                }
                ResourceHelper.moveResource((Resource)retiredView, (String)(previousViewsResource.getPath() + "/" + retiredView.getName()));
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("promote: retiring an erroneously additionally established node " + retiredView.getPath());
            }
            resourceResolver.delete(retiredView);
        }
        Iterator it2 = winningVoteResource.getChild("members").getChildren().iterator();
        String leaderElectionId = null;
        String leaderid = null;
        int membersCount = 0;
        while (it2.hasNext()) {
            Resource aMember = (Resource)it2.next();
            ++membersCount;
            String leid = (String)((ValueMap)aMember.adaptTo(ValueMap.class)).get("leaderElectionId", String.class);
            if (leaderElectionId != null && (leid == null || leid.compareTo(leaderElectionId) >= 0)) continue;
            leaderElectionId = leid;
            leaderid = aMember.getName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("promote: leader is " + leaderid + " - with leaderElectionId=" + leaderElectionId);
        }
        ModifiableValueMap winningVoteMap = (ModifiableValueMap)winningVoteResource.adaptTo(ModifiableValueMap.class);
        winningVoteMap.put((Object)"leaderId", leaderid);
        winningVoteMap.put((Object)"leaderElectionId", (Object)leaderElectionId);
        winningVoteMap.put((Object)"promotedAt", (Object)Calendar.getInstance());
        winningVoteMap.put((Object)"promotedBy", (Object)this.slingId);
        String newEstablishedViewPath = establishedViewsResource.getPath() + "/" + winningVoteResource.getName();
        this.logger.info("promote: promoting to new established node (#members: " + membersCount + ", path: " + newEstablishedViewPath + ")");
        ResourceHelper.moveResource((Resource)winningVoteResource, (String)newEstablishedViewPath);
        Iterable ongoingVotingsChildren = ongoingVotingsResource.getChildren();
        if (ongoingVotingsChildren != null) {
            for (Resource anOngoingVoting : ongoingVotingsChildren) {
                this.logger.info("promote: deleting ongoing voting: " + anOngoingVoting.getName());
                resourceResolver.delete(anOngoingVoting);
            }
        }
        for (Resource resource : ongoingVotingsResource.getParent().getChildren()) {
            if (!resource.getPath().startsWith(this.config.getOngoingVotingsPath()) || resource.getPath().equals(this.config.getOngoingVotingsPath())) continue;
            this.logger.warn("promote: cleaning up a duplicate ongoingVotingPath: " + resource.getPath());
            resourceResolver.delete(resource);
        }
        this.logger.debug("promote: done with promotiong. saving.");
        resourceResolver.commit();
        this.logger.info("promote: promotion done (#members: " + membersCount + ", path: " + newEstablishedViewPath + ")");
    }

    public void setLeaderElectionId(String leaderElectionId) {
        this.logger.info("setLeaderElectionId: leaderElectionId=" + leaderElectionId);
        this.leaderElectionId = leaderElectionId;
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    public static enum VotingDetail {
        PROMOTED,
        WINNING,
        VOTED_YES,
        VOTED_NO,
        UNCHANGED,
        TIMEDOUT;

    }
}

