/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.common.heartbeat;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.base.commons.BaseViewChecker;
import org.apache.sling.discovery.base.commons.PeriodicBackgroundJob;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.DiscoveryServiceImpl;
import org.apache.sling.discovery.impl.cluster.voting.VotingHandler;
import org.apache.sling.discovery.impl.cluster.voting.VotingHelper;
import org.apache.sling.discovery.impl.cluster.voting.VotingView;
import org.apache.sling.discovery.impl.common.View;
import org.apache.sling.discovery.impl.common.ViewHelper;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleException;
import org.osgi.service.http.HttpService;

@Component
@Service(value={HeartbeatHandler.class})
@Reference(referenceInterface=HttpService.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class HeartbeatHandler
extends BaseViewChecker {
    private static final String PROPERTY_ID_LAST_HEARTBEAT = "lastHeartbeat";
    @Reference
    protected SlingSettingsService slingSettingsService;
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected ConnectorRegistry connectorRegistry;
    @Reference
    protected AnnouncementRegistry announcementRegistry;
    @Reference
    protected Scheduler scheduler;
    @Reference
    private Config config;
    @Reference
    private VotingHandler votingHandler;
    private String nextVotingId = UUID.randomUUID().toString();
    private volatile boolean resetLeaderElectionId = false;
    private volatile String newLeaderElectionId;
    private long firstHeartbeatWritten = -1L;
    private volatile Calendar lastHeartbeatWritten = null;
    private DiscoveryServiceImpl discoveryServiceImpl;
    private String lastEstablishedViewId;
    protected String failedEstablishedViewId;
    protected PeriodicBackgroundJob periodicCheckJob;

    public static HeartbeatHandler testConstructor(SlingSettingsService slingSettingsService, ResourceResolverFactory factory, AnnouncementRegistry announcementRegistry, ConnectorRegistry connectorRegistry, Config config, Scheduler scheduler, VotingHandler votingHandler) {
        HeartbeatHandler handler = new HeartbeatHandler();
        handler.slingSettingsService = slingSettingsService;
        handler.resourceResolverFactory = factory;
        handler.announcementRegistry = announcementRegistry;
        handler.connectorRegistry = connectorRegistry;
        handler.config = config;
        handler.scheduler = scheduler;
        handler.votingHandler = votingHandler;
        return handler;
    }

    protected AnnouncementRegistry getAnnouncementRegistry() {
        return this.announcementRegistry;
    }

    protected BaseConfig getConnectorConfig() {
        return this.config;
    }

    protected ConnectorRegistry getConnectorRegistry() {
        return this.connectorRegistry;
    }

    protected ResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    protected SlingSettingsService getSlingSettingsService() {
        return this.slingSettingsService;
    }

    protected void doActivate() {
        this.resetLeaderElectionId = true;
        this.runtimeId = UUID.randomUUID().toString();
        this.firstHeartbeatWritten = -1L;
        this.lastHeartbeatWritten = null;
        this.logger.info("doActivate: activated with runtimeId: {}, slingId: {}", (Object)this.runtimeId, (Object)this.slingId);
    }

    protected void deactivate() {
        super.deactivate();
        if (this.periodicCheckJob != null) {
            this.periodicCheckJob.stop();
            this.periodicCheckJob = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(final DiscoveryServiceImpl discoveryService, String initialVotingId) {
        Object object = this.lock;
        synchronized (object) {
            this.discoveryServiceImpl = discoveryService;
            this.nextVotingId = initialVotingId;
            this.logger.info("initialize: nextVotingId=" + this.nextVotingId);
            this.issueHeartbeat();
        }
        try {
            long interval = this.config.getHeartbeatInterval();
            this.logger.info("initialize: starting periodic heartbeat job for " + this.slingId + " with interval " + interval + " sec.");
            if (interval == 0L) {
                this.logger.warn("initialize: Repeat interval cannot be zero. Defaulting to 10sec");
                interval = 10L;
            }
            this.periodicPingJob = new PeriodicBackgroundJob(interval, this.NAME, (Runnable)((Object)this));
        }
        catch (Exception e) {
            this.logger.error("activate: Could not start heartbeat runner: " + e, (Throwable)e);
        }
        try {
            long interval = this.config.getHeartbeatInterval();
            final long heartbeatTimeoutMillis = this.config.getHeartbeatTimeoutMillis();
            final long heartbeatIntervalMillis = this.config.getHeartbeatInterval() * 1000L;
            final long maxMillisSinceHb = Math.max(Math.min(heartbeatTimeoutMillis, 2L * heartbeatIntervalMillis), heartbeatTimeoutMillis - 2L * heartbeatIntervalMillis);
            this.logger.info("initialize: starting periodic checkForLocalClusterViewChange job for " + this.slingId + " with maxMillisSinceHb=" + maxMillisSinceHb + "ms, interval=" + interval + " sec.");
            if (interval == 0L) {
                this.logger.warn("initialize: Repeat interval cannot be zero. Defaulting to 10sec.");
                interval = 10L;
            }
            this.periodicCheckJob = new PeriodicBackgroundJob(interval, this.NAME + ".checkForLocalClusterViewChange", new Runnable(){

                @Override
                public void run() {
                    long timeSinceHb;
                    Calendar lastHb = HeartbeatHandler.this.lastHeartbeatWritten;
                    if (lastHb != null && (timeSinceHb = System.currentTimeMillis() - lastHb.getTimeInMillis()) > maxMillisSinceHb) {
                        HeartbeatHandler.this.logger.warn("checkForLocalClusterViewChange/.run: time since local instance last wrote a heartbeat is " + timeSinceHb + "ms (heartbeatTimeoutMillis=" + heartbeatTimeoutMillis + ", heartbeatIntervalMillis=" + heartbeatIntervalMillis + " => maxMillisSinceHb=" + maxMillisSinceHb + "). Flagging us as (still) changing");
                        HeartbeatHandler.this.invalidateCurrentEstablishedView();
                        discoveryService.handleTopologyChanging();
                        return;
                    }
                    HeartbeatHandler.this.logger.debug("checkForLocalClusterViewChange/.run: going to check for topology change...");
                    discoveryService.checkForLocalClusterViewChange();
                    HeartbeatHandler.this.logger.debug("checkForLocalClusterViewChange/.run: check for topology change done.");
                }
            });
        }
        catch (Exception e) {
            this.logger.error("activate: Could not start heartbeat runner: " + e, (Throwable)e);
        }
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        if (this.resourceResolverFactory == null) {
            this.logger.error("getResourceResolver: resourceResolverFactory is null!");
            return null;
        }
        return this.resourceResolverFactory.getAdministrativeResourceResolver(null);
    }

    private String getLocalClusterNodePath() {
        return this.config.getClusterInstancesPath() + "/" + this.slingId;
    }

    public boolean resetLeaderElectionId() {
        if (this.resetLeaderElectionId) {
            return false;
        }
        this.resetLeaderElectionId = true;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            if (resourceResolver != null) {
                this.newLeaderElectionId = this.newLeaderElectionId(resourceResolver);
                if (this.votingHandler != null) {
                    this.logger.info("resetLeaderElectionId: set new leaderElectionId with votingHandler to: " + this.newLeaderElectionId);
                    this.votingHandler.setLeaderElectionId(this.newLeaderElectionId);
                } else {
                    this.logger.info("resetLeaderElectionId: no votingHandler, new leaderElectionId would be: " + this.newLeaderElectionId);
                }
            } else {
                this.logger.warn("resetLeaderElectionId: could not login, new leaderElectionId will be calculated upon next heartbeat only!");
            }
        }
        catch (LoginException e) {
            this.logger.error("resetLeaderElectionid: could not login: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return true;
    }

    protected void issueHeartbeat() {
        this.updateProperties();
        this.issueClusterLocalHeartbeat();
        this.issueConnectorPings();
    }

    protected void updateProperties() {
        if (this.discoveryServiceImpl == null) {
            this.logger.debug("updateProperties: discoveryService is null");
        } else {
            this.discoveryServiceImpl.updateProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void issueClusterLocalHeartbeat() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("issueClusterLocalHeartbeat: storing cluster-local heartbeat to repository for " + this.slingId);
        }
        ResourceResolver resourceResolver = null;
        String myClusterNodePath = this.getLocalClusterNodePath();
        Calendar currentTime = Calendar.getInstance();
        try {
            resourceResolver = this.getResourceResolver();
            if (resourceResolver == null) {
                this.logger.error("issueClusterLocalHeartbeat: no resourceresolver available!");
                return;
            }
            Resource resource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)myClusterNodePath);
            ModifiableValueMap resourceMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            if (this.firstHeartbeatWritten != -1L && this.lastHeartbeatWritten != null) {
                String readRuntimeId;
                Calendar lastHeartbeat;
                long timeSinceFirstHeartbeat = System.currentTimeMillis() - this.firstHeartbeatWritten;
                if (timeSinceFirstHeartbeat > 2L * this.config.getHeartbeatInterval() && (lastHeartbeat = (Calendar)resourceMap.get(PROPERTY_ID_LAST_HEARTBEAT, Calendar.class)) != null && !this.lastHeartbeatWritten.getTime().equals(lastHeartbeat.getTime())) {
                    this.invalidateCurrentEstablishedView();
                    this.discoveryServiceImpl.handleTopologyChanging();
                    this.logger.error("issueClusterLocalHeartbeat: SLING-2892: Detected unexpected, concurrent update of: " + myClusterNodePath + " 'lastHeartbeat'. If not done manually, this likely indicates that there is more than 1 instance running in this cluster with the same sling.id. My sling.id is " + this.slingId + ". Check for sling.id.file in your installation of all instances in this cluster to verify this! Duplicate sling.ids are not allowed within a cluster!");
                }
                if ((readRuntimeId = (String)resourceMap.get("runtimeId", String.class)) == null) {
                    this.firstHeartbeatWritten = -1L;
                } else if (!this.runtimeId.equals(readRuntimeId)) {
                    this.invalidateCurrentEstablishedView();
                    this.discoveryServiceImpl.handleTopologyChanging();
                    String slingHomePath = this.slingSettingsService == null ? "n/a" : this.slingSettingsService.getSlingHomePath();
                    String endpointsAsString = this.getEndpointsAsString();
                    String readEndpoints = (String)resourceMap.get("endpoints", String.class);
                    String readSlingHomePath = (String)resourceMap.get("slingHomePath", String.class);
                    this.logger.error("issueClusterLocalHeartbeat: SLING-2901: Detected more than 1 instance running in this cluster  with the same sling.id. My sling.id: " + this.slingId + ", my runtimeId: " + this.runtimeId + ", my endpoints: " + endpointsAsString + ", my slingHomePath: " + slingHomePath + ", other runtimeId: " + readRuntimeId + ", other endpoints: " + readEndpoints + ", other slingHomePath:" + readSlingHomePath + " Check for sling.id.file in your installation of all instances in this cluster to verify this! Duplicate sling.ids are not allowed within a cluster!");
                    this.logger.error("issueClusterLocalHeartbeat: sending TOPOLOGY_CHANGING before self-disabling.");
                    this.discoveryServiceImpl.forcedShutdown();
                    this.logger.error("issueClusterLocalHeartbeat: disabling discovery.impl");
                    this.activated = false;
                    if (this.context != null) {
                        try {
                            this.context.getBundleContext().getBundle().stop();
                        }
                        catch (BundleException e) {
                            this.logger.warn("issueClusterLocalHeartbeat: could not stop bundle: " + (Object)((Object)e), (Throwable)e);
                            this.context.disableComponent(null);
                        }
                    }
                    return;
                }
            }
            resourceMap.put((Object)PROPERTY_ID_LAST_HEARTBEAT, (Object)currentTime);
            if (this.firstHeartbeatWritten == -1L) {
                resourceMap.put((Object)"runtimeId", (Object)this.runtimeId);
                String slingHomePath = this.slingSettingsService == null ? "n/a" : this.slingSettingsService.getSlingHomePath();
                resourceMap.put((Object)"slingHomePath", (Object)slingHomePath);
                String endpointsAsString = this.getEndpointsAsString();
                resourceMap.put((Object)"endpoints", (Object)endpointsAsString);
                this.logger.info("issueClusterLocalHeartbeat: storing my runtimeId: {}, endpoints: {} and sling home path: {}", new Object[]{this.runtimeId, endpointsAsString, slingHomePath});
            }
            if (this.resetLeaderElectionId || !resourceMap.containsKey((Object)"leaderElectionId")) {
                String newLeaderElectionId = this.newLeaderElectionId != null ? this.newLeaderElectionId : this.newLeaderElectionId(resourceResolver);
                this.newLeaderElectionId = null;
                resourceMap.put((Object)"leaderElectionId", (Object)newLeaderElectionId);
                resourceMap.put((Object)"leaderElectionIdCreatedAt", (Object)new Date());
                this.logger.info("issueClusterLocalHeartbeat: set leaderElectionId to " + newLeaderElectionId + " (resetLeaderElectionId: " + this.resetLeaderElectionId + ")");
                if (this.votingHandler != null) {
                    this.votingHandler.setLeaderElectionId(newLeaderElectionId);
                }
                this.resetLeaderElectionId = false;
            }
            this.logger.debug("issueClusterLocalHeartbeat: committing cluster-local heartbeat to repository for {}", (Object)this.slingId);
            resourceResolver.commit();
            this.logger.debug("issueClusterLocalHeartbeat: committed cluster-local heartbeat to repository for {}", (Object)this.slingId);
            this.lastHeartbeatWritten = currentTime;
            if (this.firstHeartbeatWritten == -1L) {
                this.firstHeartbeatWritten = System.currentTimeMillis();
            }
        }
        catch (LoginException e) {
            this.logger.error("issueHeartbeat: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("issueHeartbeat: Got a PersistenceException: " + myClusterNodePath + " " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private String newLeaderElectionId(ResourceResolver resourceResolver) {
        String value;
        Session session;
        int maxLongLength = String.valueOf(Long.MAX_VALUE).length();
        String currentTimeMillisStr = String.format("%0" + maxLongLength + "d", System.currentTimeMillis());
        boolean shouldInvertRepositoryDescriptor = this.config.shouldInvertRepositoryDescriptor();
        String prefix = shouldInvertRepositoryDescriptor ? "1" : "0";
        String leaderElectionRepositoryDescriptor = this.config.getLeaderElectionRepositoryDescriptor();
        if (leaderElectionRepositoryDescriptor != null && leaderElectionRepositoryDescriptor.length() != 0 && (session = (Session)resourceResolver.adaptTo(Session.class)) != null && (value = session.getRepository().getDescriptor(leaderElectionRepositoryDescriptor)) != null && value.equalsIgnoreCase("true")) {
            prefix = !shouldInvertRepositoryDescriptor ? "1" : "0";
        }
        String newLeaderElectionId = prefix + "_" + currentTimeMillisStr + "_" + this.slingId;
        return newLeaderElectionId;
    }

    protected void doCheckView() {
        super.doCheckView();
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            this.doCheckViewWith(resourceResolver);
        }
        catch (LoginException e) {
            this.logger.error("checkView: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("checkView: encountered a persistence exception during view check: " + (Object)((Object)e), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.error("checkView: encountered a runtime exception during view check: " + e, (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private void doCheckViewWith(ResourceResolver resourceResolver) throws PersistenceException {
        boolean establishedViewMatches;
        if (this.votingHandler == null) {
            this.logger.info("doCheckViewWith: votingHandler is null! slingId=" + this.slingId);
        } else {
            this.votingHandler.analyzeVotings(resourceResolver);
            try {
                this.votingHandler.cleanupTimedoutVotings(resourceResolver);
            }
            catch (Exception e) {
                this.logger.warn("doCheckViewWith: Exception occurred while cleaning up votings: " + e, (Throwable)e);
            }
        }
        VotingView winningVoting = VotingHelper.getWinningVoting(resourceResolver, this.config);
        int numOpenNonWinningVotes = VotingHelper.listOpenNonWinningVotings(resourceResolver, this.config).size();
        if (winningVoting != null || numOpenNonWinningVotes > 0) {
            this.logger.info("doCheckViewWith: there are pending votings, marking topology as changing...");
            this.invalidateCurrentEstablishedView();
            this.discoveryServiceImpl.handleTopologyChanging();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("doCheckViewWith: " + numOpenNonWinningVotes + " ongoing votings, no one winning yet - I shall wait for them to settle.");
            }
            return;
        }
        Resource clusterNodesRes = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getClusterInstancesPath());
        Set<String> liveInstances = ViewHelper.determineLiveInstances(clusterNodesRes, this.config);
        View establishedView = ViewHelper.getEstablishedView(resourceResolver, this.config);
        String string = this.lastEstablishedViewId = establishedView == null ? null : establishedView.getResource().getName();
        if (this.lastEstablishedViewId != null && this.failedEstablishedViewId != null && this.lastEstablishedViewId.equals(this.failedEstablishedViewId)) {
            this.logger.info("doCheckView: current establishedViewId ({}) was declared as failed earlier already.", (Object)this.lastEstablishedViewId);
            establishedViewMatches = false;
        } else if (establishedView == null) {
            establishedViewMatches = false;
        } else {
            String mismatchDetails;
            try {
                mismatchDetails = establishedView.matches(liveInstances);
            }
            catch (Exception e) {
                this.logger.error("doCheckViewWith: could not compare established view with live ones: " + e, (Throwable)e);
                this.invalidateCurrentEstablishedView();
                this.discoveryServiceImpl.handleTopologyChanging();
                return;
            }
            if (mismatchDetails != null) {
                this.logger.info("doCheckView: established view does not match. (details: " + mismatchDetails + ")");
            } else {
                this.logger.debug("doCheckView: established view matches with expected.");
            }
            boolean bl = establishedViewMatches = mismatchDetails == null;
        }
        if (establishedViewMatches) {
            this.logger.debug("doCheckViewWith: no pending nor winning votes. view is fine. we're all happy.");
            return;
        }
        this.logger.info("doCheckViewWith: no matching established view, marking topology as changing");
        this.invalidateCurrentEstablishedView();
        this.discoveryServiceImpl.handleTopologyChanging();
        List<VotingView> myYesVotes = VotingHelper.getYesVotingsOf(resourceResolver, this.config, this.slingId);
        if (myYesVotes != null && myYesVotes.size() > 0) {
            this.logger.info("doCheckViewWith: I have voted yes (" + myYesVotes.size() + "x)- the vote was not yet promoted but expecting it to be soon. Not voting again in the meantime. My yes vote was for: " + myYesVotes);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("doCheckViewWith: no pending nor winning votes. But: view does not match established or no established yet. Initiating a new voting");
            Iterator<String> it = liveInstances.iterator();
            while (it.hasNext()) {
                this.logger.debug("doCheckViewWith: one of the live instances is: " + it.next());
            }
        }
        this.doStartNewVoting(resourceResolver, liveInstances);
    }

    private void doStartNewVoting(ResourceResolver resourceResolver, Set<String> liveInstances) throws PersistenceException {
        String votingId = this.nextVotingId;
        this.nextVotingId = UUID.randomUUID().toString();
        VotingView.newVoting(resourceResolver, this.config, votingId, this.slingId, liveInstances);
    }

    public void invalidateCurrentEstablishedView() {
        if (this.lastEstablishedViewId == null) {
            this.logger.info("invalidateCurrentEstablishedView: cannot invalidate, lastEstablishedViewId==null");
            return;
        }
        this.logger.info("invalidateCurrentEstablishedView: invalidating slingId=" + this.slingId + ", lastEstablishedViewId=" + this.lastEstablishedViewId);
        this.failedEstablishedViewId = this.lastEstablishedViewId;
        this.discoveryServiceImpl.getClusterViewServiceImpl().invalidateEstablishedViewId(this.lastEstablishedViewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewVoting() {
        this.logger.info("startNewVoting: explicitly starting new voting...");
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            Resource clusterNodesRes = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getClusterInstancesPath());
            Set<String> liveInstances = ViewHelper.determineLiveInstances(clusterNodesRes, this.config);
            this.doStartNewVoting(resourceResolver, liveInstances);
            this.logger.info("startNewVoting: explicit new voting was started.");
        }
        catch (LoginException e) {
            this.logger.error("startNewVoting: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("startNewVoting: encountered a persistence exception during view check: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    protected void bindVotingHandler(VotingHandler votingHandler) {
        this.votingHandler = votingHandler;
    }

    protected void unbindVotingHandler(VotingHandler votingHandler) {
        if (this.votingHandler == votingHandler) {
            this.votingHandler = null;
        }
    }
}

