/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.ResponseUtil;
import org.apache.sling.engine.SystemStatus;
import org.apache.sling.engine.impl.auth.MissingRepositoryException;
import org.apache.sling.engine.impl.auth.SlingAuthenticator;
import org.apache.sling.engine.impl.filter.RequestSlingFilterChain;
import org.apache.sling.engine.impl.filter.SlingComponentFilterChain;
import org.apache.sling.engine.impl.filter.SlingFilterChainHelper;
import org.apache.sling.engine.impl.helper.SlingFilterConfig;
import org.apache.sling.engine.impl.helper.SlingServletContext;
import org.apache.sling.engine.impl.log.RequestLogger;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.servlets.AbstractServiceReferenceConfig;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingMainServlet
extends GenericServlet
implements ErrorHandler,
HttpContext,
ConfigurationPrinter {
    public static final String PROP_MAX_CALL_COUNTER = "sling.max.calls";
    public static final String PROP_MAX_INCLUSION_COUNTER = "sling.max.inclusions";
    private static final Logger log = LoggerFactory.getLogger(SlingMainServlet.class);
    private static final String SLING_ROOT = "/";
    private static String PRODUCT_NAME = "ApacheSling";
    private static String FILTER_NAME = "Filter";
    private SlingServletContext slingServletContext;
    private ComponentContext osgiComponentContext;
    private List<ServiceReference> delayedComponentFilters;
    private String serverInfo = PRODUCT_NAME;
    private HttpService httpService;
    private JcrResourceResolverFactory resourceResolverFactory;
    private MimeTypeService mimeTypeService;
    private ServletResolver servletResolver;
    private ErrorHandler errorHandler;
    private RequestLogger requestLogger;
    private AdapterManager adapterManager;
    private SystemStatus systemStatus;
    private SlingFilterChainHelper requestFilterChain = new SlingFilterChainHelper();
    private SlingFilterChainHelper innerFilterChain = new SlingFilterChainHelper();
    private SlingAuthenticator slingAuthenticator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            String threadName = this.setThreadName(request);
            try {
                this.service(request, (HttpServletResponse)res);
            }
            catch (IOException ioe) {
                Throwable cause = ioe;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (cause instanceof SocketException) {
                    log.debug("service: Socketexception (Client abort or network problem", (Throwable)ioe);
                }
                log.error("service: Uncaught IO Problem while handling the request", (Throwable)ioe);
            }
            catch (Throwable t) {
                log.error("service: Uncaught Problem handling the request", t);
            }
            finally {
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
            }
        } else {
            throw new ServletException("Apache Sling must be run in an HTTP servlet environment.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        RequestData requestData = new RequestData(this, servletRequest, servletResponse);
        SlingHttpServletRequest request = requestData.getSlingRequest();
        SlingHttpServletResponse response = requestData.getSlingResponse();
        if (this.requestLogger != null) {
            this.requestLogger.logRequestEntry(request, response);
        }
        Session session = null;
        try {
            String errorMessage = null;
            String serviceMissingSuffix = " service missing, cannot service requests";
            if (this.getResourceResolverFactory() == null) {
                errorMessage = "ResourceResolverFactory service missing, cannot service requests";
            } else if (this.getServletResolver() == null) {
                errorMessage = "ServletResolver service missing, cannot service requests";
            } else if (this.mimeTypeService == null) {
                errorMessage = "MimeTypeService service missing, cannot service requests";
            }
            session = (Session)servletRequest.getAttribute("javax.jcr.Session");
            if (session == null) {
                errorMessage = "Missing JCR Session";
            }
            if (errorMessage == null && this.systemStatus != null) {
                try {
                    this.systemStatus.checkSystemReady();
                }
                catch (Exception e) {
                    errorMessage = e.toString();
                }
            }
            if (errorMessage != null) {
                int status = 503;
                log.error("{} , sending status {}", (Object)errorMessage, (Object)503);
                this.sendError(503, errorMessage, null, servletRequest, servletResponse);
                return;
            }
            if ("/system/sling/status".equals(request.getPathInfo()) && this.systemStatus != null) {
                this.systemStatus.doGet(request, response);
                return;
            }
            ResourceResolver resolver = this.getResourceResolverFactory().getResourceResolver(session);
            Resource resource = requestData.initResource(resolver);
            requestData.initServlet(resource);
            Filter[] filters = this.requestFilterChain.getFilters();
            if (filters != null) {
                RequestSlingFilterChain processor = new RequestSlingFilterChain(this, filters);
                request.getRequestProgressTracker().log("Applying request filters");
                processor.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.processRequest(request, response);
            }
        }
        catch (ResourceNotFoundException rnfe) {
            log.info("service: Resource {} not found", (Object)rnfe.getResource());
            this.getErrorHandler().handleError(404, rnfe.getMessage(), request, response);
        }
        catch (SlingException se) {
            if (requestData.getActiveServletName() != null) {
                request.setAttribute("javax.servlet.error.servlet_name", (Object)requestData.getActiveServletName());
            }
            Throwable t = se.getCause() != null ? se.getCause() : se;
            log.error("service: Uncaught SlingException", t);
            this.getErrorHandler().handleError(t, request, response);
        }
        catch (AccessControlException ace) {
            log.info("service: Authenticated user {} does not have enough rights to executed requested action", (Object)request.getRemoteUser());
            this.getErrorHandler().handleError(403, null, request, response);
        }
        catch (Throwable t) {
            if (requestData.getActiveServletName() != null) {
                request.setAttribute("javax.servlet.error.servlet_name", (Object)requestData.getActiveServletName());
            }
            log.error("service: Uncaught Throwable", t);
            this.getErrorHandler().handleError(t, request, response);
        }
        finally {
            if (this.requestLogger != null) {
                this.requestLogger.logRequestExit(request, response);
            }
            requestData.dispose();
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeContent(ServletRequest request, ServletResponse response, Resource resource, RequestPathInfo resolvedURL) throws IOException, ServletException {
        SlingHttpServletRequest cRequest = RequestData.toSlingHttpServletRequest(request);
        SlingHttpServletResponse cResponse = RequestData.toSlingHttpServletResponse(response);
        RequestData requestData = RequestData.getRequestData(cRequest);
        ContentData contentData = requestData.pushContent(resource, resolvedURL);
        try {
            Servlet servlet = this.getServletResolver().resolveServlet(cRequest);
            contentData.setServlet(servlet);
            this.processRequest(cRequest, cResponse);
        }
        finally {
            requestData.popContent();
        }
    }

    public void processRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        Filter[] filters = this.innerFilterChain.getFilters();
        if (filters != null) {
            SlingComponentFilterChain processor = new SlingComponentFilterChain(filters);
            request.getRequestProgressTracker().log("Applying inner filters");
            processor.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            log.debug("service: No Resource level filters, calling servlet");
            RequestData.service(request, response);
        }
    }

    @Override
    public void handleError(int status, String message, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        message = message == null ? "HTTP ERROR:" + String.valueOf(status) : "HTTP ERROR:" + status + " - " + message;
        this.sendError(status, message, null, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Override
    public void handleError(Throwable throwable, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        this.sendError(500, throwable.getMessage(), throwable, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    private void sendError(int status, String message, Throwable throwable, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            log.error("handleError: Response already committed; cannot send error " + status + message, throwable);
        } else {
            String servletName = (String)request.getAttribute("javax.servlet.error.servlet_name");
            String requestURI = (String)request.getAttribute("javax.servlet.error.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            response.reset();
            response.setStatus(status);
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter pw = response.getWriter();
            pw.println("<html><head><title>");
            pw.println(ResponseUtil.escapeXml(message));
            pw.println("</title></head><body><h1>");
            if (throwable != null) {
                pw.println(ResponseUtil.escapeXml(throwable.toString()));
            } else if (message != null) {
                pw.println(ResponseUtil.escapeXml(message));
            } else {
                pw.println("Internal error (no Exception to report)");
            }
            pw.println("</h1><p>");
            pw.println("RequestURI=" + ResponseUtil.escapeXml(request.getRequestURI()));
            if (servletName != null) {
                pw.println("</p>Servlet=" + servletName + "<p>");
            }
            pw.println("</p>");
            if (throwable != null) {
                pw.println("<h3>Exception stacktrace:</h3>");
                pw.println("<pre>");
                throwable.printStackTrace(pw);
                pw.println("</pre>");
                RequestProgressTracker tracker = ((SlingHttpServletRequest)request).getRequestProgressTracker();
                pw.println("<h3>Request Progress:</h3>");
                pw.println("<pre>");
                tracker.dump(pw);
                pw.println("</pre>");
            }
            pw.println("<hr /><address>");
            pw.println(this.getServerInfo());
            pw.println("</address></body></html>");
            response.flushBuffer();
        }
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public BundleContext getBundleContext() {
        return this.osgiComponentContext.getBundleContext();
    }

    public SlingAuthenticator getSlingAuthenticator() {
        return this.slingAuthenticator;
    }

    public JcrResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    public ServletResolver getServletResolver() {
        return this.servletResolver;
    }

    public ErrorHandler getErrorHandler() {
        ErrorHandler eh = this.errorHandler;
        return eh != null ? eh : this;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        List<ServiceReference> filterList;
        this.osgiComponentContext = componentContext;
        BundleContext bundleContext = componentContext.getBundleContext();
        Dictionary props = bundleContext.getBundle().getHeaders();
        Version bundleVersion = Version.parseVersion((String)((String)props.get("Bundle-Version")));
        String productVersion = bundleVersion.getMajor() + "." + bundleVersion.getMinor();
        this.serverInfo = PRODUCT_NAME + SLING_ROOT + productVersion + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")";
        Hashtable configuration = new Hashtable();
        Dictionary componentConfig = componentContext.getProperties();
        Enumeration cce = componentConfig.keys();
        while (cce.hasMoreElements()) {
            Object key = cce.nextElement();
            configuration.put(String.valueOf(key), componentConfig.get(key));
        }
        if (!(configuration.get("servlet-name") instanceof String)) {
            configuration.put("servlet-name", PRODUCT_NAME + " " + productVersion);
        }
        RequestData.setMaxIncludeCounter(OsgiUtil.toInteger(componentConfig.get(PROP_MAX_INCLUSION_COUNTER), (int)50));
        RequestData.setMaxCallCounter(OsgiUtil.toInteger(componentConfig.get(PROP_MAX_CALL_COUNTER), (int)1000));
        this.slingAuthenticator = new SlingAuthenticator(bundleContext);
        try {
            Dictionary<String, String> servletConfig = this.toStringConfig(configuration);
            this.httpService.registerServlet(SLING_ROOT, (Servlet)this, servletConfig, (HttpContext)this);
            log.info("{} ready to serve requests", (Object)this.getServerInfo());
        }
        catch (Exception e) {
            log.error("Cannot register " + this.getServerInfo(), (Throwable)e);
        }
        SlingServletContext tmpServletContext = new SlingServletContext(this);
        SlingMainServlet slingMainServlet = this;
        synchronized (slingMainServlet) {
            filterList = this.delayedComponentFilters;
            this.slingServletContext = tmpServletContext;
            this.delayedComponentFilters = null;
        }
        if (filterList != null) {
            for (ServiceReference serviceReference : filterList) {
                this.initFilter(componentContext, serviceReference);
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.destroyFilters(this.innerFilterChain);
        this.destroyFilters(this.requestFilterChain);
        if (this.slingServletContext != null) {
            this.slingServletContext.dispose();
            this.slingServletContext = null;
        }
        this.httpService.unregister(SLING_ROOT);
        if (this.slingAuthenticator != null) {
            this.slingAuthenticator.dispose();
            this.slingAuthenticator = null;
        }
        this.osgiComponentContext = null;
        log.info(this.getServerInfo() + " shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindFilter(ServiceReference ref) {
        SlingMainServlet slingMainServlet = this;
        synchronized (slingMainServlet) {
            if (this.slingServletContext == null) {
                if (this.delayedComponentFilters == null) {
                    this.delayedComponentFilters = new ArrayList<ServiceReference>();
                }
                this.delayedComponentFilters.add(ref);
            } else {
                this.initFilter(this.osgiComponentContext, ref);
            }
        }
    }

    protected void unbindFilter(ServiceReference ref) {
        Object serviceId = ref.getProperty("service.id");
        Filter filter = this.getChain(ref).removeFilterById(serviceId);
        if (filter != null) {
            try {
                filter.destroy();
            }
            catch (Throwable t) {
                log.error("Unexpected problem destroying ComponentFilter {}", (Object)filter, (Object)t);
            }
        }
    }

    private void initFilter(ComponentContext osgiContext, ServiceReference ref) {
        Filter filter = (Filter)osgiContext.locateService(FILTER_NAME, ref);
        String filterName = AbstractServiceReferenceConfig.getName(ref);
        if (filterName == null) {
            log.error("initFilter: Missing name for filter {}", (Object)ref);
            return;
        }
        try {
            SlingFilterConfig config = new SlingFilterConfig(this.slingServletContext, ref, filterName);
            filter.init((FilterConfig)config);
            Long serviceId = (Long)ref.getProperty("service.id");
            Object orderObj = ref.getProperty("filter.order");
            int order = orderObj instanceof Integer ? (Integer)orderObj : Integer.MAX_VALUE;
            this.getChain(ref).addFilter(filter, serviceId, order);
        }
        catch (ServletException ce) {
            log.error("Filter " + filterName + " failed to initialize", (Throwable)ce);
        }
        catch (Throwable t) {
            log.error("Unexpected Problem initializing ComponentFilter ", t);
        }
    }

    private void destroyFilters(SlingFilterChainHelper chain) {
        Filter[] filters = chain.removeAllFilters();
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                try {
                    filters[i].destroy();
                    continue;
                }
                catch (Throwable t) {
                    log.error("Unexpected problem destroying ComponentFilter {}", (Object)filters[i], (Object)t);
                }
            }
        }
    }

    private SlingFilterChainHelper getChain(ServiceReference ref) {
        Object scope = ref.getProperty("filter.scope");
        if ("component".equals(scope)) {
            return this.innerFilterChain;
        }
        return this.requestFilterChain;
    }

    private Dictionary<String, String> toStringConfig(Dictionary<?, ?> config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration<?> ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    public String getMimeType(String name) {
        MimeTypeService mtservice = this.mimeTypeService;
        if (mtservice != null) {
            return mtservice.getMimeType(name);
        }
        log.debug("getMimeType: MimeTypeService not available, cannot resolve mime type for {}", (Object)name);
        return null;
    }

    public URL getResource(String name) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SlingAuthenticator authenticator = this.slingAuthenticator;
        if (authenticator != null) {
            try {
                request = new HttpServletRequestWrapper((HttpServletRequest)request){

                    public String getParameter(String name) {
                        return this.getParameterSupport().getParameter(name);
                    }

                    public Map<String, String[]> getParameterMap() {
                        return this.getParameterSupport().getParameterMap();
                    }

                    public Enumeration<String> getParameterNames() {
                        return this.getParameterSupport().getParameterNames();
                    }

                    public String[] getParameterValues(String name) {
                        return this.getParameterSupport().getParameterValues(name);
                    }

                    private ParameterSupport getParameterSupport() {
                        return ParameterSupport.getInstance(this.getRequest());
                    }
                };
                return authenticator.authenticate((HttpServletRequest)request, response);
            }
            catch (MissingRepositoryException mre) {
                log.error("handleSecurity: Cannot authenticate request: " + mre.getMessage());
                log.debug("handleSecurity: Reason", (Throwable)((Object)mre));
                response.sendError(503, "Cannot handle requests due to missing Repository");
            }
        } else {
            response.sendError(503, "Sling not ready to serve requests");
        }
        return false;
    }

    private String setThreadName(HttpServletRequest request) {
        Thread thread = Thread.currentThread();
        String oldThreadName = thread.getName();
        StringBuffer buf = new StringBuffer();
        buf.append(request.getRemoteAddr());
        buf.append(" [").append(System.currentTimeMillis()).append("] ");
        buf.append(request.getMethod()).append(' ');
        buf.append(request.getRequestURI()).append(' ');
        buf.append(request.getProtocol());
        thread.setName(buf.toString());
        return oldThreadName;
    }

    public String getTitle() {
        return "Servlet Filter";
    }

    private void printFilterChain(PrintWriter pw, SlingFilterChainHelper.FilterListEntry[] entries) {
        if (entries == null) {
            pw.println("---");
        } else {
            for (SlingFilterChainHelper.FilterListEntry entry : entries) {
                pw.print(entry.getOrder());
                pw.print(" : ");
                pw.print(entry.getFilter().getClass());
                pw.print(" (");
                pw.print(entry.getFitlerId());
                pw.println(")");
            }
        }
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Servlet Filter Configuration");
        pw.println();
        pw.println("Request Filters:");
        this.printFilterChain(pw, this.requestFilterChain.getFilterListEntries());
        pw.println();
        pw.println("Component Filters:");
        this.printFilterChain(pw, this.innerFilterChain.getFilterListEntries());
    }

    protected void bindAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    protected void unbindAdapterManager(AdapterManager adapterManager) {
        if (this.adapterManager == adapterManager) {
            this.adapterManager = null;
        }
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resourceResolverFactory == jcrResourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSystemStatus(SystemStatus systemStatus) {
        this.systemStatus = systemStatus;
    }

    protected void unbindSystemStatus(SystemStatus systemStatus) {
        if (this.systemStatus == systemStatus) {
            this.systemStatus = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindRequestLogger(RequestLogger requestLogger) {
        this.requestLogger = requestLogger;
    }

    protected void unbindRequestLogger(RequestLogger requestLogger) {
        if (this.requestLogger == requestLogger) {
            this.requestLogger = null;
        }
    }

    protected void bindErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void unbindErrorHandler(ErrorHandler errorHandler) {
        if (this.errorHandler == errorHandler) {
            this.errorHandler = null;
        }
    }

    protected void bindServletResolver(ServletResolver servletResolver) {
        this.servletResolver = servletResolver;
    }

    protected void unbindServletResolver(ServletResolver servletResolver) {
        if (this.servletResolver == servletResolver) {
            this.servletResolver = null;
        }
    }
}

