/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.sling.engine.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingSettingsServiceImpl
implements SlingSettingsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String slingId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlingSettingsServiceImpl(BundleContext context) {
        File idFile = context.getDataFile("sling.id.file");
        if (idFile == null) {
            throw new RuntimeException("Unable to read from bundle data file.");
        }
        if (idFile.exists() && idFile.length() >= 36L) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(idFile);
                byte[] rawBytes = new byte[36];
                if (fin.read(rawBytes) == 36) {
                    String rawString = new String(rawBytes, "ISO-8859-1");
                    this.slingId = UUID.fromString(rawString).toString();
                }
            }
            catch (Throwable t) {
                this.logger.error("Failed reading UUID from id file " + idFile + ", creating new id", t);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (this.slingId == null) {
            this.slingId = UUID.randomUUID().toString();
            idFile.delete();
            idFile.getParentFile().mkdirs();
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(idFile);
                fout.write(this.slingId.getBytes("ISO-8859-1"));
                fout.flush();
            }
            catch (Throwable t) {
                this.logger.error("Failed writing UUID to id file " + idFile, t);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    public String getSlingId() {
        return this.slingId;
    }
}

