/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.auth;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.engine.auth.Authenticator;
import org.apache.sling.engine.auth.NoAuthenticationHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -8797082194403667968L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Authenticator authenticator;
    public static final String LOGIN_SERVLET_PATH = "/system/sling/login";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Authenticator authenticator = this.authenticator;
        if (authenticator != null) {
            try {
                authenticator.login((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IllegalStateException ise) {
                this.log.error("doGet: Response already committed, cannot login");
                return;
            }
            catch (NoAuthenticationHandlerException nahe) {
                this.log.error("doGet: No AuthenticationHandler to login registered");
            }
        } else {
            this.log.error("doGet: Authenticator service missing, cannot request authentication");
        }
        response.sendError(403, "Cannot login");
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.sendRedirect(request.getRequestURI());
    }

    protected void bindAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected void unbindAuthenticator(Authenticator authenticator) {
        if (this.authenticator == authenticator) {
            this.authenticator = null;
        }
    }
}

