/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.engine.impl.parameters.AbstractRequestParameter;
import org.apache.sling.engine.impl.parameters.ParameterMap;

class Util {
    public static final String PARAMETER_FORMENCODING = "_charset_";
    public static final String ENCODING_DIRECT = "ISO-8859-1";
    public static final String ENCODING_DEFAULT = "UTF-8";
    public static final byte[] NO_CONTENT = new byte[0];

    Util() {
    }

    static String toIdentityEncodedString(byte[] data) {
        if (data == null) {
            return null;
        }
        char[] characters = new char[data.length];
        for (int i = 0; i < characters.length; ++i) {
            characters[i] = (char)(data[i] & 0xFF);
        }
        return new String(characters);
    }

    static byte[] fromIdentityEncodedString(String string) {
        if (string == null) {
            return NO_CONTENT;
        }
        byte[] data = new byte[string.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(string.charAt(i) & 0xFF);
        }
        return data;
    }

    static InputStream getInputStream(String source) {
        byte[] data = Util.fromIdentityEncodedString(source);
        return new ByteArrayInputStream(data);
    }

    static void fixEncoding(ParameterMap parameterMap) {
        String formEncoding = ENCODING_DIRECT;
        RequestParameter[] feParm = (RequestParameter[])parameterMap.get(PARAMETER_FORMENCODING);
        if (feParm != null) {
            byte[] rawEncoding = feParm[0].get();
            formEncoding = Util.toIdentityEncodedString(rawEncoding);
            try {
                "".getBytes(formEncoding);
            }
            catch (UnsupportedEncodingException e) {
                formEncoding = ENCODING_DIRECT;
            }
        }
        HashMap<String, String> renameMap = new HashMap<String, String>();
        for (Map.Entry paramEntry : parameterMap.entrySet()) {
            RequestParameter[] params = (RequestParameter[])paramEntry.getValue();
            String parName = null;
            for (int i = 0; i < params.length; ++i) {
                String name;
                AbstractRequestParameter param;
                if (!(params[i] instanceof AbstractRequestParameter) || formEncoding.equals((param = (AbstractRequestParameter)params[i]).getEncoding())) continue;
                param.setEncoding(formEncoding);
                if (parName != null || (parName = (String)paramEntry.getKey()).equals(name = Util.reencode(parName, formEncoding))) continue;
                renameMap.put(parName, name);
            }
        }
        if (!renameMap.isEmpty()) {
            for (Map.Entry entry : renameMap.entrySet()) {
                parameterMap.renameParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static String reencode(String parName, String encoding) {
        if (!ENCODING_DIRECT.equals(encoding)) {
            try {
                return new String(parName.getBytes(ENCODING_DIRECT), encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return parName;
    }
}

