/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.engine.impl.output.Buffer;
import org.apache.sling.engine.impl.output.BufferProvider;
import org.apache.sling.engine.impl.output.BufferedPrintWriter;
import org.apache.sling.engine.impl.output.BufferedServletOutputStream;

public class ContentData
implements BufferProvider {
    private RequestPathInfo requestPathInfo;
    private Resource resource;
    private Servlet servlet;
    private Buffer buffer;
    private int requestedBufferSize;
    private BufferProvider parent;

    public ContentData(Resource resource, RequestPathInfo requestPathInfo, BufferProvider parent) {
        this.resource = resource;
        this.requestPathInfo = requestPathInfo;
        this.parent = parent;
    }

    void dispose() {
        this.requestPathInfo = null;
        try {
            this.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public RequestPathInfo getRequestPathInfo() {
        return this.requestPathInfo;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public void setBufferSize(int buffersize) {
        if (this.buffer != null) {
            this.buffer.setBufferSize(buffersize);
        }
        this.requestedBufferSize = buffersize;
    }

    public int getBufferSize() {
        if (this.buffer != null) {
            return this.buffer.getBufferSize();
        }
        return this.requestedBufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.buffer != null) {
            this.buffer.flushBuffer();
        }
    }

    public void resetBuffer() {
        if (this.buffer != null) {
            this.buffer.resetBuffer();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.buffer instanceof OutputStream) {
            return (ServletOutputStream)this.buffer;
        }
        if (this.buffer != null) {
            throw new IllegalStateException("Writer already retrieved");
        }
        ServletOutputStream parentStream = this.parent.getOutputStream();
        BufferedServletOutputStream stream = new BufferedServletOutputStream((OutputStream)parentStream, this.getBufferSize());
        this.buffer = stream;
        return stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.buffer instanceof PrintWriter) {
            return (PrintWriter)((Object)this.buffer);
        }
        if (this.buffer != null) {
            throw new IllegalStateException("OutputStream already retrieved");
        }
        PrintWriter parentWriter = this.parent.getWriter();
        BufferedPrintWriter writer = new BufferedPrintWriter(parentWriter, this.getBufferSize());
        this.buffer = writer;
        return writer;
    }
}

