/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.SlingRequestPathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingRequestDispatcher
implements RequestDispatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Resource resource;
    private RequestDispatcherOptions options;
    private String path;

    public SlingRequestDispatcher(String path, RequestDispatcherOptions options) {
        this.path = path;
        this.options = options;
        this.resource = null;
    }

    public SlingRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        this.resource = resource;
        this.options = options;
        this.path = resource.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse sResponse) throws ServletException, IOException {
        this.dispatch(request, sResponse);
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        response.reset();
        this.dispatch(request, response);
        response.flushBuffer();
    }

    private String getAbsolutePath(SlingHttpServletRequest request, String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String uri = request.getResource().getPath();
        int lastSlash = uri.lastIndexOf(47);
        if (lastSlash >= 0) {
            uri = uri.substring(0, lastSlash);
        }
        return uri + '/' + path;
    }

    private void dispatch(ServletRequest request, ServletResponse sResponse) throws ServletException, IOException {
        SlingHttpServletRequest cRequest = RequestData.unwrap(request);
        RequestData rd = RequestData.getRequestData(cRequest);
        String absPath = this.getAbsolutePath(cRequest, this.path);
        if (!(sResponse instanceof HttpServletResponse)) {
            this.log.error("include: Failed to include {}, response has wrong type", (Object)absPath);
            return;
        }
        HttpServletResponse response = (HttpServletResponse)sResponse;
        if (this.resource == null) {
            this.resource = cRequest.getResourceResolver().resolve(absPath);
            if (this.resource == null) {
                this.log.error("include: Could not resolve {} to a resource, not including", (Object)absPath);
                return;
            }
        }
        SlingRequestPathInfo info = new SlingRequestPathInfo(this.resource);
        info = info.merge(cRequest.getRequestPathInfo());
        if (this.options != null) {
            info = info.merge(this.options);
            String rtOverwrite = this.options.getForceResourceType();
            if (rtOverwrite != null && !rtOverwrite.equals(this.resource.getResourceType())) {
                this.resource = new TypeOverwritingResourceWrapper(this.resource, rtOverwrite);
            }
        }
        cRequest.getRequestProgressTracker().log("Including resource {0} ({1})", new Object[]{this.resource, info});
        rd.getSlingMainServlet().includeContent(request, (ServletResponse)response, this.resource, info);
    }

    private static class TypeOverwritingResourceWrapper
    extends ResourceWrapper {
        private static final String UNSET_RESOURCE_SUPER_TYPE = "<unset>";
        private final String resourceType;
        private String resourceSuperType;

        TypeOverwritingResourceWrapper(Resource delegatee, String resourceType) {
            super(delegatee);
            this.resourceType = resourceType;
            this.resourceSuperType = UNSET_RESOURCE_SUPER_TYPE;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getResourceSuperType() {
            if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
                this.resourceSuperType = ResourceUtil.getResourceSuperType((ResourceResolver)this.getResourceResolver(), (String)this.resourceType);
            }
            return this.resourceSuperType;
        }
    }
}

