/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.impl.helper.NullResourceBundle;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.RequestHistoryConsolePlugin;
import org.apache.sling.engine.impl.request.SlingRequestDispatcher;
import org.osgi.service.useradmin.Authorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingHttpServletRequestImpl
extends HttpServletRequestWrapper
implements SlingHttpServletRequest {
    private final RequestData requestData;
    private final String pathInfo;
    private String responseContentType;

    public SlingHttpServletRequestImpl(RequestData requestData, HttpServletRequest servletRequest) {
        super(servletRequest);
        this.requestData = requestData;
        String pathInfo = servletRequest.getServletPath();
        if (servletRequest.getPathInfo() != null) {
            pathInfo = pathInfo.concat(servletRequest.getPathInfo());
        }
        this.pathInfo = pathInfo;
        RequestHistoryConsolePlugin.recordRequest(this);
    }

    public final RequestData getRequestData() {
        return this.requestData;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        AdapterManager adapterManager = this.getRequestData().getAdapterManager();
        if (adapterManager != null) {
            return (AdapterType)adapterManager.getAdapter((Object)this, type);
        }
        return null;
    }

    ParameterSupport getParameterSupport() {
        return this.getRequestData().getParameterSupport();
    }

    public Resource getResource() {
        return this.getRequestData().getContentData().getResource();
    }

    public ResourceResolver getResourceResolver() {
        return this.getRequestData().getResourceResolver();
    }

    public RequestProgressTracker getRequestProgressTracker() {
        return this.getRequestData().getRequestProgressTracker();
    }

    public RequestDispatcher getRequestDispatcher(Resource resource) {
        return this.getRequestDispatcher(resource, null);
    }

    public RequestDispatcher getRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        return resource != null ? new SlingRequestDispatcher(resource, options) : null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.getRequestDispatcher(path, null);
    }

    public RequestDispatcher getRequestDispatcher(String path, RequestDispatcherOptions options) {
        return path != null ? new SlingRequestDispatcher(path, options) : null;
    }

    public String getParameter(String name) {
        return this.getParameterSupport().getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.getParameterSupport().getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this.getParameterSupport().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.getParameterSupport().getParameterValues(name);
    }

    public RequestParameter getRequestParameter(String name) {
        return this.getParameterSupport().getRequestParameter(name);
    }

    public RequestParameter[] getRequestParameters(String name) {
        return this.getParameterSupport().getRequestParameters(name);
    }

    public RequestParameterMap getRequestParameterMap() {
        return this.getParameterSupport().getRequestParameterMap();
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public RequestPathInfo getRequestPathInfo() {
        return this.getRequestData().getContentData().getRequestPathInfo();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = this.getLocale();
        }
        return new NullResourceBundle(locale);
    }

    public String getResponseContentType() {
        if (this.responseContentType == null) {
            String ext = this.getRequestPathInfo().getExtension();
            this.responseContentType = this.requestData.getSlingMainServlet().getServletContext().getMimeType("dummy." + ext);
        }
        return this.responseContentType;
    }

    public Enumeration<String> getResponseContentTypes() {
        ArrayList<String> result = new ArrayList<String>();
        String singleType = this.getResponseContentType();
        if (singleType != null) {
            result.add(singleType);
        }
        return Collections.enumeration(result);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getRequestData().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        return this.getRequestData().getReader();
    }

    public Principal getUserPrincipal() {
        String remoteUser = this.getRemoteUser();
        return remoteUser != null ? new UserPrincipal(remoteUser) : null;
    }

    public boolean isUserInRole(String role) {
        Object authorization = this.getAttribute("org.osgi.service.useradmin.authorization");
        return authorization instanceof Authorization ? ((Authorization)authorization).hasRole(role) : false;
    }

    public String getServletPath() {
        return "";
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    private static class UserPrincipal
    implements Principal,
    Serializable {
        private final String name;

        public UserPrincipal(String name) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException("name can not be null");
            }
            this.name = name;
        }

        public String toString() {
            return "UserPrincipal: " + this.name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UserPrincipal) {
                UserPrincipal other = (UserPrincipal)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }
    }
}

