/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.debug;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProgressTrackerLogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestProgressTrackerLogFilter.class);
    private int requestCounter;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        if (request instanceof SlingHttpServletRequest) {
            RequestProgressTracker t = ((SlingHttpServletRequest)request).getRequestProgressTracker();
            t.done();
            if (log.isDebugEnabled()) {
                int requestId = 0;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    requestId = ++this.requestCounter;
                }
                Iterator it = t.getMessages();
                while (it.hasNext()) {
                    log.debug("REQUEST_{} - " + (String)it.next(), (Object)requestId);
                }
            }
        }
    }

    public void destroy() {
    }
}

