/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.net.SocketException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.engine.impl.SlingHttpContext;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.WebConsoleConfigPrinter;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.apache.sling.engine.impl.helper.RequestListenerManager;
import org.apache.sling.engine.impl.helper.SlingServletContext;
import org.apache.sling.engine.impl.log.RequestLogger;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.RequestHistoryConsolePlugin;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingMainServlet
extends GenericServlet {
    public static final String PROP_MAX_CALL_COUNTER = "sling.max.calls";
    public static final String PROP_MAX_INCLUSION_COUNTER = "sling.max.inclusions";
    public static final boolean DEFAULT_ALLOW_TRACE = false;
    public static final String PROP_ALLOW_TRACE = "sling.trace.allow";
    public static final boolean DEFAULT_FILTER_COMPAT_MODE = false;
    public static final String PROP_FILTER_COMPAT_MODE = "sling.filter.compat.mode";
    private static final String PROP_MAX_RECORD_REQUESTS = "sling.max.record.requests";
    private static final String PROP_DEFAULT_PARAMETER_ENCODING = "sling.default.parameter.encoding";
    private HttpService httpService;
    private AdapterManager adapterManager;
    private final Logger log = LoggerFactory.getLogger(SlingMainServlet.class);
    private static final String SLING_ROOT = "/";
    static String PRODUCT_NAME = "ApacheSling";
    private SlingServletContext slingServletContext;
    private String serverInfo = PRODUCT_NAME;
    private RequestListenerManager requestListenerManager;
    private boolean allowTrace = false;
    private Object printerRegistration;
    private SlingHttpContext slingHttpContext = new SlingHttpContext();
    private ServletFilterManager filterManager;
    private final SlingRequestProcessorImpl requestProcessor = new SlingRequestProcessorImpl();
    private ServiceRegistration requestProcessorRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            String threadName = this.setThreadName(request);
            this.requestListenerManager.sendEvent(request, SlingRequestEvent.EventType.EVENT_INIT);
            ResourceResolver resolver = null;
            try {
                if (!this.allowTrace && "TRACE".equals(request.getMethod())) {
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.setStatus(405);
                    response.setHeader("Allow", "GET, HEAD, POST, PUT, DELETE, OPTIONS");
                    return;
                }
                Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
                resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
                this.requestProcessor.processRequest(request, (HttpServletResponse)res, resolver);
            }
            catch (IOException ioe) {
                Throwable cause = ioe;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (cause instanceof SocketException) {
                    this.log.debug("service: Socketexception (Client abort or network problem", (Throwable)ioe);
                }
                this.log.error("service: Uncaught IO Problem while handling the request", (Throwable)ioe);
            }
            catch (Throwable t) {
                this.log.error("service: Uncaught Problem handling the request", t);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
                this.requestListenerManager.sendEvent(request, SlingRequestEvent.EventType.EVENT_DESTROY);
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
            }
        } else {
            throw new ServletException("Apache Sling must be run in an HTTP servlet environment.");
        }
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    protected void activate(BundleContext bundleContext, Map<String, Object> componentConfig) {
        Dictionary props = bundleContext.getBundle().getHeaders();
        Version bundleVersion = Version.parseVersion((String)((String)props.get("Bundle-Version")));
        String productVersion = bundleVersion.getMajor() + "." + bundleVersion.getMinor();
        this.serverInfo = PRODUCT_NAME + SLING_ROOT + productVersion + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")";
        this.requestProcessor.setServerInfo(this.serverInfo);
        Hashtable<String, Object> configuration = new Hashtable<String, Object>(componentConfig);
        if (!(configuration.get("servlet-name") instanceof String)) {
            configuration.put("servlet-name", PRODUCT_NAME + " " + productVersion);
        }
        this.allowTrace = OsgiUtil.toBoolean((Object)componentConfig.get(PROP_ALLOW_TRACE), (boolean)false);
        RequestData.setMaxIncludeCounter(OsgiUtil.toInteger((Object)componentConfig.get(PROP_MAX_INCLUSION_COUNTER), (int)50));
        RequestData.setMaxCallCounter(OsgiUtil.toInteger((Object)componentConfig.get(PROP_MAX_CALL_COUNTER), (int)1000));
        RequestData.setSlingMainServlet(this);
        ParameterSupport.setDefaultParameterEncoding(OsgiUtil.toString((Object)componentConfig.get(PROP_DEFAULT_PARAMETER_ENCODING), null));
        try {
            Dictionary<String, String> servletConfig = this.toStringConfig(configuration);
            this.httpService.registerServlet(SLING_ROOT, (Servlet)this, servletConfig, (HttpContext)this.slingHttpContext);
            this.log.info("{} ready to serve requests", (Object)this.getServerInfo());
        }
        catch (Exception e) {
            this.log.error("Cannot register " + this.getServerInfo(), (Throwable)e);
        }
        this.slingServletContext = new SlingServletContext(bundleContext, this);
        this.filterManager = new ServletFilterManager(bundleContext, this.slingServletContext, OsgiUtil.toBoolean((Object)componentConfig.get(PROP_FILTER_COMPAT_MODE), (boolean)false));
        this.filterManager.open();
        this.requestProcessor.setFilterManager(this.filterManager);
        this.requestListenerManager = new RequestListenerManager(bundleContext, this.slingServletContext);
        this.printerRegistration = WebConsoleConfigPrinter.register(bundleContext, this.filterManager);
        try {
            int maxRequests = OsgiUtil.toInteger((Object)componentConfig.get(PROP_MAX_RECORD_REQUESTS), (int)20);
            RequestHistoryConsolePlugin.initPlugin(bundleContext, maxRequests);
        }
        catch (Throwable t) {
            this.log.debug("Unable to register web console request recorder plugin.", t);
        }
        Hashtable<String, String> srpProps = new Hashtable<String, String>();
        srpProps.put("service.vendor", "The Apache Software Foundation");
        srpProps.put("service.description", "Sling Request Processor");
        this.requestProcessorRegistration = bundleContext.registerService(SlingRequestProcessor.NAME, (Object)this.requestProcessor, srpProps);
    }

    protected void deactivate() {
        if (this.requestProcessorRegistration != null) {
            this.requestProcessorRegistration.unregister();
            this.requestProcessorRegistration = null;
        }
        try {
            RequestHistoryConsolePlugin.destroyPlugin();
        }
        catch (Throwable t) {
            this.log.debug("Problem unregistering web console request recorder plugin.", t);
        }
        if (this.printerRegistration != null) {
            WebConsoleConfigPrinter.unregister(this.printerRegistration);
            this.printerRegistration = null;
        }
        if (this.filterManager != null) {
            this.requestProcessor.setFilterManager(null);
            this.filterManager.close();
        }
        if (this.slingServletContext != null) {
            this.slingServletContext.dispose();
            this.slingServletContext = null;
        }
        this.httpService.unregister(SLING_ROOT);
        if (this.requestListenerManager != null) {
            this.requestListenerManager.dispose();
            this.requestListenerManager = null;
        }
        RequestData.setSlingMainServlet(null);
        this.log.info(this.getServerInfo() + " shut down");
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.setErrorHandler(errorHandler);
    }

    void unsetErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.unsetErrorHandler(errorHandler);
    }

    public void setServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.setServletResolver(servletResolver);
    }

    public void unsetServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.unsetServletResolver(servletResolver);
    }

    public void setRequestLogger(RequestLogger requestLogger) {
        this.requestProcessor.setRequestLogger(requestLogger);
    }

    public void unsetRequestLogger(RequestLogger requestLogger) {
        this.requestProcessor.unsetRequestLogger(requestLogger);
    }

    public void setMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.setMimeTypeService(mimeTypeService);
    }

    public void unsetMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.unsetMimeTypeService(mimeTypeService);
    }

    public void setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.setAuthenticationSupport(authenticationSupport);
    }

    public void unsetAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.unsetAuthenticationSupport(authenticationSupport);
    }

    private Dictionary<String, String> toStringConfig(Dictionary<?, ?> config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration<?> ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    public String getMimeType(String name) {
        return this.slingHttpContext.getMimeType(name);
    }

    public <Type> Type adaptTo(Object object, Class<Type> type) {
        AdapterManager adapterManager = this.adapterManager;
        if (adapterManager != null) {
            return (Type)adapterManager.getAdapter(object, type);
        }
        return null;
    }

    private String setThreadName(HttpServletRequest request) {
        Thread thread = Thread.currentThread();
        String oldThreadName = thread.getName();
        StringBuffer buf = new StringBuffer();
        buf.append(request.getRemoteAddr());
        buf.append(" [").append(System.currentTimeMillis()).append("] ");
        buf.append(request.getMethod()).append(' ');
        buf.append(request.getRequestURI()).append(' ');
        buf.append(request.getProtocol());
        thread.setName(buf.toString());
        return oldThreadName;
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    protected void unbindAdapterManager(AdapterManager adapterManager) {
        if (this.adapterManager == adapterManager) {
            this.adapterManager = null;
        }
    }
}

