/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.request.SlingRequestListener;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class RequestListenerManager {
    private final ServiceTracker serviceTracker;
    private final ServletContext servletContext;

    public RequestListenerManager(BundleContext context, ServletContext servletContext) {
        this.serviceTracker = new ServiceTracker(context, "org.apache.sling.api.request.SlingRequestListener", null);
        this.serviceTracker.open();
        this.servletContext = servletContext;
    }

    public void sendEvent(HttpServletRequest request, SlingRequestEvent.EventType type) {
        Object[] services = this.serviceTracker.getServices();
        if (services != null && services.length > 0) {
            SlingRequestEvent event = new SlingRequestEvent(this.servletContext, (ServletRequest)request, type);
            for (Object service : services) {
                ((SlingRequestListener)service).onEvent(event);
            }
        }
    }

    public void dispose() {
        this.serviceTracker.close();
    }
}

