/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterMap
extends LinkedHashMap<String, RequestParameter[]>
implements RequestParameterMap {
    private static final long serialVersionUID = -3984737679401682171L;
    private Map<String, String[]> stringParameterMap;

    ParameterMap() {
    }

    public RequestParameter getValue(String name) {
        RequestParameter[] params = this.getValues(name);
        return params != null && params.length > 0 ? params[0] : null;
    }

    public RequestParameter[] getValues(String name) {
        return (RequestParameter[])super.get(name);
    }

    void renameParameter(String oldName, String newName) {
        RequestParameter[] params = (RequestParameter[])super.remove(oldName);
        super.put(newName, params);
    }

    void addParameter(String name, RequestParameter parameter) {
        Object current = this.get(name);
        if (current == null) {
            super.put(name, new RequestParameter[]{parameter});
        } else {
            RequestParameter[] ppo = (RequestParameter[])current;
            RequestParameter[] ppn = new RequestParameter[ppo.length + 1];
            System.arraycopy(ppo, 0, ppn, 0, ppo.length);
            ppn[ppo.length] = parameter;
            super.put(name, ppn);
        }
    }

    void setParameters(String name, RequestParameter[] parameters) {
        super.put(name, parameters);
    }

    String getStringValue(String name) {
        RequestParameter param = this.getValue(name);
        return param != null ? param.getString() : null;
    }

    String[] getStringValues(String name) {
        return ParameterMap.toStringArray(this.getValues(name));
    }

    Map<String, String[]> getStringParameterMap() {
        if (this.stringParameterMap == null) {
            LinkedHashMap pm = new LinkedHashMap();
            for (Map.Entry ppmEntry : this.entrySet()) {
                pm.put(ppmEntry.getKey(), ParameterMap.toStringArray((RequestParameter[])ppmEntry.getValue()));
            }
            this.stringParameterMap = Collections.unmodifiableMap(pm);
        }
        return this.stringParameterMap;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public RequestParameter[] put(String key, RequestParameter[] value) {
        throw new UnsupportedOperationException("put");
    }

    @Override
    public void putAll(Map<? extends String, ? extends RequestParameter[]> t) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public RequestParameter[] remove(Object key) {
        throw new UnsupportedOperationException("remove");
    }

    private static String[] toStringArray(RequestParameter[] params) {
        if (params == null) {
            return null;
        }
        String[] ps = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            ps[i] = params[i].getString();
        }
        return ps;
    }
}

