/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.engine.impl.parameters.ContainerRequestParameter;
import org.apache.sling.engine.impl.parameters.MultipartRequestParameter;
import org.apache.sling.engine.impl.parameters.ParameterMap;
import org.apache.sling.engine.impl.parameters.SlingUnsupportedEncodingException;
import org.apache.sling.engine.impl.parameters.Util;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSupport {
    private static final String ATTR_NAME = ParameterSupport.class.getName();
    private static final String ATTR_JETTY_QUERY_ENCODING = "org.mortbay.jetty.Request.queryEncoding";
    private final HttpServletRequest servletRequest;
    private ParameterMap postParameterMap;
    private boolean requestDataUsed;

    public static void setDefaultParameterEncoding(String encoding) {
        Util.setDefaultFixEncoding(encoding);
    }

    public static ParameterSupport getInstance(ServletRequest servletRequest) {
        ParameterSupport instance = (ParameterSupport)servletRequest.getAttribute(ATTR_NAME);
        if (instance == null) {
            instance = new ParameterSupport((HttpServletRequest)servletRequest);
            servletRequest.setAttribute(ATTR_NAME, (Object)instance);
            servletRequest.setAttribute(ATTR_JETTY_QUERY_ENCODING, (Object)"ISO-8859-1");
        }
        return instance;
    }

    private ParameterSupport(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    private HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public boolean requestDataUsed() {
        return this.requestDataUsed;
    }

    public String getParameter(String name) {
        return this.getRequestParameterMapInternal().getStringValue(name);
    }

    public String[] getParameterValues(String name) {
        return this.getRequestParameterMapInternal().getStringValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.getRequestParameterMapInternal().getStringParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return new IteratorEnumeration(this.getRequestParameterMapInternal().keySet().iterator());
    }

    public RequestParameter getRequestParameter(String name) {
        return this.getRequestParameterMapInternal().getValue(name);
    }

    public RequestParameter[] getRequestParameters(String name) {
        return this.getRequestParameterMapInternal().getValues(name);
    }

    public RequestParameterMap getRequestParameterMap() {
        return this.getRequestParameterMapInternal();
    }

    private ParameterMap getRequestParameterMapInternal() {
        if (this.postParameterMap == null) {
            ParameterMap parameters = new ParameterMap();
            this.getContainerParameters(parameters);
            if ("POST".equals(this.getServletRequest().getMethod()) && ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(this.getServletRequest()))) {
                this.parseMultiPartPost(parameters);
                this.requestDataUsed = true;
            }
            Util.fixEncoding(parameters);
            this.postParameterMap = parameters;
        }
        return this.postParameterMap;
    }

    private void getContainerParameters(ParameterMap parameters) {
        String encoding = this.getServletRequest().getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
            try {
                this.getServletRequest().setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SlingUnsupportedEncodingException(uee);
            }
        }
        Map pMap = this.getServletRequest().getParameterMap();
        for (Map.Entry entry : pMap.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                parameters.addParameter(name, new ContainerRequestParameter(values[i], encoding));
            }
        }
    }

    private void parseMultiPartPost(ParameterMap parameters) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(256000);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(-1L);
        ServletRequestContext rc = new ServletRequestContext(this.getServletRequest()){

            public String getCharacterEncoding() {
                String enc = super.getCharacterEncoding();
                return enc != null ? enc : "ISO-8859-1";
            }
        };
        List items = null;
        try {
            items = upload.parseRequest((RequestContext)rc);
        }
        catch (FileUploadException fue) {
            LoggerFactory.getLogger(this.getClass()).error("parseMultiPartPost: Error parsing request", (Throwable)fue);
        }
        if (items != null && items.size() > 0) {
            for (FileItem fileItem : items) {
                MultipartRequestParameter pp = new MultipartRequestParameter(fileItem);
                parameters.addParameter(fileItem.getFieldName(), pp);
            }
        }
    }
}

