/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Filter;

public class SlingFilterChainHelper {
    SortedSet<FilterListEntry> filterList;
    Filter[] filters;

    SlingFilterChainHelper() {
    }

    public synchronized Filter addFilter(Filter filter, Long filterId, int order) {
        this.filters = null;
        if (this.filterList == null) {
            this.filterList = new TreeSet<FilterListEntry>();
        }
        this.filterList.add(new FilterListEntry(filter, filterId, order));
        return filter;
    }

    public synchronized Filter[] removeAllFilters() {
        Filter[] removedFilters = this.getFilters();
        this.filters = null;
        this.filterList = null;
        return removedFilters;
    }

    public synchronized Filter removeFilter(Filter filter) {
        if (this.filterList != null) {
            this.filters = null;
            Iterator fi = this.filterList.iterator();
            while (fi.hasNext()) {
                FilterListEntry test = (FilterListEntry)fi.next();
                if (!test.getFilter().equals(filter)) continue;
                fi.remove();
                return test.getFilter();
            }
        }
        return null;
    }

    public synchronized boolean removeFilterById(Object filterId) {
        if (this.filterList != null) {
            this.filters = null;
            Iterator fi = this.filterList.iterator();
            while (fi.hasNext()) {
                FilterListEntry test = (FilterListEntry)fi.next();
                if (test.getFitlerId() != filterId && (test.getFitlerId() == null || !test.getFitlerId().equals(filterId))) continue;
                fi.remove();
                return true;
            }
        }
        return false;
    }

    public synchronized Filter[] getFilters() {
        if (this.filters == null && this.filterList != null && !this.filterList.isEmpty()) {
            Filter[] tmp = new Filter[this.filterList.size()];
            int i = 0;
            for (FilterListEntry entry : this.filterList) {
                tmp[i] = entry.getFilter();
                ++i;
            }
            this.filters = tmp;
        }
        return this.filters;
    }

    public synchronized FilterListEntry[] getFilterListEntries() {
        FilterListEntry[] result = null;
        if (this.filterList != null && !this.filterList.isEmpty()) {
            result = new FilterListEntry[this.filterList.size()];
            this.filterList.toArray(result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterListEntry
    implements Comparable<FilterListEntry> {
        private final Filter filter;
        private final Long filterId;
        private final int order;

        FilterListEntry(Filter filter, Long filterId, int order) {
            this.filter = filter;
            this.filterId = filterId;
            this.order = order;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Long getFitlerId() {
            return this.filterId;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(FilterListEntry other) {
            int comp;
            if (this == other || this.equals(other)) {
                return 0;
            }
            if (this.order < other.order) {
                return -1;
            }
            if (this.order > other.order) {
                return 1;
            }
            if (this.filterId != null && other.filterId != null && (comp = this.filterId.compareTo(other.filterId)) != 0) {
                return comp;
            }
            return 1;
        }

        public int hashCode() {
            if (this.filter == null) {
                return 0;
            }
            return this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FilterListEntry) {
                FilterListEntry other = (FilterListEntry)obj;
                return this.getFilter().equals(other.getFilter());
            }
            return false;
        }
    }
}

