/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.debug;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.engine.impl.request.SlingRequestProgressTracker;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="%rpt.log.name", description="%rpt.log.description")
@Service
@Properties(value={@Property(name="service.description", value={"RequestProgressTracker dump filter"}, propertyPrivate=true), @Property(name="service.vendor", value={"The Apache Software Foundation"}, propertyPrivate=true), @Property(name="filter.scope", value={"request"}, propertyPrivate=true)})
public class RequestProgressTrackerLogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestProgressTrackerLogFilter.class);
    private int requestCounter;
    private static final String[] DEFAULT_EXTENSIONS = new String[0];
    private String[] extensions = DEFAULT_EXTENSIONS;
    @Property(value={}, cardinality=0x7FFFFFFF)
    private static final String NAME_EXTENSIONS = "extensions";
    private static final int DEFAULT_MIN_DURATION = 0;
    private int minDurationMs = 0;
    @Property(intValue={0})
    private static final String NAME_MIN_DURATION = "minDurationMs";
    private static final int DEFAULT_MAX_DURATION = Integer.MAX_VALUE;
    private int maxDurationMs = Integer.MAX_VALUE;
    @Property(intValue={0x7FFFFFFF})
    private static final String NAME_MAX_DURATION = "maxDurationMs";
    private static final boolean DEFAULT_COMPACT_LOG_FORMAT = false;
    private boolean compactLogFormat = false;
    @Property(boolValue={false})
    private static final String NAME_COMPACT_LOG_FORMAT = "compactLogFormat";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            RequestProgressTracker rpt = slingRequest.getRequestProgressTracker();
            rpt.done();
            if (log.isDebugEnabled() && this.allowDuration(rpt) && this.allowExtension(this.extractExtension(slingRequest))) {
                if (this.compactLogFormat) {
                    this.logCompactFormat(rpt);
                } else {
                    this.logDefaultFormat(rpt);
                }
            }
        }
    }

    public void destroy() {
    }

    private void logCompactFormat(RequestProgressTracker rpt) {
        Iterator messages = rpt.getMessages();
        StringBuilder sb = new StringBuilder("\n");
        while (messages.hasNext()) {
            sb.append((String)messages.next());
        }
        sb.setLength(sb.length() - 1);
        log.debug(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDefaultFormat(RequestProgressTracker rpt) {
        int requestId = 0;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            requestId = ++this.requestCounter;
        }
        Iterator it = rpt.getMessages();
        while (it.hasNext()) {
            log.debug("REQUEST_{} - " + (String)it.next(), (Object)requestId);
        }
    }

    private String extractExtension(SlingHttpServletRequest request) {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        String extension = requestPathInfo.getExtension();
        if (extension == null) {
            String pathInfo = requestPathInfo.getResourcePath();
            int extensionIndex = pathInfo.lastIndexOf(46) + 1;
            extension = pathInfo.substring(extensionIndex);
        }
        return extension;
    }

    private boolean allowExtension(String extension) {
        return this.extensions.length == 0 || Arrays.binarySearch(this.extensions, extension) > -1;
    }

    private boolean allowDuration(RequestProgressTracker rpt) {
        if (rpt instanceof SlingRequestProgressTracker) {
            long duration = ((SlingRequestProgressTracker)rpt).getDuration();
            return (long)this.minDurationMs <= duration && duration <= (long)this.maxDurationMs;
        }
        log.debug("Logged requests can only be filtered by duration if the SlingRequestProgressTracker is used.");
        return true;
    }

    private String[] sortAndClean(String[] strings) {
        if (strings.length == 0) {
            return strings;
        }
        Arrays.sort(strings);
        int skip = 0;
        for (int i = strings.length - 1; i > -1; --i) {
            if (strings[i].length() != 0) continue;
            ++skip;
        }
        return skip == 0 ? strings : Arrays.copyOfRange(strings, skip, strings.length);
    }

    @Activate
    private void activate(ComponentContext ctx) {
        Dictionary p = ctx.getProperties();
        this.extensions = this.sortAndClean(PropertiesUtil.toStringArray(p.get(NAME_EXTENSIONS), (String[])DEFAULT_EXTENSIONS));
        this.minDurationMs = PropertiesUtil.toInteger(p.get(NAME_MIN_DURATION), (int)0);
        this.maxDurationMs = PropertiesUtil.toInteger(p.get(NAME_MAX_DURATION), (int)Integer.MAX_VALUE);
        this.compactLogFormat = PropertiesUtil.toBoolean(p.get(NAME_COMPACT_LOG_FORMAT), (boolean)false);
        log.debug("activated: extensions = {}, min = {}, max = {}, compact = {}", new Object[]{this.extensions, this.minDurationMs, this.maxDurationMs, this.compactLogFormat});
    }
}

