/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.request.RequestProgressTracker;

public class SlingRequestProgressTracker
implements RequestProgressTracker {
    private static final String REQUEST_PROCESSING_TIMER = "Request Processing";
    private static final String LOG_PREFIX = "LOG ";
    private static final String COMMENT_PREFIX = "COMMENT ";
    private static final String TIMER_END_FORMAT = "{<elapsed msec>,<timer name>} <optional message>";
    private static final int PADDING_WIDTH = 7;
    private long processingStart;
    private long processingEnd;
    private final List<TrackingEntry> entries = new ArrayList<TrackingEntry>();
    private final Map<String, Long> namedTimerEntries = new HashMap<String, Long>();

    public SlingRequestProgressTracker() {
        this.reset();
    }

    public void reset() {
        this.entries.clear();
        this.namedTimerEntries.clear();
        this.processingStart = this.startTimerInternal(REQUEST_PROCESSING_TIMER);
        this.processingEnd = -1L;
        this.entries.add(new TrackingEntry("COMMENT timer_end format is {<elapsed msec>,<timer name>} <optional message>"));
    }

    public Iterator<String> getMessages() {
        return new Iterator<String>(){
            private final Iterator<TrackingEntry> entryIter;
            {
                this.entryIter = SlingRequestProgressTracker.this.entries.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIter.hasNext();
            }

            @Override
            public String next() {
                TrackingEntry entry = this.entryIter.next();
                long offset = entry.getTimeStamp() - SlingRequestProgressTracker.this.getTimeStamp();
                return SlingRequestProgressTracker.this.formatMessage(offset, entry.getMessage());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private String formatMessage(long offset, String message) {
        StringBuilder sb = new StringBuilder(8 + message.length() + 1);
        String offsetStr = Long.toString(offset);
        for (int i = 7 - offsetStr.length(); i > 0; --i) {
            sb.append(' ');
        }
        sb.append(offsetStr).append(' ').append(message).append('\n');
        return sb.toString();
    }

    public void dump(PrintWriter writer) {
        this.logTimer(REQUEST_PROCESSING_TIMER, "Dumping SlingRequestProgressTracker Entries", new Object[0]);
        StringBuilder sb = new StringBuilder();
        Iterator<String> messages = this.getMessages();
        while (messages.hasNext()) {
            sb.append(messages.next());
        }
        writer.print(sb.toString());
    }

    public void log(String message) {
        this.entries.add(new TrackingEntry(LOG_PREFIX + message));
    }

    public void log(String format, Object ... args) {
        String message = MessageFormat.format(format, args);
        this.entries.add(new TrackingEntry(LOG_PREFIX + message));
    }

    public void startTimer(String name) {
        this.startTimerInternal(name);
    }

    private long startTimerInternal(String name) {
        long timer = System.currentTimeMillis();
        this.namedTimerEntries.put(name, timer);
        this.entries.add(new TrackingEntry(timer, "TIMER_START{" + name + "}"));
        return timer;
    }

    public void logTimer(String name) {
        if (this.namedTimerEntries.containsKey(name)) {
            this.logTimerInternal(name, null, this.namedTimerEntries.get(name));
        }
    }

    public void logTimer(String name, String format, Object ... args) {
        if (this.namedTimerEntries.containsKey(name)) {
            this.logTimerInternal(name, MessageFormat.format(format, args), this.namedTimerEntries.get(name));
        }
    }

    private void logTimerInternal(String name, String msg, long startTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("TIMER_END{");
        sb.append(System.currentTimeMillis() - startTime);
        sb.append(',');
        sb.append(name);
        sb.append('}');
        if (msg != null) {
            sb.append(' ');
            sb.append(msg);
        }
        this.entries.add(new TrackingEntry(sb.toString()));
    }

    public void done() {
        if (this.processingEnd != -1L) {
            return;
        }
        this.logTimer(REQUEST_PROCESSING_TIMER, REQUEST_PROCESSING_TIMER, new Object[0]);
        this.processingEnd = System.currentTimeMillis();
    }

    private long getTimeStamp() {
        return this.processingStart;
    }

    public long getDuration() {
        if (this.processingEnd != -1L) {
            return this.processingEnd - this.processingStart;
        }
        return System.currentTimeMillis() - this.processingStart;
    }

    private static class TrackingEntry {
        private final long timeStamp;
        private final String message;

        TrackingEntry(String message) {
            this.timeStamp = System.currentTimeMillis();
            this.message = message;
        }

        TrackingEntry(long timeStamp, String message) {
            this.timeStamp = timeStamp;
            this.message = message;
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        String getMessage() {
            return this.message;
        }
    }
}

