/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.engine.RequestLog;
import org.apache.sling.engine.impl.log.CustomLogFormat;
import org.apache.sling.engine.impl.log.FileRequestLog;
import org.apache.sling.engine.impl.log.LoggerRequestLog;
import org.apache.sling.engine.impl.log.RequestLogServiceFacade;
import org.apache.sling.engine.impl.log.RequestLoggerRequest;
import org.apache.sling.engine.impl.log.RequestLoggerResponse;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="%request.log.service.name", description="%request.log.service.description", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="service.description", value={"Factory for configuration based request/access loggers"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
@Service(value={RequestLoggerService.class})
public class RequestLoggerService {
    @Property
    public static final String PARAM_FORMAT = "request.log.service.format";
    @Property(value={"request.log"})
    public static final String PARAM_OUTPUT = "request.log.service.output";
    @Property(intValue={0}, options={@PropertyOption(name="0", value="Logger Name"), @PropertyOption(name="1", value="File Name"), @PropertyOption(name="2", value="RequestLog Service")})
    public static final String PARAM_OUTPUT_TYPE = "request.log.service.outputtype";
    @Property(boolValue={false})
    public static final String PARAM_ON_ENTRY = "request.log.service.onentry";
    private static final int OUTPUT_TYPE_LOGGER = 0;
    private static final int OUTPUT_TYPE_FILE = 1;
    private static final int OUTPUT_TYPE_CLASS = 2;
    private boolean onEntry;
    private CustomLogFormat logFormat;
    private RequestLog log;

    public RequestLoggerService() {
    }

    RequestLoggerService(BundleContext bundleContext, Map<String, Object> configuration) {
        this.setup(bundleContext, configuration);
    }

    @Activate
    void setup(BundleContext bundleContext, Map<String, Object> configuration) {
        Object output;
        Object onEntryObject = configuration.get(PARAM_ON_ENTRY);
        this.onEntry = onEntryObject instanceof Boolean ? (Boolean)onEntryObject : false;
        Object format = configuration.get(PARAM_FORMAT);
        if (format != null) {
            this.logFormat = new CustomLogFormat(format.toString());
        }
        if ((output = configuration.get(PARAM_OUTPUT)) != null) {
            Object outputTypeObject = configuration.get(PARAM_OUTPUT_TYPE);
            int outputType = outputTypeObject instanceof Number ? ((Number)outputTypeObject).intValue() : 0;
            this.log = this.getLog(bundleContext, output.toString(), outputType);
        }
    }

    @Deactivate
    void shutdown() {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        this.logFormat = null;
    }

    void log(RequestLoggerRequest request, RequestLoggerResponse response) {
        if (this.log != null && this.logFormat != null) {
            this.log.write(this.logFormat.format(request, response));
        }
    }

    boolean isOnEntry() {
        return this.onEntry;
    }

    private RequestLog getLog(BundleContext bundleContext, String output, int outputType) {
        switch (outputType) {
            case 1: {
                try {
                    File file = new File(output);
                    if (!file.isAbsolute()) {
                        String home = bundleContext.getProperty("sling.home");
                        if (home != null) {
                            file = new File(home, output);
                        }
                        file = file.getAbsoluteFile();
                    }
                    return new FileRequestLog(file);
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 2: {
                if (bundleContext == null) break;
                return new RequestLogServiceFacade(bundleContext, output);
            }
            default: {
                return new LoggerRequestLog(output);
            }
        }
        return null;
    }
}

